/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav;

import de.inahware.dav.DocumentRenderer;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.Order;
import de.inahware.dav.models.Setting;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.Text;
import de.inahware.dav.models.User;
import de.inahware.dav.models.Vendor;
import de.inahware.edvj.VersionInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.jooq.DSLContext;

public class DefaultDocumentRenderer
extends DocumentRenderer {
    private VersionInfo version;
    private Path storagePath;
    private DSLContext dsl;

    public DefaultDocumentRenderer(VersionInfo version, ResourceBundle bundle, Path storagePath, DSLContext dsl) {
        super(bundle);
        this.version = version;
        this.storagePath = storagePath;
        this.dsl = dsl;
    }

    @Override
    protected VersionInfo getVersion() {
        return this.version;
    }

    @Override
    protected Properties querySettings() throws Exception {
        Properties res = new Properties();
        Iterator iterator = this.dsl.selectFrom(Tables.SETTING).fetchInto(Setting.class).iterator();
        while (iterator.hasNext()) {
            Setting s = (Setting)iterator.next();
            res.put(s.getName(), s.getValue());
        }
        return res;
    }

    @Override
    protected Path queryLogo() throws Exception {
        Path logo = this.storagePath.resolve("logo.png");
        if (!Files.exists(logo, new LinkOption[0])) {
            return null;
        }
        Path tmp = Files.createTempFile("inahware-dav-logo-", ".png", new FileAttribute[0]);
        Files.copy(logo, tmp, StandardCopyOption.REPLACE_EXISTING);
        return tmp;
    }

    @Override
    protected List<Text> queryTexts() throws Exception {
        return this.dsl.selectFrom(Tables.TEXT).fetchInto(Text.class);
    }

    @Override
    protected List<TaxRate> queryTaxRates() throws Exception {
        return this.dsl.selectFrom(Tables.TAX_RATE).fetchInto(TaxRate.class);
    }

    @Override
    protected User queryUser(Long id) throws Exception {
        return this.dsl.selectFrom(Tables.USER).where(User.COL_ID.eq(this.dsl, id)).fetchAnyInto(User.class);
    }

    @Override
    protected Customer queryCustomer(Long id) throws Exception {
        return this.dsl.selectFrom(Tables.CUSTOMER).where(Customer.COL_ID.eq(this.dsl, id)).fetchAnyInto(Customer.class);
    }

    @Override
    protected Vendor queryVendor(Long id) throws Exception {
        return this.dsl.selectFrom(Tables.VENDOR).where(Vendor.COL_ID.eq(this.dsl, id)).fetchAnyInto(Vendor.class);
    }

    @Override
    protected Order queryOrder(Long id) throws Exception {
        return this.dsl.selectFrom(Tables.ORDER).where(Order.COL_ID.eq(this.dsl, id)).fetchAnyInto(Order.class);
    }

    @Override
    protected DocumentFull queryDocument(Long id) throws Exception {
        DocumentFull document = this.dsl.selectFrom(Tables.DOCUMENT).where(DocumentFull.COL_ID.eq(this.dsl, id)).fetchAnyInto(DocumentFull.class);
        return new DocumentFull(document, this.dsl);
    }
}

