/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav;

import de.inahware.dav.Info;
import de.inahware.dav.LaTeXOutputFormat;
import de.inahware.dav.LaTeXUtils;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.Notice;
import de.inahware.dav.models.Order;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.Text;
import de.inahware.dav.models.User;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.models.types.TotalPrice;
import de.inahware.edvj.VersionInfo;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import no.api.freemarker.java8.Java8ObjectWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.pdmodel.PDDocument;

public abstract class DocumentRenderer {
    private ResourceBundle bundle;
    private Configuration config;
    private boolean debug = false;

    public DocumentRenderer(ResourceBundle bundle) {
        this.bundle = bundle;
        this.config = new Configuration(Configuration.VERSION_2_3_31);
        this.config.setIncompatibleImprovements(Configuration.VERSION_2_3_31);
        this.config.setObjectWrapper(new Java8ObjectWrapper(Configuration.VERSION_2_3_31));
        this.config.setRegisteredCustomOutputFormats(List.of(LaTeXOutputFormat.INSTANCE));
        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.config.setLogTemplateExceptions(false);
        this.config.setWrapUncheckedExceptions(true);
        this.config.setFallbackOnNullLoopVariable(false);
        this.config.setAPIBuiltinEnabled(true);
        this.config.setDefaultEncoding("UTF-8");
        this.config.setClassForTemplateLoading(this.getClass(), "/de/inahware/dav/templates");
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public PDDocument renderDocument(DocumentFull document, boolean headless) throws Exception {
        Path tmp = Files.createTempDirectory("inahware-dav-latex-", new FileAttribute[0]);
        Path tmp_tex = tmp.resolve("doc.tex");
        Map<String, Object> root = this.initModel(tmp, headless);
        this.insertDocument(root, document);
        boolean showUnits = document.getItems().stream().anyMatch(entry -> entry.getUnit() != null && !entry.getUnit().isEmpty());
        root.put("showUnits", showUnits);
        boolean showPrices = document.getType().getDisplayPrices();
        root.put("showPrices", showPrices);
        boolean showDiscount = document.getItems().stream().anyMatch(entry -> entry.getDiscount().compareTo(BigDecimal.ZERO) != 0);
        root.put("showDiscount", showDiscount);
        List<TaxRate> taxRates = this.queryTaxRates();
        root.put("taxRates", taxRates);
        TotalPrice price = document.computeTotalPrice(taxRates);
        root.put("price", price);
        root.put("showTaxes", price.getTaxes().size() > 1);
        Template template = this.config.getTemplate("document.tex.ftl");
        try (Object output = new PrintWriter(tmp_tex.toFile(), "UTF-8");){
            template.process(root, (Writer)output);
        }
        output = LaTeXUtils.render(DocumentRenderer.findLatex(), tmp_tex);
        byte[] pdf = FileUtils.readFileToByteArray(output.toFile());
        PDDocument res = PDDocument.load(pdf);
        FileUtils.deleteDirectory(tmp.toFile());
        return res;
    }

    public PDDocument renderNotice(Notice notice, boolean headless) throws Exception {
        Path tmp = Files.createTempDirectory("inahware-dav-latex-", new FileAttribute[0]);
        Path tmp_tex = tmp.resolve("doc.tex");
        Map<String, Object> root = this.initModel(tmp, headless);
        root.put("notice", notice);
        DocumentFull document = this.queryDocument(notice.getDocumentId());
        this.insertDocument(root, document);
        Template template = this.config.getTemplate("notice.tex.ftl");
        try (Object output = new PrintWriter(tmp_tex.toFile(), "UTF-8");){
            template.process(root, (Writer)output);
        }
        output = LaTeXUtils.render(DocumentRenderer.findLatex(), tmp_tex);
        byte[] pdf = FileUtils.readFileToByteArray(output.toFile());
        PDDocument res = PDDocument.load(pdf);
        FileUtils.deleteDirectory(tmp.toFile());
        return res;
    }

    private Map<String, Object> initModel(Path path, boolean headless) throws Exception {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("demo", this.getVersion() == Info.DEMO.getVersion());
        root.put("debug", this.debug);
        root.put("bundle", this.bundle);
        root.put("countries", Locale.getISOCountries(Locale.IsoCountryCode.PART1_ALPHA2).stream().collect(Collectors.toMap(c -> c, c -> new Locale("", (String)c).getDisplayCountry(Locale.ENGLISH).toUpperCase(Locale.ENGLISH))));
        root.put("settings", this.querySettings());
        Path logo = this.queryLogo();
        if (logo != null) {
            Files.move(logo, path.resolve("logo.png"), new CopyOption[0]);
            root.put("logo", "logo.png");
        }
        Map<String, String> texts = this.queryTexts().stream().collect(Collectors.toMap(text -> text.getName(), text -> text.getText()));
        root.put("texts", texts);
        root.put("headless", headless);
        root.put("today", LocalDate.now());
        return root;
    }

    private void insertDocument(Map<String, Object> root, DocumentFull document) throws Exception {
        root.put("document", document);
        root.put("documentUsesVendor", document.getType().usesVendor());
        if (document.getUserId() != null) {
            User user = this.queryUser(document.getUserId());
            root.put("user", user);
        }
        if (document.getCustomerId() != null) {
            Customer customer = this.queryCustomer(document.getCustomerId());
            root.put("customer", customer);
        }
        if (document.getVendorId() != null) {
            Vendor vendor = this.queryVendor(document.getVendorId());
            root.put("vendor", vendor);
        }
        if (document.getOrders().size() == 1) {
            Order order = this.queryOrder(document.getOrders().get(0));
            root.put("order", order);
        }
        ArrayList<DocumentFull> parents = new ArrayList<DocumentFull>();
        for (Long id : document.getParents()) {
            parents.add(this.queryDocument(id));
        }
        root.put("parents", parents);
    }

    private static Path findLatex() {
        Path latex = LaTeXUtils.findLatex(Path.of(System.getProperty("user.dir"), new String[0]).resolve("../texlive/bin/win32"));
        if (latex == null) {
            throw new RuntimeException("latex not found");
        }
        return latex;
    }

    protected abstract VersionInfo getVersion();

    protected abstract Properties querySettings() throws Exception;

    protected abstract Path queryLogo() throws Exception;

    protected abstract List<Text> queryTexts() throws Exception;

    protected abstract List<TaxRate> queryTaxRates() throws Exception;

    protected abstract User queryUser(Long var1) throws Exception;

    protected abstract Customer queryCustomer(Long var1) throws Exception;

    protected abstract Vendor queryVendor(Long var1) throws Exception;

    protected abstract Order queryOrder(Long var1) throws Exception;

    protected abstract DocumentFull queryDocument(Long var1) throws Exception;
}

