/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.lang3.ArrayUtils;

public class Hashing {
    private static final String[] ALGORITHMS = new String[]{"PBKDF2_SHA256_65536"};
    private static final String DEFAULT = "PBKDF2_SHA256_65536";

    public static String[] getAlgorithms() {
        return ALGORITHMS;
    }

    public static String getDefault() {
        return DEFAULT;
    }

    public static byte[] generatePasswordHashEntry(String algorithm, char[] password) throws GeneralSecurityException {
        switch (algorithm) {
            case "PBKDF2_SHA256_65536": {
                byte[] salt = Hashing.generateRandomBytes(32);
                byte[] hash = Hashing.computePBKDF2WithHmacSHA256(salt, password, 65536);
                return ArrayUtils.addAll(salt, hash);
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean verifyPasswordHashEntry(String algorithm, byte[] entry, char[] password) throws GeneralSecurityException {
        switch (algorithm) {
            case "PBKDF2_SHA256_65536": {
                byte[] salt = Arrays.copyOfRange(entry, 0, 32);
                byte[] hash = Arrays.copyOfRange(entry, 32, 64);
                byte[] hash2 = Hashing.computePBKDF2WithHmacSHA256(salt, password, 65536);
                return Arrays.equals(hash, hash2);
            }
        }
        throw new IllegalArgumentException();
    }

    private static byte[] generateRandomBytes(int size) {
        SecureRandom random = new SecureRandom();
        byte[] res = new byte[size];
        random.nextBytes(res);
        return res;
    }

    private static byte[] computePBKDF2WithHmacSHA256(byte[] salt, char[] password, int n_iter) throws GeneralSecurityException {
        PBEKeySpec spec = new PBEKeySpec(password, salt, n_iter, 256);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        return factory.generateSecret(spec).getEncoded();
    }
}

