/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav;

import de.inahware.dav.LaTeXOutputModel;
import de.inahware.dav.LaTeXUtils;
import freemarker.core.CommonMarkupOutputFormat;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;

public class LaTeXOutputFormat
extends CommonMarkupOutputFormat<LaTeXOutputModel> {
    public static final LaTeXOutputFormat INSTANCE = new LaTeXOutputFormat();

    protected LaTeXOutputFormat() {
    }

    @Override
    public String getName() {
        return "LaTeX";
    }

    @Override
    public String getMimeType() {
        return "application/x-latex";
    }

    @Override
    public void output(String textToEsc, Writer out) throws IOException, TemplateModelException {
        out.append(LaTeXUtils.escape(textToEsc));
    }

    @Override
    public String escapePlainText(String plainTextContent) throws TemplateModelException {
        return LaTeXUtils.escape(plainTextContent);
    }

    @Override
    public boolean isLegacyBuiltInBypassed(String builtInName) throws TemplateModelException {
        return builtInName.equals("latex");
    }

    @Override
    protected LaTeXOutputModel newTemplateMarkupOutputModel(String plainTextContent, String markupContent) throws TemplateModelException {
        return new LaTeXOutputModel(plainTextContent, markupContent);
    }
}

