/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaTeXUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LaTeXUtils.class.getName());

    public static String escape(String str) {
        return str.replace("\\", "\\\\").replace("_", "\\_").replace("^", "\\^").replace("~", "\\~").replace("$", "\\$").replace("%", "\\%").replace("#", "\\#").replace("&", "\\&").replace("{", "\\{").replace("}", "\\}");
    }

    public static Path findLatex(Path ... paths) {
        for (Path path : paths) {
            if (Files.isRegularFile(path.resolve("pdflatex"), new LinkOption[0])) {
                return path.resolve("pdflatex");
            }
            if (!Files.isRegularFile(path.resolve("pdflatex.exe"), new LinkOption[0])) continue;
            return path.resolve("pdflatex.exe");
        }
        for (String next : System.getenv("PATH").split(File.pathSeparator)) {
            Path path = Path.of(next, new String[0]);
            if (Files.isRegularFile(path.resolve("pdflatex"), new LinkOption[0])) {
                return path.resolve("pdflatex");
            }
            if (!Files.isRegularFile(path.resolve("pdflatex.exe"), new LinkOption[0])) continue;
            return path.resolve("pdflatex.exe");
        }
        return null;
    }

    public static Path render(Path latex, Path latexInput) throws Exception {
        Path base = latexInput.getParent();
        String name = FilenameUtils.removeExtension(latexInput.getFileName().toString());
        Path output = base.resolve(name + ".pdf");
        Path logfile = base.resolve(name + ".log");
        Process pdflatex = new ProcessBuilder(latex.toString(), "-interaction=nonstopmode", latexInput.getFileName().toString()).directory(latexInput.getParent().toFile()).redirectOutput(ProcessBuilder.Redirect.DISCARD).redirectError(ProcessBuilder.Redirect.DISCARD).start();
        pdflatex.getInputStream().close();
        pdflatex.waitFor();
        if (pdflatex.exitValue() != 0) {
            LOGGER.error("pdflatex exited with exit code " + pdflatex.exitValue() + ", dumping log:\n" + Files.readString(logfile));
            throw new RuntimeException();
        }
        return output;
    }
}

