/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav;

import de.inahware.edvj.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Properties;

public class RemoteClientConfig {
    private String profileName;
    private String remoteUrl;
    private String remoteSession;

    public RemoteClientConfig() {
    }

    public RemoteClientConfig(RemoteClientConfig config) {
        this.profileName = config.profileName;
        this.remoteUrl = config.remoteUrl;
        this.remoteSession = config.remoteSession;
    }

    public RemoteClientConfig(Properties config) {
        this.profileName = config.getProperty("profile.name");
        this.remoteUrl = config.getProperty("remote.url");
        this.remoteSession = config.getProperty("remote.session");
    }

    public static RemoteClientConfig fromFile(Path file) throws IOException {
        Properties config = Utils.readConfig(file);
        return new RemoteClientConfig(config);
    }

    public Properties toProperties() {
        Properties config = new Properties();
        config.setProperty("profile.name", this.profileName);
        config.setProperty("remote.url", this.remoteUrl);
        if (this.remoteSession != null) {
            config.setProperty("remote.session", this.remoteSession);
        }
        return config;
    }

    public void write(Path file) throws IOException {
        Utils.writeConfig(this.toProperties(), file, "remote client config");
    }

    public void write(OutputStream output) throws IOException {
        this.toProperties().store(output, "remote client config");
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getRemoteSession() {
        return this.remoteSession;
    }

    public void setRemoteSession(String remoteSession) {
        this.remoteSession = remoteSession;
    }
}

