/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.inahware.dav.models.Models;
import java.nio.file.Path;
import java.security.SecureRandom;

public class Session {
    private static final int SESSION_TOKEN_LENGTH = 32;
    private static final String SESSION_TOKEN_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private String token;
    private boolean temp;
    private Long login;
    private Path uploadedFile;
    private Path downloadFile;

    public Session() {
    }

    public Session(String token) {
        this(token, false);
    }

    public Session(String token, boolean temp) {
        this.token = token;
        this.temp = temp;
    }

    public String getToken() {
        return this.token;
    }

    public boolean isTemp() {
        return this.temp;
    }

    public void setTemp(boolean temp) {
        this.temp = temp;
    }

    public Long getLogin() {
        return this.login;
    }

    public void setLogin(Long login) {
        this.login = login;
    }

    public Path getUploadedFile() {
        return this.uploadedFile;
    }

    public void setUploadedFile(Path uploadedFile) {
        this.uploadedFile = uploadedFile;
    }

    public Path getDownloadFile() {
        return this.downloadFile;
    }

    public void setDownloadFile(Path downloadFile) {
        this.downloadFile = downloadFile;
    }

    public String toJson() throws JsonProcessingException {
        return Models.MAPPER.writeValueAsString(this);
    }

    public static Session fromJson(String json) throws JsonProcessingException {
        return Models.MAPPER.readValue(json, Session.class);
    }

    public static String generateToken() {
        SecureRandom rng = new SecureRandom();
        StringBuilder token = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            int idx = rng.nextInt(SESSION_TOKEN_CHARS.length());
            token.append(SESSION_TOKEN_CHARS.charAt(idx));
        }
        return token.toString();
    }
}

