/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client;

import de.inahware.dav.models.User;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.GetLogin;
import de.inahware.dav.requests.GetPermissions;
import de.inahware.dav.requests.Login;
import de.inahware.dav.requests.Logout;
import de.inahware.edvj.VersionInfo;
import de.inahware.edvj.data.AttributeSet;
import de.inahware.edvj.query.Queryable;
import de.inahware.edvj.request.RequestException;
import java.nio.file.Path;
import java.util.function.LongConsumer;

public abstract class BaseClient
implements Queryable {
    private VersionInfo version;
    private boolean singleUser;
    private User login;
    private AttributeSet permissions;

    public BaseClient(VersionInfo version) {
        this.version = version;
        this.login = null;
        this.permissions = new AttributeSet();
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public boolean isSingleUser() {
        return this.singleUser;
    }

    public User getLogin() {
        return this.login;
    }

    public AttributeSet getPermissions() {
        return this.permissions;
    }

    public User login(String username, char[] password) throws Exception {
        User login;
        this.login = login = this.query(new Login(username, password));
        this.permissions = this.query(new GetPermissions());
        return login;
    }

    public void logout() throws Exception {
        this.query(new Logout());
        this.login = null;
        this.permissions = new AttributeSet();
    }

    public void upload(Path path) throws Exception {
        this.upload(path, null);
    }

    public Path download() throws Exception {
        return this.download(null);
    }

    protected void connected() throws Exception {
        this.login = this.query(new GetLogin());
        this.permissions = this.query(new GetPermissions());
        if (this.login == null) {
            try {
                this.login(null, null);
                this.singleUser = true;
            }
            catch (RequestException requestException) {
                // empty catch block
            }
        }
    }

    public abstract void setup() throws Exception;

    public abstract void connect() throws Exception;

    public abstract void shutdown();

    public abstract <T> T query(ClientRequest<T> var1) throws Exception;

    public abstract void upload(Path var1, LongConsumer var2) throws Exception;

    public abstract Path download(LongConsumer var1) throws Exception;
}

