/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client;

import de.inahware.dav.RemoteClientConfig;
import de.inahware.dav.client.BaseClient;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.ClientExtension;
import de.inahware.dav.client.LocalClient;
import de.inahware.dav.client.LocalClientConfig;
import de.inahware.dav.client.RemoteClient;
import de.inahware.dav.client.gui.MainWindow;
import de.inahware.dav.client.gui.StartupWindow;
import de.inahware.dav.models.ModelExtension;
import de.inahware.edvj.Utils;
import de.inahware.edvj.VersionInfo;
import de.inahware.products.ProductInfo;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMain.class.getName());
    private ProductInfo product;
    private ModelExtension[] modelExtensions;
    private ClientExtension[] clientExtensions;

    public BaseMain(ProductInfo product) {
        this(product, new ModelExtension[0], new ClientExtension[0]);
    }

    public BaseMain(ProductInfo product, ModelExtension[] modelExtensions, ClientExtension[] clientExtensions) {
        this.product = product;
        this.modelExtensions = modelExtensions;
        this.clientExtensions = clientExtensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(String[] args) throws Exception {
        Locale.setDefault(Locale.GERMANY);
        if (args.length >= 1) {
            Path file = Path.of(args[0], new String[0]);
            Path base = file.getParent();
            if (base == null) {
                base = Path.of(".", new String[0]);
            }
            this.product.activateWindow("activation.dat", BaseMain.class, base);
            Properties config = Utils.readConfig(file);
            if (config.containsKey("local.db")) {
                LocalClientConfig clientConfig = new LocalClientConfig(config);
                this.run(clientConfig, base);
                return;
            } else {
                if (!config.containsKey("remote.url")) throw new RuntimeException("invalid config");
                RemoteClientConfig clientConfig = new RemoteClientConfig(config);
                this.run(clientConfig, base);
            }
            return;
        } else {
            this.runLocal(args);
        }
    }

    public void runLocal(String[] args) throws Exception {
        this.product.activateWindow("activation.dat", BaseMain.class, new Path[0]);
        SwingUtilities.invokeLater(() -> new StartupWindow(this).intoWindow().setVisible(true));
    }

    public void run(LocalClientConfig config, Path base) throws Exception {
        this.run(config, null, base);
    }

    public void run(RemoteClientConfig config, Path base) throws Exception {
        this.run(null, config, base);
    }

    private void run(LocalClientConfig localConfig, RemoteClientConfig remoteConfig, Path base) throws Exception {
        LOGGER.info(this.product.getVersion().getName() + " client v" + this.product.getVersion().getVersion());
        LOGGER.info("java.version: " + System.getProperty("java.version"));
        LOGGER.info("working directory: " + System.getProperty("user.dir"));
        LOGGER.info("initializing client");
        BaseClient client = localConfig != null ? LocalClient.fromConfig(this.product.getVersion(), this.modelExtensions, ClientContext.getBundle(), localConfig, base) : RemoteClient.fromConfig(this.product.getVersion(), remoteConfig, base);
        ((BaseClient)client).setup();
        ClientContext ctx = new ClientContext(client);
        for (ClientExtension ext : this.clientExtensions) {
            ext.setup(ctx);
        }
        LOGGER.info("initializing main window");
        SwingUtilities.invokeLater(() -> new MainWindow(ctx).intoWindow().setVisible(true));
    }

    public VersionInfo getVersion() {
        return this.product.getVersion();
    }

    public ModelExtension[] getModelExtensions() {
        return this.modelExtensions;
    }
}

