/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client;

import de.inahware.dav.client.BaseClient;
import de.inahware.dav.models.User;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.edvj.I18N;
import de.inahware.edvj.VersionInfo;
import de.inahware.edvj.data.AttributeSet;
import de.inahware.edvj.query.Query;
import de.inahware.edvj.query.Queryable;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.LongConsumer;

public final class ClientContext
implements Queryable {
    private BaseClient client;

    public static ResourceBundle getBundle() {
        return I18N.getBundle();
    }

    public ClientContext(BaseClient client) {
        this.client = client;
    }

    public VersionInfo getVersion() {
        return this.client.getVersion();
    }

    public BaseClient getClient() {
        return this.client;
    }

    public boolean isSingleUser() {
        return this.client.isSingleUser();
    }

    public User getLogin() {
        return this.client.getLogin();
    }

    public AttributeSet getPermissions() {
        return this.client.getPermissions();
    }

    public User login(String username, char[] password) throws Exception {
        return this.client.login(username, password);
    }

    public void logout() throws Exception {
        this.client.logout();
    }

    public <T> T query(ClientRequest<T> req) throws Exception {
        return this.client.query(req);
    }

    @Override
    public <T> T query(Query<T> q) throws Exception {
        return this.client.query(q);
    }

    public void upload(Path path) throws Exception {
        this.client.upload(path);
    }

    public void upload(Path path, LongConsumer progress) throws Exception {
        this.client.upload(path, progress);
    }

    public Path download() throws Exception {
        return this.client.download();
    }

    public Path download(LongConsumer progress) throws Exception {
        return this.client.download(progress);
    }

    static {
        I18N.addBundle("de.inahware.dav.messages");
        I18N.addBundle("de.inahware.dav.client.messages");
        I18N.setYearFormat(DateTimeFormatter.ofPattern("yyyy", Locale.GERMANY));
        I18N.setYearMonthFormat(DateTimeFormatter.ofPattern("MM.yyyy", Locale.GERMANY));
        I18N.setDateFormat(DateTimeFormatter.ofPattern("dd.MM.yyyy", Locale.GERMANY));
        I18N.setDateTimeFormat(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss", Locale.GERMANY));
        DecimalFormat fmt_money = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.GERMANY));
        fmt_money.setGroupingSize(3);
        fmt_money.setGroupingUsed(true);
        fmt_money.setParseBigDecimal(true);
        I18N.setDecimalFormat(fmt_money);
    }
}

