/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client;

import de.inahware.dav.DocumentRenderer;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.Order;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.Text;
import de.inahware.dav.models.User;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.requests.GetSettings;
import de.inahware.dav.requests.LogoDownload;
import de.inahware.edvj.VersionInfo;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.SelectAll;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class ClientDocumentRenderer
extends DocumentRenderer {
    private ClientContext ctx;

    public ClientDocumentRenderer(ResourceBundle bundle, ClientContext ctx) {
        super(bundle);
        this.ctx = ctx;
    }

    @Override
    protected VersionInfo getVersion() {
        return this.ctx.getVersion();
    }

    @Override
    protected Properties querySettings() throws Exception {
        return this.ctx.query(new GetSettings());
    }

    @Override
    protected Path queryLogo() throws Exception {
        if (!this.ctx.query(new LogoDownload()).booleanValue()) {
            return null;
        }
        return this.ctx.download();
    }

    @Override
    protected List<Text> queryTexts() throws Exception {
        return (List)((Object)this.ctx.query(new SelectAll<Text>(Text.MODEL)));
    }

    @Override
    protected List<TaxRate> queryTaxRates() throws Exception {
        return (List)((Object)this.ctx.query(new SelectAll<TaxRate>(TaxRate.MODEL)));
    }

    @Override
    protected User queryUser(Long id) throws Exception {
        return this.ctx.query(new Select<User>(User.MODEL, User.COL_ID.with(id)));
    }

    @Override
    protected Customer queryCustomer(Long id) throws Exception {
        return this.ctx.query(new Select<Customer>(Customer.MODEL, Customer.COL_ID.with(id)));
    }

    @Override
    protected Vendor queryVendor(Long id) throws Exception {
        return this.ctx.query(new Select<Vendor>(Vendor.MODEL, Vendor.COL_ID.with(id)));
    }

    @Override
    protected Order queryOrder(Long id) throws Exception {
        return this.ctx.query(new Select<Order>(Order.MODEL, Order.COL_ID.with(id)));
    }

    @Override
    protected DocumentFull queryDocument(Long id) throws Exception {
        return this.ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(id)));
    }
}

