/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client;

import de.inahware.dav.client.BaseClient;
import de.inahware.dav.client.LocalClientConfig;
import de.inahware.dav.client.LocalClientContext;
import de.inahware.dav.models.ModelExtension;
import de.inahware.dav.models.Models;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.edvj.VersionInfo;
import de.inahware.edvj.query.Query;
import de.inahware.edvj.sql.SQLConversionHelper;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;
import java.util.function.LongConsumer;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultConfiguration;

public class LocalClient
extends BaseClient {
    private ModelExtension[] modelExtensions;
    private ResourceBundle bundle;
    private Path storagePath;
    private Connection conn;
    private DSLContext dsl;
    private LocalClientContext reqCtx;

    public LocalClient(VersionInfo version, ModelExtension[] modelExtensions, ResourceBundle bundle, Path storagePath, Connection conn) throws Exception {
        super(version);
        this.modelExtensions = modelExtensions;
        this.bundle = bundle;
        this.storagePath = storagePath;
        this.conn = conn;
        Configuration config = new DefaultConfiguration().set(conn).set(SQLDialect.SQLITE).set(SQLConversionHelper.getDefault());
        config.settings().setParseSetCommands(true);
        this.dsl = DSL.using(config);
        this.reqCtx = new LocalClientContext(this);
    }

    public static LocalClient fromConfig(VersionInfo version, ModelExtension[] modelExtensions, ResourceBundle bundle, LocalClientConfig config, Path base) throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:sqlite:" + (config.getLocalDb() == null ? ":memory:" : base.resolve(config.getLocalDb()).toString()));
        try (Statement stmt = conn.createStatement();){
            stmt.execute("PRAGMA journal_mode=wal");
        }
        return new LocalClient(version, modelExtensions, bundle, base.resolve(config.getStoragePath()), conn);
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public Path getStoragePath() {
        return this.storagePath;
    }

    public DSLContext getDSLContext() {
        return this.dsl;
    }

    @Override
    public void setup() throws Exception {
        Models.migrate(this.dsl);
        this.dsl.transaction(cfg -> {
            DSLContext dsl = DSL.using(cfg);
            Models.initialize(dsl, this.getStoragePath(), true);
            for (ModelExtension ext : this.modelExtensions) {
                ext.initialize(dsl, this.getStoragePath(), true);
            }
        });
    }

    @Override
    public void connect() throws Exception {
        this.connected();
    }

    @Override
    public void shutdown() {
        try {
            this.conn.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public <T> T query(ClientRequest<T> req) throws Exception {
        return req.execute(this.reqCtx);
    }

    @Override
    public <T> T query(Query<T> q) throws Exception {
        return q.execute(Models.MODELS, this.reqCtx);
    }

    @Override
    public void upload(Path path, LongConsumer progress) throws Exception {
        Path tmpPath = this.reqCtx.tempFile();
        Files.copy(path, tmpPath, new CopyOption[0]);
        this.reqCtx.getSession().setUploadedFile(tmpPath);
    }

    @Override
    public Path download(LongConsumer progress) throws Exception {
        Path path = this.reqCtx.getSession().getDownloadFile();
        Path tmpPath = Files.createTempFile("inahware-dav-download-", "", new FileAttribute[0]);
        Files.copy(path, tmpPath, new CopyOption[0]);
        this.reqCtx.getSession().setDownloadFile(null);
        return tmpPath;
    }
}

