/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client;

import de.inahware.edvj.Utils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;

public class LocalClientConfig {
    private String profileName;
    private Path localDb;
    private Path storagePath;

    public LocalClientConfig() {
    }

    public LocalClientConfig(Properties config) {
        this.profileName = config.getProperty("profile.name");
        this.localDb = Path.of(config.getProperty("local.db"), new String[0]);
        this.storagePath = Path.of(config.getProperty("storage.path"), new String[0]);
    }

    public static LocalClientConfig fromFile(Path path) throws IOException {
        Properties config = Utils.readConfig(path);
        return new LocalClientConfig(config);
    }

    public void write(Path path) throws IOException {
        Properties config = new Properties();
        config.setProperty("profile.name", this.profileName);
        config.setProperty("local.db", this.localDb.toString());
        config.setProperty("storage.path", this.storagePath.toString());
        Utils.writeConfig(config, path, "local client config");
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public Path getLocalDb() {
        return this.localDb;
    }

    public void setLocalDb(Path localDb) {
        this.localDb = localDb;
    }

    public Path getStoragePath() {
        return this.storagePath;
    }

    public void setStoragePath(Path dataPath) {
        this.storagePath = dataPath;
    }
}

