/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client;

import de.inahware.dav.RemoteClientConfig;
import de.inahware.dav.client.BaseClient;
import de.inahware.dav.client.VersionException;
import de.inahware.dav.models.Models;
import de.inahware.dav.requests.ClientRequest;
import de.inahware.dav.requests.GetVersion;
import de.inahware.dav.requests.InitSession;
import de.inahware.edvj.VersionInfo;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Query;
import de.inahware.edvj.request.RequestException;
import de.inahware.edvj.request.SerializedRequestException;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.LongConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClient
extends BaseClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteClient.class.getName());
    private URI url;
    private String session;
    private HttpClient client;

    public RemoteClient(VersionInfo version, String url, String session) throws Exception {
        super(version);
        this.url = new URI(url);
        this.session = session;
    }

    public static RemoteClient fromConfig(VersionInfo version, RemoteClientConfig config) throws Exception {
        return RemoteClient.fromConfig(version, config, Path.of(".", new String[0]));
    }

    public static RemoteClient fromConfig(VersionInfo version, RemoteClientConfig config, Path base) throws Exception {
        return new RemoteClient(version, config.getRemoteUrl(), config.getRemoteSession());
    }

    @Override
    public void setup() throws Exception {
        this.client = HttpClient.newBuilder().cookieHandler(new CookieManager()).followRedirects(HttpClient.Redirect.NEVER).connectTimeout(Duration.ofSeconds(10L)).build();
    }

    @Override
    public void connect() throws Exception {
        VersionInfo serverVersion = this.query(new GetVersion());
        if (this.getVersion() != null) {
            if (!serverVersion.getName().equals(this.getVersion().getName())) {
                throw new VersionException(serverVersion);
            }
            if (!serverVersion.getVersion().equals(this.getVersion().getVersion())) {
                throw new VersionException(serverVersion);
            }
        }
        this.query(new InitSession(this.session));
        this.connected();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public <T> T query(ClientRequest<T> req) throws Exception {
        String res = this.request("request/" + req.getName(), req);
        return req.deserializeResult(Models.MAPPER, res);
    }

    @Override
    public <T> T query(Query<T> q) throws Exception {
        String res = this.request("query", q.serialize(Models.MAPPER));
        return q.deserializeResult(Models.MAPPER, res);
    }

    public String request(String url, Object obj) throws Exception {
        String data = Models.MAPPER.writeValueAsString(obj);
        HttpRequest req = HttpRequest.newBuilder(this.url.resolve(url)).version(HttpClient.Version.HTTP_1_1).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(data)).build();
        LOGGER.debug("{} {} :: {}", req.method(), req.uri(), data);
        HttpResponse<String> res = this.client.send(req, HttpResponse.BodyHandlers.ofString());
        LOGGER.debug("{} :: {}", (Object)res.statusCode(), (Object)res.body());
        if (res.statusCode() / 100 == 2) {
            return res.body();
        }
        SerializedRequestException ex = Models.MAPPER.readValue(res.body(), SerializedRequestException.class);
        throw ex.deserialize();
    }

    @Override
    public void upload(Path path, final LongConsumer progressHandler) throws Exception {
        HttpRequest.BodyPublisher publisher = HttpRequest.BodyPublishers.ofFile(path);
        if (progressHandler != null) {
            publisher.subscribe(new Flow.Subscriber<ByteBuffer>(){
                long progress = 0L;

                @Override
                public void onSubscribe(Flow.Subscription sub) {
                    sub.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(ByteBuffer buf) {
                    this.progress += (long)buf.limit();
                    progressHandler.accept(this.progress);
                }

                @Override
                public void onError(Throwable t) {
                }

                @Override
                public void onComplete() {
                }
            });
        }
        HttpRequest req = HttpRequest.newBuilder(this.url.resolve("upload")).version(HttpClient.Version.HTTP_1_1).header("Content-Type", "application/json").POST(publisher).build();
        LOGGER.debug("{} {}", (Object)req.method(), (Object)req.uri());
        HttpResponse<Void> res = this.client.send(req, HttpResponse.BodyHandlers.discarding());
        LOGGER.debug("{}", (Object)res.statusCode());
        if (res.statusCode() / 100 != 2) {
            throw new RequestException();
        }
    }

    @Override
    public Path download(LongConsumer progressHandler) throws Exception {
        Path path = Files.createTempFile("inahware-dav-download-", "", new FileAttribute[0]);
        try (OutputStream output = Files.newOutputStream(path, new OpenOption[0]);){
            Object progress = new Object(){
                long value = 0L;
            };
            HttpResponse.BodyHandler<Void> handler = HttpResponse.BodyHandlers.ofByteArrayConsumer(arg_0 -> RemoteClient.lambda$download$1(output, progressHandler, progress, arg_0));
            HttpRequest req = HttpRequest.newBuilder(this.url.resolve("download")).version(HttpClient.Version.HTTP_1_1).GET().build();
            LOGGER.debug("{} {}", (Object)req.method(), (Object)req.uri());
            HttpResponse<Void> res = this.client.send(req, handler);
            LOGGER.debug("{}", (Object)res.statusCode());
            if (res.statusCode() / 100 != 2) {
                throw new RequestException();
            }
            Path path2 = path;
            return path2;
        }
    }

    private static /* synthetic */ void lambda$download$1(OutputStream output, LongConsumer progressHandler, 2 progress, Optional bytes) {
        if (bytes.isPresent()) {
            byte[] buf = (byte[])bytes.get();
            EUtils.catchSilently(() -> {
                output.write(buf);
                if (progressHandler != null) {
                    progress.value += (long)buf.length;
                    progressHandler.accept(progress.value);
                }
            });
        }
    }
}

