/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.Address;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.Vendor;
import de.inahware.edvj.gui.DataTableDialog;
import java.util.Locale;
import java.util.ResourceBundle;

public class ChooseAddressDialog
extends DataTableDialog<Address> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ChooseAddressDialog(ClientContext ctx, Customer customer, Vendor vendor) {
        super(Address.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("ChooseAddressDialog.title"));
        this.addColumn(Address.COL_DEFAULT_ADDRESS);
        if (customer != null) {
            this.addColumn(Address.COL_DEFAULT_SHIPPING_ADDRESS);
        }
        this.addColumn(Address.COL_COMPANY);
        this.addColumn(Address.COL_SALUTATION, (U s) -> s == null ? "-" : s.getLocalizedString(this.BUNDLE));
        this.addColumn(Address.COL_PREFIX);
        this.addColumn(Address.COL_FIRST_NAME);
        this.addColumn(Address.COL_LAST_NAME);
        this.addColumn(Address.COL_ADDRESS1);
        this.addColumn(Address.COL_ADDRESS2);
        this.addColumn(Address.COL_COUNTRY, (U c) -> new Locale("", (String)c).getDisplayCountry());
        if (customer != null) {
            this.setFilter(Address.COL_CUSTOMER_ID.with(customer.getId()));
        } else if (vendor != null) {
            this.setFilter(Address.COL_VENDOR_ID.with(vendor.getId()));
        }
        this.disableSearch();
        this.addSelectDoubleClickAction();
        this.addSelectCancelButtons();
    }
}

