/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.ArticleGroup;
import de.inahware.edvj.gui.ETree;
import de.inahware.edvj.gui.ETreeCellRenderer;
import de.inahware.edvj.gui.ETreeModel;
import de.inahware.edvj.gui.ETreeNode;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.InputDialog;
import de.inahware.edvj.query.SelectAll;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class ChooseArticleGroupDialog
extends InputDialog<ArticleGroup> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JScrollPane scrollPane;
    private ETree<ArticleGroup> tree;

    public ChooseArticleGroupDialog(ClientContext ctx) throws Exception {
        this.ctx = ctx;
        this.setTitle(this.BUNDLE.getString("ChooseArticleGroupDialog.title"));
        this.setWindowSize(270, 480);
        this.initialize();
        this.refreshGroups();
        ETreeCellRenderer<ArticleGroup> renderer = this.tree.setFormatter(node -> node.getValue() != null ? ((ArticleGroup)node.getValue()).getTitle() : this.BUNDLE.getString("ArticleGroup.root"));
        renderer.setLeafIcon(renderer.getClosedIcon());
        this.tree.addDoubleClickAction(node -> this.returnObject((ArticleGroup)node.getValue()));
    }

    private void refreshGroups() throws Exception {
        List res = EUtils.blocking((Component)this, blocking -> (List)((Object)this.ctx.query(new SelectAll<ArticleGroup>(ArticleGroup.MODEL))));
        ETreeNode<Object> root = new ETreeNode<Object>(false, null);
        HashMap<Long, ETreeNode<Object>> groups = new HashMap<Long, ETreeNode<Object>>();
        groups.put(null, root);
        for (ArticleGroup g : res) {
            groups.put(g.getId(), new ETreeNode<ArticleGroup>(false, g));
        }
        for (ETreeNode node : groups.values()) {
            ArticleGroup g = (ArticleGroup)node.getValue();
            if (g == null) continue;
            ((ETreeNode)groups.get(g.getParentId())).addChild(node);
        }
        for (ETreeNode node : groups.values()) {
            if (node.getChildCount() != 0) continue;
            node.setLeaf(true);
        }
        this.tree.setModel(new ETreeModel<Object>(root));
    }

    @Override
    protected ArticleGroup parseObject() throws Exception {
        ETreeNode<ArticleGroup> node = this.tree.getSelectedNode();
        if (node == null) {
            throw new RuntimeException(this.BUNDLE.getString("ChooseArticleGroupDialog.messages.no_group_selected"));
        }
        return node.getValue();
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
        this.scrollPane = new JScrollPane();
        this.rootPanel.add((Component)this.scrollPane, "cell 0 0,grow");
        this.tree = new ETree();
        this.scrollPane.setViewportView(this.tree);
    }
}

