/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.OrderDocumentView;
import de.inahware.edvj.gui.EDataTable;
import de.inahware.edvj.gui.InputDialog;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class ChooseDocumentsDialog
extends InputDialog<List<OrderDocumentView>> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private JScrollPane scrollPane;
    private EDataTable<OrderDocumentView> table;
    private Set<Long> selected = new HashSet<Long>();

    public ChooseDocumentsDialog(List<OrderDocumentView> data, Long select) {
        this.selected.add(select);
        this.setTitle(this.BUNDLE.getString("ChooseDocumentsDialog.title"));
        this.setWindowSize(1024, 576);
        this.initialize();
        this.table.addColumn("", Boolean.class, e -> this.selected.contains(e.getId()), (e, value) -> {
            if (((Boolean)value).booleanValue()) {
                this.selected.add(e.getId());
            } else {
                this.selected.remove(e.getId());
            }
        });
        this.table.addColumn(OrderDocumentView.COL_ID);
        this.table.addColumn(OrderDocumentView.COL_TYPE, type -> type.getLocalizedString(this.BUNDLE));
        this.table.addColumn(OrderDocumentView.COL_STATE, state -> state.getLocalizedString(this.BUNDLE));
        this.table.addColumn(this.BUNDLE.getString("Customer") + " / " + this.BUNDLE.getString("Vendor"), obj -> {
            if (obj.getCustomerId() != null) {
                return obj.getCustomerNumber();
            }
            if (obj.getVendorNumber() != null) {
                return obj.getVendorNumber();
            }
            return "-";
        });
        this.table.addColumn(OrderDocumentView.COL_COMPANY);
        this.table.addColumn(OrderDocumentView.COL_SALUTATION, s -> s == null ? "-" : s.getLocalizedString(this.BUNDLE));
        this.table.addColumn(OrderDocumentView.COL_PREFIX);
        this.table.addColumn(OrderDocumentView.COL_LAST_NAME);
        this.table.addColumn(OrderDocumentView.COL_FIRST_NAME);
        this.table.setData(data);
    }

    @Override
    protected List<OrderDocumentView> parseObject() throws Exception {
        List<OrderDocumentView> res = this.table.getData().stream().filter(e -> this.selected.contains(e.getId())).collect(Collectors.toList());
        if (res.isEmpty()) {
            throw new RuntimeException(this.BUNDLE.getString("ChooseDocumentsDialog.messages.selection_empty"));
        }
        return res;
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
        this.scrollPane = new JScrollPane();
        this.rootPanel.add((Component)this.scrollPane, "cell 0 0,grow");
        this.table = new EDataTable<OrderDocumentView>(OrderDocumentView.MODEL);
        this.scrollPane.setViewportView(this.table);
    }
}

