/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.LineItem;
import de.inahware.edvj.gui.EDataTable;
import de.inahware.edvj.gui.InputDialog;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class ChooseLineItemsDialog
extends InputDialog<List<LineItem>> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private JScrollPane scrollPane;
    private EDataTable<LineItem> table;
    private Set<LineItem> selected = new HashSet<LineItem>();

    public ChooseLineItemsDialog(List<LineItem> entries) {
        this(entries, false);
    }

    public ChooseLineItemsDialog(List<LineItem> entries, boolean selectAll) {
        this.setTitle(this.BUNDLE.getString("ChooseLineItemsDialog.title"));
        this.setWindowSize(640, 320);
        this.initialize();
        this.table.addColumn("", Boolean.class, e -> this.selected.contains(e), (e, value) -> {
            System.out.println(e.equals(e));
            System.out.println(e.hashCode());
            if (((Boolean)value).booleanValue()) {
                this.selected.add((LineItem)e);
            } else {
                this.selected.remove(e);
            }
        });
        this.table.addColumn(LineItem.COL_ARTICLE_NUMBER);
        this.table.addColumn(LineItem.COL_ARTICLE_TITLE);
        this.table.addColumn(LineItem.COL_AMOUNT);
        this.table.addColumn(LineItem.COL_PRICE);
        this.table.addColumn(LineItem.COL_TEXT);
        this.table.addColumn(this.BUNDLE.getString("generic.label.totalPrice"), BigDecimal.class, e -> e.getAmount().multiply(e.getPrice()).setScale(2, RoundingMode.HALF_UP));
        this.table.setData(entries);
    }

    @Override
    protected List<LineItem> parseObject() throws Exception {
        return this.table.getData().stream().filter(e -> this.selected.contains(e)).collect(Collectors.toList());
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
        this.scrollPane = new JScrollPane();
        this.rootPanel.add((Component)this.scrollPane, "cell 0 0,grow");
        this.table = new EDataTable<LineItem>(LineItem.MODEL);
        this.scrollPane.setViewportView(this.table);
    }
}

