/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.Address;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class EditAddressDialog
extends DefaultDataEditDialog<Address> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JLabel lblSalutation;
    private JPanel panel;
    private JComboBox<Salutation> cmbSalutation;
    private ETextField txtPrefix;
    private JLabel lblFirstName;
    private ETextField txtFirstName;
    private JLabel lblLastName;
    private ETextField txtLastName;
    private JLabel lblCompany;
    private ETextField txtCompany;
    private JLabel lblAddress1;
    private ETextField txtAddress1;
    private JLabel lblAddress2;
    private ETextField txtAddress2;
    private JLabel lblCountry;
    private JComboBox<String> cmbCountry;

    private EditAddressDialog() {
        this.initialize();
    }

    public EditAddressDialog(ClientContext ctx, Address obj) {
        this(ctx, obj, null);
    }

    public EditAddressDialog(ClientContext ctx, Address obj, Address placeholder) {
        super(Address.MODEL, ctx, obj, placeholder);
        this.ctx = ctx;
        this.setTitle(this.BUNDLE.getString("Address"));
        this.setWindowSize(480, 320);
        this.initialize();
        this.addEditable(this.cmbSalutation);
        this.addEditable(this.txtPrefix);
        this.addEditable(this.txtFirstName);
        this.addEditable(this.txtLastName);
        this.addEditable(this.txtCompany);
        this.addEditable(this.cmbCountry);
        this.addEditable(this.txtAddress1);
        this.addEditable(this.txtAddress2);
        this.cmbSalutation.addItemListener(ev -> {
            boolean enabled = this.cmbSalutation.getSelectedItem() != null;
            this.txtPrefix.setEnabled(enabled);
            this.txtFirstName.setEnabled(enabled);
            this.txtLastName.setEnabled(enabled);
        });
        this.cmbSalutation.setRenderer(new FormattedListCellRenderer(type -> type == null ? "-" : ((Salutation)((Object)((Object)type))).getLocalizedString(this.BUNDLE)));
        this.cmbSalutation.addItem(null);
        for (Salutation s2 : Salutation.values()) {
            this.cmbSalutation.addItem(s2);
        }
        this.cmbSalutation.setSelectedIndex(1);
        this.cmbSalutation.setSelectedIndex(0);
        this.cmbCountry.setRenderer(new FormattedListCellRenderer(c -> c == null ? "-" : new Locale("", (String)c).getDisplayCountry()));
        Locale.getISOCountries(Locale.IsoCountryCode.PART1_ALPHA2).stream().sorted(Comparator.comparing(s -> new Locale("", (String)s).getDisplayCountry(), Collator.getInstance())).forEach(c -> this.cmbCountry.addItem((String)c));
    }

    @Override
    public void displayObject(Address obj) throws Exception {
        this.setTitle((obj.getCustomerId() != null ? this.BUNDLE.getString("Customer") : this.BUNDLE.getString("Vendor")) + " - " + this.BUNDLE.getString("Address") + (String)(obj.getId() != null ? "" : " " + this.BUNDLE.getString("generic.title.new")));
        this.cmbSalutation.setSelectedItem((Object)obj.getSalutation());
        this.txtPrefix.setText(obj.getPrefix());
        this.txtFirstName.setText(obj.getFirstName());
        this.txtLastName.setText(obj.getLastName());
        this.txtCompany.setText(obj.getCompany());
        this.cmbCountry.setSelectedItem(obj.getCountry());
        this.txtAddress1.setText(obj.getAddress1());
        this.txtAddress2.setText(obj.getAddress2());
        this.setEditable(this.ctx.getPermissions().contains(Address.MODEL.getName() + ".update"));
    }

    @Override
    public Address parseObject(Address old) throws Exception {
        Address obj = new Address(old);
        obj.setSalutation((Salutation)((Object)this.cmbSalutation.getSelectedItem()));
        if (obj.getSalutation() == null) {
            obj.setPrefix("");
            obj.setFirstName("");
            obj.setLastName("");
        } else {
            obj.setPrefix(this.txtPrefix.getText().trim());
            obj.setFirstName(this.txtFirstName.getText().trim());
            obj.setLastName(this.txtLastName.getText().trim());
        }
        obj.setCompany(this.txtCompany.getText().trim());
        obj.setCountry((String)this.cmbCountry.getSelectedItem());
        obj.setAddress1(this.txtAddress1.getText().trim());
        obj.setAddress2(this.txtAddress2.getText().trim());
        obj.validate();
        return obj;
    }

    private void initialize() {
        FlowLayout flowLayout = (FlowLayout)this.bottomPanel.getLayout();
        flowLayout.setAlignment(0);
        this.rootPanel.setLayout(new MigLayout("", "[][75px:75px,grow]", "[][][][][][][]"));
        this.lblSalutation = new JLabel(this.BUNDLE.getString("Address.SALUTATION") + ":");
        this.rootPanel.add((Component)this.lblSalutation, "cell 0 1,alignx trailing");
        this.panel = new JPanel();
        this.rootPanel.add((Component)this.panel, "flowx,cell 1 1,grow");
        this.panel.setLayout(new BorderLayout(0, 0));
        this.cmbSalutation = new JComboBox();
        this.panel.add(this.cmbSalutation, "West");
        this.txtPrefix = new ETextField();
        this.panel.add(this.txtPrefix);
        this.txtPrefix.setColumns(10);
        this.lblFirstName = new JLabel(this.BUNDLE.getString("Address.FIRST_NAME") + ":");
        this.rootPanel.add((Component)this.lblFirstName, "cell 0 2,alignx trailing");
        this.txtFirstName = new ETextField();
        this.rootPanel.add((Component)this.txtFirstName, "cell 1 2,growx");
        this.txtFirstName.setColumns(10);
        this.lblLastName = new JLabel(this.BUNDLE.getString("Address.LAST_NAME") + ":");
        this.rootPanel.add((Component)this.lblLastName, "cell 0 3,alignx trailing");
        this.txtLastName = new ETextField();
        this.rootPanel.add((Component)this.txtLastName, "cell 1 3,growx");
        this.txtLastName.setColumns(10);
        this.lblCompany = new JLabel(this.BUNDLE.getString("Address.COMPANY") + ":");
        this.rootPanel.add((Component)this.lblCompany, "cell 0 0,alignx trailing");
        this.txtCompany = new ETextField();
        this.rootPanel.add((Component)this.txtCompany, "cell 1 0,growx");
        this.txtCompany.setColumns(10);
        this.lblAddress1 = new JLabel(this.BUNDLE.getString("Address.ADDRESS1") + ":");
        this.rootPanel.add((Component)this.lblAddress1, "cell 0 4,alignx trailing");
        this.txtAddress1 = new ETextField();
        this.rootPanel.add((Component)this.txtAddress1, "cell 1 4,growx");
        this.txtAddress1.setColumns(10);
        this.lblAddress2 = new JLabel(this.BUNDLE.getString("Address.ADDRESS2") + ":");
        this.rootPanel.add((Component)this.lblAddress2, "cell 0 5,alignx trailing");
        this.txtAddress2 = new ETextField();
        this.rootPanel.add((Component)this.txtAddress2, "cell 1 5,growx");
        this.txtAddress2.setColumns(10);
        this.lblCountry = new JLabel(this.BUNDLE.getString("Address.COUNTRY") + ":");
        this.rootPanel.add((Component)this.lblCountry, "cell 0 6,alignx trailing");
        this.cmbCountry = new JComboBox();
        this.rootPanel.add(this.cmbCountry, "cell 1 6,growx");
    }
}

