/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ShowArticleVendorsDialog;
import de.inahware.dav.client.gui.ShowAttachmentsDialog;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.ArticleGroup;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.types.ArticlePrice;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETable;
import de.inahware.edvj.gui.ETableModel;
import de.inahware.edvj.gui.ETextArea;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.SelectAll;
import java.awt.Component;
import java.awt.FlowLayout;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class EditArticleDialog
extends DefaultDataEditDialog<Article> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private List<TaxRate> taxes;
    private HashMap<Long, TaxRate> taxes_by_id;
    private ArticleGroup group;
    private JLabel lblNumber;
    private ETextField txtNumber;
    private JLabel lblGroup;
    private ETextField txtGroup;
    private JLabel lblTitle;
    private ETextField txtTitle;
    private JLabel lblPrices;
    private JScrollPane scrollPane;
    private ETable<ArticlePrice> tblPrices;
    private JLabel lblUnit;
    private JComboBox<String> cmbUnit;
    private JLabel lblTax;
    private JComboBox<TaxRate> cmbTax;
    private JScrollPane scrollPane_1;
    private JLabel lblDescription;
    private ETextArea txtDescription;
    private JButton btnVendors;
    private JButton btnAttachments;

    private EditArticleDialog() {
        this.initialize();
    }

    public EditArticleDialog(ClientContext ctx, Article article) {
        this(ctx, article, null);
    }

    public EditArticleDialog(ClientContext ctx, Article article, Article placeholder) {
        super(Article.MODEL, ctx, article, placeholder);
        this.ctx = ctx;
        this.setTitle(this.BUNDLE.getString("Article"));
        this.setWindowSize(480, 360);
        this.initialize();
        this.addEditable(this.txtNumber);
        this.addEditable(this.txtTitle);
        this.addEditable(this.tblPrices);
        this.addEditable(this.cmbUnit);
        this.addEditable(this.cmbTax);
        this.addEditable(this.txtDescription);
        this.tblPrices.addColumn(this.BUNDLE.getString("ArticlePrice.PRICE"), String.class, e -> I18N.formatDecimal(e.price), (e, val) -> {
            try {
                e.price = I18N.parseDecimal((String)val).setScale(2, RoundingMode.HALF_UP);
            }
            catch (ArithmeticException | ParseException exception) {
                // empty catch block
            }
        });
        this.tblPrices.addColumn(this.BUNDLE.getString("ArticlePrice.COMMENT"), String.class, e -> e.comment, (e, val) -> {
            e.comment = (String)val;
        });
        this.tblPrices.addPopupMenuItem(this.BUNDLE.getString("generic.menu.addEntry"), obj -> this.tblPrices.isEditable(), obj -> ((ETableModel)this.tblPrices.getModel()).addRow(new ArticlePrice(new BigDecimal(0), "")));
        this.tblPrices.addPopupMenuItem(this.BUNDLE.getString("generic.menu.deleteEntry"), obj -> this.tblPrices.isEditable() && obj != null, obj -> ((ETableModel)this.tblPrices.getModel()).deleteRow(this.tblPrices.getSelectedRow()));
        for (String next : this.BUNDLE.getString("Units").split(",")) {
            this.cmbUnit.addItem(next);
        }
        this.cmbTax.setRenderer(new FormattedListCellRenderer(obj -> ((TaxRate)obj).getDisplayName()));
        this.btnAttachments.addActionListener(e -> new ShowAttachmentsDialog(ctx, this.getTitle(), AttachmentObjectType.ARTICLE, ((Article)this.getObject()).getId()).openInnerModal(this));
        this.btnVendors.addActionListener(e -> new ShowArticleVendorsDialog(ctx, (Article)this.getObject()).openInnerModal(this));
    }

    @Override
    public void displayObject(Article obj) throws Exception {
        EUtils.blocking((Component)this, blocking -> {
            this.taxes = (List)((Object)this.ctx.query(new SelectAll<TaxRate>(TaxRate.MODEL)));
            this.taxes_by_id = new HashMap();
            for (TaxRate tax : this.taxes) {
                this.taxes_by_id.put(tax.getId(), tax);
            }
            this.group = this.ctx.query(new Select<ArticleGroup>(ArticleGroup.MODEL, ArticleGroup.COL_ID.with(obj.getArticleGroupId())));
        });
        this.setEditable(this.ctx.getPermissions().contains(Article.MODEL.getName() + ".update"));
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("Article") + " " + this.BUNDLE.getString("generic.title.new"));
            this.tblPrices.setData(List.of(new ArticlePrice(new BigDecimal(0), "")));
            this.btnAttachments.setEnabled(false);
            this.btnVendors.setEnabled(false);
        } else {
            this.setTitle(this.BUNDLE.getString("Article") + " " + obj.getDisplayName());
            this.tblPrices.setData(obj.getPriceList());
            this.btnAttachments.setEnabled(true);
            this.btnVendors.setEnabled(true);
        }
        this.txtNumber.setText(obj.getNumber());
        this.txtGroup.setText(this.group.getTitle());
        this.txtTitle.setText(obj.getTitle());
        this.cmbUnit.setSelectedItem(obj.getUnit());
        this.cmbTax.removeAllItems();
        for (TaxRate tax : this.taxes) {
            if (!tax.isEnabled().booleanValue()) continue;
            this.cmbTax.addItem(tax);
        }
        if (obj.getTaxRateId() == null) {
            this.cmbTax.setSelectedIndex(0);
        } else {
            this.cmbTax.setSelectedItem(this.taxes_by_id.get(obj.getTaxRateId()));
        }
        this.txtDescription.setText(obj.getDescription());
    }

    @Override
    public Article parseObject(Article old) throws Exception {
        Article article = new Article(old);
        String number = this.txtNumber.getText().trim();
        article.setNumber(number.isEmpty() ? null : number);
        article.setTitle(this.txtTitle.getText().trim());
        article.setArticleGroupId(this.group.getId());
        article.setPriceList(this.tblPrices.getData());
        article.setUnit(this.cmbUnit.getSelectedItem().toString().trim());
        article.setTaxRate(((TaxRate)this.cmbTax.getSelectedItem()).getId());
        article.setDescription(this.txtDescription.getText().trim());
        article.validate();
        return article;
    }

    private void initialize() {
        FlowLayout flowLayout = (FlowLayout)this.bottomPanel.getLayout();
        flowLayout.setAlignment(0);
        this.rootPanel.setLayout(new MigLayout("", "[][grow]", "[][][][75px][][][grow]"));
        this.lblNumber = new JLabel(this.BUNDLE.getString("Article.NUMBER") + ":");
        this.rootPanel.add((Component)this.lblNumber, "cell 0 0,alignx trailing");
        this.txtNumber = new ETextField();
        this.rootPanel.add((Component)this.txtNumber, "cell 1 0,growx");
        this.txtNumber.setColumns(10);
        this.lblGroup = new JLabel(this.BUNDLE.getString("Article.ARTICLE_GROUP_ID") + ":");
        this.rootPanel.add((Component)this.lblGroup, "cell 0 1,alignx trailing");
        this.txtGroup = new ETextField();
        this.txtGroup.setEditable(false);
        this.rootPanel.add((Component)this.txtGroup, "cell 1 1,growx");
        this.txtGroup.setColumns(10);
        this.lblTitle = new JLabel(this.BUNDLE.getString("Article.TITLE") + ":");
        this.rootPanel.add((Component)this.lblTitle, "cell 0 2,alignx trailing");
        this.txtTitle = new ETextField();
        this.rootPanel.add((Component)this.txtTitle, "cell 1 2,growx");
        this.txtTitle.setColumns(10);
        this.lblPrices = new JLabel(this.BUNDLE.getString("Article.PRICES") + ":");
        this.rootPanel.add((Component)this.lblPrices, "cell 0 3,alignx trailing,aligny top");
        this.scrollPane = new JScrollPane();
        this.rootPanel.add((Component)this.scrollPane, "cell 1 3,grow");
        this.tblPrices = new ETable();
        this.tblPrices.setFillsViewportHeight(true);
        this.scrollPane.setViewportView(this.tblPrices);
        this.lblUnit = new JLabel(this.BUNDLE.getString("Article.UNIT") + ":");
        this.rootPanel.add((Component)this.lblUnit, "cell 0 4,alignx trailing");
        this.cmbUnit = new JComboBox();
        this.rootPanel.add(this.cmbUnit, "cell 1 4,growx");
        this.cmbUnit.setEditable(true);
        this.lblTax = new JLabel(this.BUNDLE.getString("Article.TAX_RATE_ID") + ":");
        this.rootPanel.add((Component)this.lblTax, "cell 0 5,alignx trailing");
        this.cmbTax = new JComboBox();
        this.rootPanel.add(this.cmbTax, "cell 1 5,growx");
        this.lblDescription = new JLabel(this.BUNDLE.getString("Article.DESCRIPTION") + ":");
        this.rootPanel.add((Component)this.lblDescription, "cell 0 6,alignx trailing,aligny top");
        this.scrollPane_1 = new JScrollPane();
        this.scrollPane_1.setHorizontalScrollBarPolicy(31);
        this.rootPanel.add((Component)this.scrollPane_1, "cell 1 6,grow");
        this.txtDescription = new ETextArea();
        this.txtDescription.setLineWrap(true);
        this.txtDescription.setWrapStyleWord(true);
        this.scrollPane_1.setViewportView(this.txtDescription);
        this.btnAttachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.bottomPanel.add(this.btnAttachments);
        this.btnVendors = new JButton(this.BUNDLE.getString("Vendors"));
        this.bottomPanel.add(this.btnVendors);
    }
}

