/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.ArticleVendor;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.models.types.ArticlePrice;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETable;
import de.inahware.edvj.gui.ETableModel;
import de.inahware.edvj.gui.ETextArea;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Select;
import java.awt.Component;
import java.awt.FlowLayout;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class EditArticleVendorDialog
extends DefaultDataEditDialog<ArticleVendor> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private Article article;
    private Vendor vendor;
    private JLabel lblArticle;
    private ETextField txtArticle;
    private JLabel lblVendor;
    private ETextField txtVendor;
    private JLabel lblVendorsArticleNumber;
    private ETextField txtVendorsArticleNumber;
    private JLabel lblPrices;
    private JScrollPane scrollPane;
    private ETable<ArticlePrice> tblPrices;
    private JLabel lblComment;
    private JScrollPane scrollPane_1;
    private ETextArea txtComment;

    private EditArticleVendorDialog() {
        this.initialize();
    }

    public EditArticleVendorDialog(ClientContext ctx, ArticleVendor obj) {
        this(ctx, obj, null);
    }

    public EditArticleVendorDialog(ClientContext ctx, ArticleVendor obj, ArticleVendor placeholder) {
        super(ArticleVendor.MODEL, ctx, obj, placeholder);
        this.ctx = ctx;
        this.initialize();
        this.addEditable(this.txtVendorsArticleNumber);
        this.addEditable(this.tblPrices);
        this.addEditable(this.txtComment);
        this.tblPrices.addColumn(this.BUNDLE.getString("ArticlePrice.PRICE"), String.class, e -> I18N.formatDecimal(e.price), (e, val) -> {
            try {
                e.price = I18N.parseDecimal((String)val).setScale(2, RoundingMode.HALF_UP);
            }
            catch (ArithmeticException | ParseException exception) {
                // empty catch block
            }
        });
        this.tblPrices.addColumn(this.BUNDLE.getString("ArticlePrice.COMMENT"), String.class, e -> e.comment, (e, val) -> {
            e.comment = (String)val;
        });
        this.tblPrices.addPopupMenuItem(this.BUNDLE.getString("generic.menu.addEntry"), obj2 -> this.tblPrices.isEditable(), obj2 -> ((ETableModel)this.tblPrices.getModel()).addRow(new ArticlePrice(new BigDecimal(0), "")));
        this.tblPrices.addPopupMenuItem(this.BUNDLE.getString("generic.menu.deleteEntry"), obj2 -> this.tblPrices.isEditable() && obj2 != null && this.tblPrices.getRowCount() > 1, obj2 -> ((ETableModel)this.tblPrices.getModel()).deleteRow(this.tblPrices.getSelectedRow()));
    }

    @Override
    public void displayObject(ArticleVendor obj) throws Exception {
        EUtils.blocking((Component)this, waiting -> {
            this.article = this.ctx.query(new Select<Article>(Article.MODEL, Article.COL_ID.with(obj.getArticleId())));
            this.vendor = this.ctx.query(new Select<Vendor>(Vendor.MODEL, Vendor.COL_ID.with(obj.getVendorId())));
        });
        this.setEditable(this.ctx.getPermissions().contains(ArticleVendor.MODEL.getName() + ".update"));
        this.setTitle(this.BUNDLE.getString("Article") + " " + this.article.getNumber() + " - " + this.BUNDLE.getString("Vendor") + " " + this.vendor.getNumber());
        this.txtArticle.setText(this.article.getNumber() + " - " + this.article.getTitle());
        this.txtVendor.setText(this.vendor.getNumber() + " - " + this.vendor.getDisplayName(this.BUNDLE));
        this.txtVendorsArticleNumber.setText(obj.getVendorsArticleNumber());
        this.tblPrices.setData(obj.getPriceList());
        this.txtComment.setText(obj.getComment());
    }

    @Override
    public ArticleVendor parseObject(ArticleVendor old) throws Exception {
        ArticleVendor obj = new ArticleVendor(old);
        obj.setArticleId(this.article.getId());
        obj.setVendorId(this.vendor.getId());
        obj.setVendorsArticleNumber(this.txtVendorsArticleNumber.getText());
        obj.setPriceList(this.tblPrices.getData());
        obj.setComment(this.txtComment.getText());
        obj.validate();
        return obj;
    }

    private void initialize() {
        FlowLayout flowLayout = (FlowLayout)this.bottomPanel.getLayout();
        flowLayout.setAlignment(0);
        this.setTitle(this.BUNDLE.getString("Article"));
        this.setSize(480, 360);
        this.rootPanel.setLayout(new MigLayout("", "[][grow]", "[][][][75px][grow]"));
        this.lblArticle = new JLabel(this.BUNDLE.getString("Article") + ":");
        this.rootPanel.add((Component)this.lblArticle, "cell 0 0,alignx trailing");
        this.txtArticle = new ETextField();
        this.txtArticle.setEditable(false);
        this.rootPanel.add((Component)this.txtArticle, "cell 1 0,growx");
        this.txtArticle.setColumns(10);
        this.lblVendor = new JLabel(this.BUNDLE.getString("Vendor") + ":");
        this.rootPanel.add((Component)this.lblVendor, "cell 0 1,alignx trailing");
        this.txtVendor = new ETextField();
        this.txtVendor.setEditable(false);
        this.rootPanel.add((Component)this.txtVendor, "cell 1 1,growx");
        this.txtVendor.setColumns(10);
        this.lblVendorsArticleNumber = new JLabel(this.BUNDLE.getString("ArticleVendor.VENDORS_ARTICLE_NUMBER") + ":");
        this.rootPanel.add((Component)this.lblVendorsArticleNumber, "cell 0 2,alignx trailing");
        this.txtVendorsArticleNumber = new ETextField();
        this.rootPanel.add((Component)this.txtVendorsArticleNumber, "cell 1 2,growx");
        this.txtVendorsArticleNumber.setColumns(10);
        this.lblPrices = new JLabel(this.BUNDLE.getString("ArticleVendor.PRICES") + ":");
        this.rootPanel.add((Component)this.lblPrices, "cell 0 3,alignx trailing,aligny top");
        this.scrollPane = new JScrollPane();
        this.rootPanel.add((Component)this.scrollPane, "cell 1 3,grow");
        this.tblPrices = new ETable();
        this.tblPrices.setFillsViewportHeight(true);
        this.scrollPane.setViewportView(this.tblPrices);
        this.lblComment = new JLabel(this.BUNDLE.getString("ArticleVendor.COMMENT") + ":");
        this.rootPanel.add((Component)this.lblComment, "cell 0 4,alignx trailing,aligny top");
        this.scrollPane_1 = new JScrollPane();
        this.rootPanel.add((Component)this.scrollPane_1, "cell 1 4,grow");
        this.txtComment = new ETextArea();
        this.scrollPane_1.setViewportView(this.txtComment);
    }
}

