/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditAttachmentMediaDialog;
import de.inahware.dav.client.gui.EditAttachmentTextDialog;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.AttachmentType;
import de.inahware.dav.requests.AttachmentDownload;
import de.inahware.edvj.Utils;
import de.inahware.edvj.gui.BlockingDialog;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.query.Select;
import java.awt.Component;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class EditAttachmentDialogs {
    public static DefaultDataEditDialog<Attachment> create(Component parent, ClientContext ctx, AttachmentObjectType objectType, Long objectId) throws Exception {
        return EditAttachmentDialogs.create(parent, ctx, objectType, objectId, false);
    }

    public static DefaultDataEditDialog<Attachment> create(Component parent, ClientContext ctx, AttachmentObjectType objectType, Long objectId, boolean hidden) throws Exception {
        return EditAttachmentDialogs.create(parent, ctx, objectType, objectId, hidden, "");
    }

    public static DefaultDataEditDialog<Attachment> create(Component parent, ClientContext ctx, AttachmentObjectType objectType, Long objectId, boolean hidden, String title) throws Exception {
        ResourceBundle BUNDLE = ClientContext.getBundle();
        JComboBox<Object> cmb = new JComboBox<Object>();
        cmb.addItem((Object)AttachmentType.TEXT);
        cmb.addItem((Object)AttachmentType.FILE);
        cmb.setSelectedIndex(0);
        cmb.setRenderer(new FormattedListCellRenderer(obj -> ((AttachmentType)((Object)((Object)obj))).getLocalizedString(BUNDLE)));
        int answer = JOptionPane.showConfirmDialog(parent, cmb, BUNDLE.getString("ShowAttachmentsDialog.messages.select_type"), 2, 3);
        if (answer != 0) {
            return null;
        }
        return EditAttachmentDialogs.create(ctx, objectType, objectId, (AttachmentType)((Object)cmb.getSelectedItem()), hidden, title);
    }

    public static DefaultDataEditDialog<Attachment> create(ClientContext ctx, AttachmentObjectType objectType, Long objectId, AttachmentType type) throws Exception {
        return EditAttachmentDialogs.create(ctx, objectType, objectId, type, false);
    }

    public static DefaultDataEditDialog<Attachment> create(ClientContext ctx, AttachmentObjectType objectType, Long objectId, AttachmentType type, boolean hidden) throws Exception {
        return EditAttachmentDialogs.create(ctx, objectType, objectId, type, hidden, "");
    }

    public static DefaultDataEditDialog<Attachment> create(ClientContext ctx, AttachmentObjectType objectType, Long objectId, AttachmentType type, boolean hidden, String title) throws Exception {
        switch (type) {
            case TEXT: {
                Attachment obj = new Attachment(objectType, objectId, type, null, hidden, title);
                return new EditAttachmentTextDialog(ctx, null, obj);
            }
            case FILE: {
                Attachment obj = new Attachment(objectType, objectId, type, null, hidden, title);
                return new EditAttachmentMediaDialog(ctx, null, obj);
            }
        }
        throw new RuntimeException("not implemented");
    }

    public static DefaultDataEditDialog<Attachment> create(Component parent, ClientContext ctx, long id) throws Exception {
        Attachment att = EUtils.blocking(parent, blocking -> ctx.query(new Select<Attachment>(Attachment.MODEL, Attachment.COL_ID.with(id))));
        switch (att.getType()) {
            case TEXT: {
                return new EditAttachmentTextDialog(ctx, att);
            }
            case FILE: {
                return new EditAttachmentMediaDialog(ctx, att);
            }
        }
        throw new RuntimeException("not implemented");
    }

    public static Path download(Component parent, ClientContext ctx, long id) throws Exception {
        return EUtils.blocking(parent, "Downloading", blocking -> EditAttachmentDialogs.downloadInner(blocking, ctx, id));
    }

    public static Path download(Component parent, ClientContext ctx, Attachment obj) throws Exception {
        return EUtils.blocking(parent, "Downloading", blocking -> EditAttachmentDialogs.downloadInner(blocking, ctx, obj));
    }

    public static Path downloadInner(BlockingDialog<?> blocking, ClientContext ctx, long id) throws Exception {
        Attachment obj = ctx.query(new Select<Attachment>(Attachment.MODEL, Attachment.COL_ID.with(id)));
        return EditAttachmentDialogs.downloadInner(blocking, ctx, obj);
    }

    public static Path downloadInner(BlockingDialog<?> blocking, ClientContext ctx, Attachment obj) throws Exception {
        long size = obj.getFilesize();
        blocking.setDeterminate(0, (int)size);
        ctx.query(new AttachmentDownload(obj.getId()));
        Path res = ctx.download(progress -> {
            blocking.setProgress((int)progress);
            long percent = progress * 100L / size;
            blocking.setProgressText(percent + "% (" + Utils.formatBytes(progress) + " / " + Utils.formatBytes(size) + ")");
        });
        blocking.setIndeterminate();
        return res;
    }

    public static void upload(BlockingDialog<?> blocking, ClientContext ctx, Path uploadFile) throws Exception {
        long size = Files.size(uploadFile);
        blocking.setDeterminate(0, (int)size);
        ctx.upload(uploadFile, progress -> {
            blocking.setProgress((int)progress);
            long percent = progress * 100L / size;
            blocking.setProgressText(percent + "% (" + Utils.formatBytes(progress) + " / " + Utils.formatBytes(size) + ")");
        });
        blocking.setIndeterminate();
    }
}

