/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditAttachmentDialogs;
import de.inahware.dav.client.gui.ImagePanel;
import de.inahware.dav.client.gui.LoadingPanel;
import de.inahware.dav.client.gui.PDFView;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.requests.AttachmentDownload;
import de.inahware.edvj.Utils;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.EFileChooser;
import de.inahware.edvj.gui.ETextArea;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.pdmodel.PDDocument;

public class EditAttachmentMediaDialog
extends DefaultDataEditDialog<Attachment> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext client;
    private Path visibleFile;
    private boolean tmpDownloading;
    private Path tmpFile;
    private Path uploadFile;
    private String uploadName;
    private JLabel lblTitle;
    private ETextField txtTitle;
    private JLabel lblFile;
    private JPanel panel;
    private ETextField txtFile;
    private JButton btnDownload;
    private JButton btnUpload;
    private JScrollPane panelPreview;
    private JLabel lblText;
    private JScrollPane scrollPane;
    private ETextArea textArea;
    private JLabel lblPreview;
    private JProgressBar progressBar;

    private EditAttachmentMediaDialog() {
        this.initialize();
    }

    public EditAttachmentMediaDialog(ClientContext ctx, Attachment obj) {
        this(ctx, obj, null);
    }

    public EditAttachmentMediaDialog(ClientContext ctx, Attachment obj, Attachment placeholder) {
        super(Attachment.MODEL, ctx, obj, placeholder);
        this.client = ctx;
        this.tmpDownloading = false;
        this.tmpFile = null;
        this.uploadFile = null;
        this.uploadName = null;
        this.setTitle(this.BUNDLE.getString("Attachment"));
        this.setWindowSize(1280, 720);
        this.initialize();
        this.addEditable(this.txtTitle);
        this.addEditable(this.textArea);
        this.addReadOnly(this.btnDownload);
        this.addEditable(this.btnUpload);
        this.btnUpload.addActionListener(e -> {
            EFileChooser dialog = new EFileChooser();
            dialog.setDialogTitle(this.BUNDLE.getString("generic.button.upload"));
            dialog.addFilter("PDF file", "pdf");
            dialog.addFilter("Image file", "jpg", "png", "bmp", "tiff");
            Path file = dialog.open(this);
            if (file == null) {
                return;
            }
            EUtils.catchWithDialog(this, () -> {
                this.displayFile(file);
                long size = Files.size(file);
                this.uploadFile = file;
                this.uploadName = this.uploadFile.getFileName().toString();
                this.txtFile.setText(this.uploadName + " (" + Utils.formatBytes(size) + ")");
            });
        });
        this.btnDownload.addActionListener(e -> {
            String fileName = ((Attachment)this.getObject()).getFilename();
            String ext = FilenameUtils.getExtension(fileName);
            EFileChooser dialog = new EFileChooser();
            dialog.resetChoosableFileFilters();
            if (!ext.isEmpty()) {
                dialog.setFileFilter(new FileNameExtensionFilter(ext + " file", ext));
            }
            dialog.setDialogTitle(this.BUNDLE.getString("generic.button.download"));
            dialog.setSelectedFile(Path.of(fileName, new String[0]).toFile());
            Path file = dialog.save(this);
            if (file == null) {
                return;
            }
            EUtils.catchWithDialog(this, () -> {
                if (this.tmpFile == null) {
                    EUtils.blocking((Component)this, blocking -> {
                        Path path = EditAttachmentDialogs.downloadInner(blocking, ctx, (Attachment)this.getObject());
                        Files.move(path, file, StandardCopyOption.REPLACE_EXISTING);
                    });
                } else {
                    EUtils.blocking((Component)this, blocking -> Files.copy(this.tmpFile, file, StandardCopyOption.REPLACE_EXISTING));
                }
                EUtils.showInfoDialog(this, "download successful!");
            });
        });
        this.addClosedListener(() -> EUtils.catchSilently(() -> {
            if (this.tmpFile != null) {
                Files.delete(this.tmpFile);
            }
        }));
    }

    @Override
    protected void displayObject(Attachment obj) throws Exception {
        this.setEditable(this.client.getPermissions().contains(Attachment.MODEL.getName() + ".update"));
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("Attachment") + " " + this.BUNDLE.getString("generic.title.new"));
        } else {
            this.setTitle(this.BUNDLE.getString("Attachment") + " #" + obj.getId());
            this.txtFile.setText(obj.getFilename() + " (" + Utils.formatBytes(obj.getFilesize()) + ")");
            if (obj.getLockCount() != 0L) {
                this.setEditable(false);
            }
        }
        this.txtTitle.setText(obj.getTitle());
        this.textArea.setText(obj.getText());
        this.uploadFile = null;
        this.uploadName = null;
        if (obj.getFilename() == null) {
            this.displayNone();
        } else if (this.previewOf(obj.getSubtype()) != PreviewType.NONE) {
            if (this.tmpFile == null && !this.tmpDownloading) {
                this.tmpDownloading = true;
                long size = obj.getFilesize();
                this.progressBar.setMaximum((int)size);
                new Thread(() -> {
                    try {
                        this.client.query(new AttachmentDownload(obj.getId()));
                        Path path = this.client.download(progress -> SwingUtilities.invokeLater(() -> {
                            this.progressBar.setValue((int)progress);
                            long percent = progress * 100L / size;
                            this.progressBar.setString(percent + "% (" + Utils.formatBytes(progress) + " / " + Utils.formatBytes(size) + ")");
                        }));
                        String ext = FilenameUtils.getExtension(obj.getFilename());
                        Path path2 = path.resolveSibling(path.getFileName().toString() + "." + ext);
                        Files.move(path, path2, new CopyOption[0]);
                        SwingUtilities.invokeLater(() -> {
                            this.tmpFile = path2;
                            this.tmpDownloading = false;
                            EUtils.catchSilently(() -> this.displayFile(this.tmpFile));
                            this.btnDownload.setEnabled(true);
                        });
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }).start();
            }
            if (this.tmpFile != null) {
                EUtils.catchSilently(() -> this.displayFile(this.tmpFile));
            } else {
                this.displayLoading();
                this.btnDownload.setEnabled(false);
            }
        } else {
            this.displayNone();
            this.btnDownload.setEnabled(true);
        }
    }

    private void displayNone() {
        JPanel panel = new JPanel();
        panel.setLayout(new MigLayout("", "[grow][][grow]", "[grow][][grow]"));
        JLabel label = new JLabel("No preview available");
        panel.add((Component)label, "cell 1 1,grow");
        this.panelPreview.setViewportView(panel);
        this.visibleFile = null;
    }

    private void displayLoading() {
        this.panelPreview.setViewportView(new LoadingPanel());
        this.visibleFile = null;
    }

    private void displayFile(Path file) throws Exception {
        if (file.equals(this.visibleFile)) {
            return;
        }
        switch (this.previewOf(file)) {
            case IMAGE: {
                BufferedImage img = ImageIO.read(file.toFile());
                this.panelPreview.setViewportView(new ImagePanel(img));
                this.visibleFile = file;
                break;
            }
            case PDF: {
                PDFView panel = new PDFView();
                panel.load(PDDocument.load(file.toFile()));
                this.panelPreview.setViewportView(panel);
                this.visibleFile = file;
                break;
            }
            case NONE: {
                this.displayNone();
            }
        }
    }

    private PreviewType previewOf(Path file) throws Exception {
        return this.previewOf(Files.probeContentType(file));
    }

    private PreviewType previewOf(String mimeType) {
        if (mimeType == null) {
            return PreviewType.NONE;
        }
        if (mimeType.startsWith("image/")) {
            return PreviewType.IMAGE;
        }
        if (mimeType.equals("application/pdf")) {
            return PreviewType.PDF;
        }
        return PreviewType.NONE;
    }

    @Override
    protected Attachment parseObject(Attachment old) throws Exception {
        Attachment obj = new Attachment(old);
        obj.setTitle(this.txtTitle.getText());
        obj.setText(this.textArea.getText());
        if (obj.getId() == null && this.uploadFile == null) {
            throw new RuntimeException(this.BUNDLE.getString("EditAttachmentFileDialog.messages.no_file_selected"));
        }
        if (this.uploadFile != null) {
            obj.setSubtype(Files.probeContentType(this.uploadFile));
            obj.setFilename(this.uploadName);
            obj.setFilesize(Files.size(this.uploadFile));
        }
        return obj;
    }

    @Override
    protected Attachment insert(Attachment obj) throws Exception {
        return EUtils.blocking((Component)this, blocking -> {
            EditAttachmentDialogs.upload(blocking, this.client, this.uploadFile);
            Attachment res = super.insert(blocking, obj);
            if (this.tmpFile == null) {
                this.tmpFile = Files.createTempFile("inahware-dav-", "-" + obj.getFilename(), new FileAttribute[0]);
            }
            Files.copy(this.uploadFile, this.tmpFile, StandardCopyOption.REPLACE_EXISTING);
            return res;
        });
    }

    @Override
    protected Attachment update(Attachment old, Attachment obj, List<DataField<?>> diff) throws Exception {
        return EUtils.blocking((Component)this, blocking -> {
            if (this.uploadFile != null) {
                EditAttachmentDialogs.upload(blocking, this.client, this.uploadFile);
            }
            Attachment res = super.update(blocking, old, obj, diff);
            if (this.uploadFile != null) {
                if (this.tmpFile == null) {
                    this.tmpFile = Files.createTempFile("inahware-dav-", "-" + obj.getFilename(), new FileAttribute[0]);
                }
                Files.copy(this.uploadFile, this.tmpFile, StandardCopyOption.REPLACE_EXISTING);
            }
            return res;
        });
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[][grow]", "[][][grow][60px:n]"));
        this.lblTitle = new JLabel(this.BUNDLE.getString("Attachment.TITLE") + ":");
        this.rootPanel.add((Component)this.lblTitle, "cell 0 0,alignx trailing");
        this.txtTitle = new ETextField();
        this.rootPanel.add((Component)this.txtTitle, "cell 1 0,growx");
        this.txtTitle.setColumns(10);
        this.lblFile = new JLabel(this.BUNDLE.getString("Attachment.FILE") + ":");
        this.rootPanel.add((Component)this.lblFile, "cell 0 1,alignx trailing,aligny center");
        this.panel = new JPanel();
        this.rootPanel.add((Component)this.panel, "cell 1 1,growx,aligny center");
        this.panel.setLayout(new MigLayout("", "0[grow][][]0", "0[]0"));
        this.txtFile = new ETextField();
        this.txtFile.setEditable(false);
        this.panel.add((Component)this.txtFile, "flowx,cell 0 0,growx,aligny center");
        this.txtFile.setColumns(10);
        this.btnUpload = new JButton(this.BUNDLE.getString("generic.button.upload"));
        this.panel.add((Component)this.btnUpload, "cell 1 0");
        this.btnDownload = new JButton(this.BUNDLE.getString("generic.button.download"));
        this.panel.add((Component)this.btnDownload, "cell 2 0");
        this.lblPreview = new JLabel("Preview:");
        this.rootPanel.add((Component)this.lblPreview, "cell 0 2,alignx right,aligny top");
        this.panelPreview = new JScrollPane();
        this.panelPreview.getVerticalScrollBar().setUnitIncrement(16);
        this.rootPanel.add((Component)this.panelPreview, "cell 1 2,grow");
        this.lblText = new JLabel(this.BUNDLE.getString("Attachment.TEXT") + ":");
        this.rootPanel.add((Component)this.lblText, "cell 0 3,alignx trailing,aligny top");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.rootPanel.add((Component)this.scrollPane, "cell 1 3,grow");
        this.textArea = new ETextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane.setViewportView(this.textArea);
        this.bottomPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
        this.progressBar = new JProgressBar();
        this.progressBar.setString("");
        this.progressBar.setStringPainted(true);
        this.bottomPanel.add((Component)this.progressBar, "cell 0 0,grow");
    }

    private static enum PreviewType {
        IMAGE,
        PDF,
        NONE;

    }
}

