/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.Attachment;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextArea;
import de.inahware.edvj.gui.ETextField;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class EditAttachmentTextDialog
extends DefaultDataEditDialog<Attachment> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JLabel lblTitle;
    private ETextField txtTitle;
    private JLabel lblText;
    private JScrollPane scrollPane;
    private ETextArea textArea;

    private EditAttachmentTextDialog() {
        this.initialize();
    }

    public EditAttachmentTextDialog(ClientContext ctx, Attachment obj) {
        this(ctx, obj, null);
    }

    public EditAttachmentTextDialog(ClientContext ctx, Attachment obj, Attachment placeholder) {
        super(Attachment.MODEL, ctx, obj, placeholder);
        this.ctx = ctx;
        this.setTitle(this.BUNDLE.getString("Attachment"));
        this.setWindowSize(640, 360);
        this.initialize();
        this.addEditable(this.txtTitle);
        this.addEditable(this.textArea);
    }

    @Override
    protected void displayObject(Attachment obj) throws Exception {
        this.setEditable(this.ctx.getPermissions().contains(Attachment.MODEL.getName() + ".update"));
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("Attachment") + " " + this.BUNDLE.getString("generic.title.new"));
        } else {
            this.setTitle(this.BUNDLE.getString("Attachment") + " #" + obj.getId());
            if (obj.getLockCount() != 0L) {
                this.setEditable(false);
            }
        }
        this.txtTitle.setText(obj.getTitle());
        this.textArea.setText(obj.getText());
    }

    @Override
    protected Attachment parseObject(Attachment old) throws Exception {
        Attachment obj = new Attachment(old);
        obj.setTitle(this.txtTitle.getText());
        obj.setText(this.textArea.getText());
        return obj;
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[][grow]", "[][grow]"));
        this.lblTitle = new JLabel(this.BUNDLE.getString("Attachment.TITLE") + ":");
        this.rootPanel.add((Component)this.lblTitle, "cell 0 0,alignx trailing");
        this.txtTitle = new ETextField();
        this.rootPanel.add((Component)this.txtTitle, "cell 1 0,growx");
        this.txtTitle.setColumns(10);
        this.lblText = new JLabel(this.BUNDLE.getString("Attachment.TEXT") + ":");
        this.rootPanel.add((Component)this.lblText, "cell 0 1,alignx trailing,aligny top");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.rootPanel.add((Component)this.scrollPane, "cell 1 1,grow");
        this.textArea = new ETextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane.setViewportView(this.textArea);
    }
}

