/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import com.github.lgooddatepicker.components.DatePicker;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditAttachmentDialogs;
import de.inahware.dav.client.gui.EditBankStatementItemDialog;
import de.inahware.dav.client.gui.ShowAttachmentsDialog;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.models.BankStatementFull;
import de.inahware.dav.models.BankStatementItem;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.edvj.I18N;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.EDataTable;
import de.inahware.edvj.gui.ETableModel;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;

public class EditBankStatementDialog
extends DefaultDataEditDialog<BankStatementFull> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private Attachment att_new;
    private JSplitPane splitPane;
    private JPanel panel;
    private JLabel lblId;
    private ETextField txtId;
    private JLabel lblDate;
    private DatePicker datePicker;
    private JLabel lblBalanceBefore;
    private ETextField txtBalanceBefore;
    private JLabel lblBalanceAfter;
    private ETextField txtBalanceAfter;
    private JLabel lblAttachment;
    private JButton btnAttachments;
    private JPanel panel_1;
    private JTextField txtAttachment;
    private JButton btnViewAttachment;
    private JButton btnNewAttachment;
    private JPanel panel_2;
    private JScrollPane scrollPane;
    private EDataTable<BankStatementItem> tblItems;
    private JPanel panel_3;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnMoveUp;
    private JButton btnMoveDown;

    private EditBankStatementDialog() {
        this.initialize();
    }

    public EditBankStatementDialog(ClientContext ctx, BankStatementFull obj) {
        this(ctx, obj, null);
    }

    public EditBankStatementDialog(ClientContext ctx, BankStatementFull stmt, BankStatementFull placeholder) {
        super(BankStatementFull.MODEL, ctx, stmt, placeholder);
        this.ctx = ctx;
        this.setTitle(this.BUNDLE.getString("BankStatement"));
        this.setWindowSize(1280, 720);
        this.initialize();
        this.addEditable(this.datePicker);
        this.addEditable(this.txtBalanceBefore);
        this.addEditable(this.txtBalanceAfter);
        this.addEditable(this.btnNewAttachment);
        this.addEditable(this.tblItems);
        this.addReadOnly(this.btnAttachments);
        this.btnViewAttachment.addActionListener(e -> EUtils.catchWithDialog(this, () -> EditAttachmentDialogs.create(this, ctx, this.att_new != null ? this.att_new.getId() : ((BankStatementFull)this.getObject()).getAttachmentId()).openPage(this)));
        this.btnNewAttachment.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            DefaultDataEditDialog<Attachment> dialog = EditAttachmentDialogs.create(this, ctx, AttachmentObjectType.BANKSTATEMENT, ((BankStatementFull)this.getObject()).getId(), true, this.BUNDLE.getString("BankStatement"));
            if (dialog == null) {
                return;
            }
            dialog.inputPage(this, res -> {
                if (res == null) {
                    return;
                }
                if (this.att_new != null) {
                    ctx.query(new Delete<Attachment>(Attachment.MODEL, Attachment.COL_ID.with(this.att_new.getId())));
                }
                this.att_new = res;
                this.displayAttachment(this.att_new.getId());
            });
        }));
        this.tblItems.addColumn(BankStatementItem.COL_DATE);
        this.tblItems.addColumn(BankStatementItem.COL_VALUE_DATE);
        this.tblItems.addColumn(BankStatementItem.COL_DESCRIPTION);
        this.tblItems.addColumn(BankStatementItem.COL_VALUE);
        this.tblItems.addDoubleClickAction(obj -> {
            if (this.tblItems.isEditable()) {
                new EditBankStatementItemDialog(ctx, (BankStatementItem)obj, null, true).inputInnerModal(this, true, obj2 -> {
                    if (obj2 != null) {
                        ((ETableModel)this.tblItems.getModel()).replaceRow(this.tblItems.getSelectedRow(), obj2);
                    }
                });
            } else {
                new EditBankStatementItemDialog(ctx, (BankStatementItem)obj, null, false).openInnerModal(this);
            }
        });
        this.tblItems.connect(this.btnAdd, obj -> this.tblItems.isEditable(), obj -> new EditBankStatementItemDialog(ctx, null, new BankStatementItem(), true).inputInnerModal(this, true, obj2 -> {
            if (obj2 != null) {
                ((ETableModel)this.tblItems.getModel()).addRow(obj2);
            }
        }));
        this.tblItems.connect(this.btnEdit, obj -> obj != null, obj -> {
            if (this.tblItems.isEditable()) {
                new EditBankStatementItemDialog(ctx, (BankStatementItem)obj, null, true).inputInnerModal(this, true, obj2 -> {
                    if (obj2 != null) {
                        ((ETableModel)this.tblItems.getModel()).replaceRow(this.tblItems.getSelectedRow(), obj2);
                    }
                });
            } else {
                new EditBankStatementItemDialog(ctx, (BankStatementItem)obj, null, false).openInnerModal(this);
            }
        });
        this.tblItems.connect(this.btnRemove, obj -> this.tblItems.isEditable() && obj != null, obj -> ((ETableModel)this.tblItems.getModel()).deleteRow(this.tblItems.getSelectedRow()));
        this.tblItems.connect(this.btnMoveUp, obj -> this.tblItems.isEditable() && obj != null && this.tblItems.getSelectedRow() > 0, _obj -> {
            int idx = this.tblItems.getSelectedRow();
            TableModel model = this.tblItems.getModel();
            BankStatementItem item = (BankStatementItem)((ETableModel)model).getRow(idx);
            ((ETableModel)model).deleteRow(idx);
            ((ETableModel)model).addRow(--idx, item);
            this.tblItems.setRowSelectionInterval(idx, idx);
        });
        this.tblItems.connect(this.btnMoveDown, obj -> this.tblItems.isEditable() && obj != null && this.tblItems.getSelectedRow() < this.tblItems.getRowCount() - 1, _obj -> {
            int idx = this.tblItems.getSelectedRow();
            TableModel model = this.tblItems.getModel();
            BankStatementItem item = (BankStatementItem)((ETableModel)model).getRow(idx);
            ((ETableModel)model).deleteRow(idx);
            ((ETableModel)model).addRow(++idx, item);
            this.tblItems.setRowSelectionInterval(idx, idx);
        });
        this.btnAttachments.addActionListener(e -> new ShowAttachmentsDialog(ctx, this.getTitle(), AttachmentObjectType.BANKSTATEMENT, ((BankStatementFull)this.getObject()).getId()).openInnerModal(this));
    }

    @Override
    protected void displayObject(BankStatementFull obj) throws Exception {
        if (this.att_new != null) {
            EUtils.blocking((Component)this, blocking -> this.ctx.query(new Delete<Attachment>(Attachment.MODEL, Attachment.COL_ID.with(this.att_new.getId()))));
            this.att_new = null;
        }
        this.setEditable(this.ctx.getPermissions().contains(BankStatementFull.MODEL.getName() + ".update"));
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("BankStatement") + " " + this.BUNDLE.getString("generic.title.new"));
            this.txtId.setText(this.BUNDLE.getString("generic.text.generated"));
            this.setEnabled(this.btnNewAttachment, false);
        } else {
            this.setTitle(this.BUNDLE.getString("BankStatement") + " #" + obj.getId());
            this.txtId.setText(obj.getId().toString());
            this.setEnabled(this.btnNewAttachment, true);
        }
        this.datePicker.setDate(obj.getDate());
        this.txtBalanceBefore.setText(I18N.formatDecimal(obj.getBalanceBefore(), ""));
        this.txtBalanceAfter.setText(I18N.formatDecimal(obj.getBalanceAfter(), ""));
        this.displayAttachment(obj.getAttachmentId());
        this.tblItems.setData(obj.getItems());
    }

    private void displayAttachment(Long id) {
        if (id == null) {
            this.txtAttachment.setText("-");
            this.btnViewAttachment.setEnabled(false);
        } else {
            this.txtAttachment.setText(this.BUNDLE.getString("Attachment") + " #" + id);
            this.btnViewAttachment.setEnabled(true);
        }
    }

    @Override
    protected BankStatementFull parseObject(BankStatementFull old) throws Exception {
        BigDecimal balance;
        String balance_str;
        BankStatementFull obj = new BankStatementFull(old);
        obj.setDate(this.datePicker.getDate());
        if (this.txtBalanceBefore.getText().isBlank()) {
            throw new RuntimeException("balance before empty");
        }
        try {
            balance_str = this.txtBalanceBefore.getText().trim();
            balance = I18N.parseDecimal(balance_str);
            obj.setBalanceBefore(balance.setScale(2, RoundingMode.UNNECESSARY));
        }
        catch (ArithmeticException | ParseException e) {
            throw new RuntimeException("invalid balance before", e);
        }
        if (this.txtBalanceAfter.getText().isBlank()) {
            throw new RuntimeException("balance before empty");
        }
        try {
            balance_str = this.txtBalanceAfter.getText().trim();
            balance = I18N.parseDecimal(balance_str);
            obj.setBalanceAfter(balance.setScale(2, RoundingMode.UNNECESSARY));
        }
        catch (ArithmeticException | ParseException e) {
            throw new RuntimeException("invalid balance after", e);
        }
        if (this.att_new != null) {
            obj.setAttachmentId(this.att_new.getId());
        }
        long row = 0L;
        for (BankStatementItem item : this.tblItems.getData()) {
            item.setRow(row++);
        }
        obj.setItems(this.tblItems.getData());
        obj.validate();
        return obj;
    }

    @Override
    protected BankStatementFull insert(BankStatementFull obj) throws Exception {
        BankStatementFull res = super.insert(obj);
        this.att_new = null;
        return res;
    }

    @Override
    protected BankStatementFull update(BankStatementFull old, BankStatementFull obj, List<DataField<?>> diff) throws Exception {
        return EUtils.blocking((Component)this, blocking -> {
            Long att_old = old.getAttachmentId();
            BankStatementFull res = super.update(blocking, old, obj, diff);
            if (att_old != null && this.att_new != null) {
                this.ctx.query(new Delete<Attachment>(Attachment.MODEL, Attachment.COL_ID.with(att_old)));
            }
            this.att_new = null;
            return res;
        });
    }

    private void initialize() {
        this.rootPanel.setLayout(new BorderLayout(0, 0));
        this.splitPane = new JSplitPane();
        this.rootPanel.add((Component)this.splitPane, "Center");
        this.panel = new JPanel();
        this.splitPane.setLeftComponent(this.panel);
        this.panel.setLayout(new MigLayout("", "[][grow]", "[][][][][]"));
        FlowLayout flowLayout = (FlowLayout)this.bottomPanel.getLayout();
        flowLayout.setAlignment(0);
        this.lblId = new JLabel(this.BUNDLE.getString("BankStatement.ID") + ":");
        this.panel.add((Component)this.lblId, "cell 0 0,alignx trailing");
        this.txtId = new ETextField();
        this.txtId.setEditable(false);
        this.panel.add((Component)this.txtId, "cell 1 0,growx");
        this.txtId.setColumns(10);
        this.lblDate = new JLabel(this.BUNDLE.getString("BankStatement.DATE") + ":");
        this.panel.add((Component)this.lblDate, "cell 0 1,alignx trailing");
        this.datePicker = new DatePicker();
        this.datePicker.getSettings().setAllowEmptyDates(false);
        this.panel.add((Component)this.datePicker, "cell 1 1,growx");
        this.lblBalanceBefore = new JLabel(this.BUNDLE.getString("BankStatement.BALANCE_BEFORE") + ":");
        this.panel.add((Component)this.lblBalanceBefore, "cell 0 2,alignx trailing");
        this.txtBalanceBefore = new ETextField();
        this.panel.add((Component)this.txtBalanceBefore, "cell 1 2,growx");
        this.txtBalanceBefore.setColumns(10);
        this.lblBalanceAfter = new JLabel(this.BUNDLE.getString("BankStatement.BALANCE_AFTER") + ":");
        this.panel.add((Component)this.lblBalanceAfter, "cell 0 3,alignx trailing");
        this.txtBalanceAfter = new ETextField();
        this.panel.add((Component)this.txtBalanceAfter, "cell 1 3,growx");
        this.txtBalanceAfter.setColumns(10);
        this.lblAttachment = new JLabel(this.BUNDLE.getString("BankStatement.ATTACHMENT_ID") + ":");
        this.panel.add((Component)this.lblAttachment, "cell 0 4,alignx trailing");
        this.btnAttachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.bottomPanel.add(this.btnAttachments);
        this.panel_1 = new JPanel();
        this.panel.add((Component)this.panel_1, "cell 1 4,growx");
        this.panel_1.setLayout(new MigLayout("", "0[grow][]0", "0[]0"));
        this.txtAttachment = new JTextField();
        this.txtAttachment.setEditable(false);
        this.panel_1.add((Component)this.txtAttachment, "cell 0 0,growx");
        this.txtAttachment.setColumns(10);
        this.btnViewAttachment = new JButton(this.BUNDLE.getString("generic.button.show"));
        this.panel_1.add((Component)this.btnViewAttachment, "flowx,cell 1 0");
        this.btnNewAttachment = new JButton(this.BUNDLE.getString("generic.button.new"));
        this.panel_1.add((Component)this.btnNewAttachment, "cell 1 0");
        this.panel_2 = new JPanel();
        this.splitPane.setRightComponent(this.panel_2);
        this.panel_2.setLayout(new MigLayout("", "[grow]", "[grow][]"));
        this.scrollPane = new JScrollPane();
        this.panel_2.add((Component)this.scrollPane, "cell 0 0,grow");
        this.tblItems = new EDataTable<BankStatementItem>(BankStatementItem.MODEL);
        this.tblItems.setFillsViewportHeight(true);
        this.scrollPane.setViewportView(this.tblItems);
        this.panel_3 = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)this.panel_3.getLayout();
        flowLayout_1.setAlignment(0);
        this.panel_2.add((Component)this.panel_3, "cell 0 1,grow");
        this.btnAdd = new JButton(this.BUNDLE.getString("generic.button.new"));
        this.panel_3.add(this.btnAdd);
        this.btnEdit = new JButton(this.BUNDLE.getString("generic.button.edit"));
        this.panel_3.add(this.btnEdit);
        this.btnRemove = new JButton(this.BUNDLE.getString("generic.button.remove"));
        this.panel_3.add(this.btnRemove);
        this.btnMoveUp = new JButton(this.BUNDLE.getString("generic.button.moveUp"));
        this.panel_3.add(this.btnMoveUp);
        this.btnMoveDown = new JButton(this.BUNDLE.getString("generic.button.moveDown"));
        this.panel_3.add(this.btnMoveDown);
    }
}

