/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import com.github.lgooddatepicker.components.DatePicker;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditRecordDialog;
import de.inahware.dav.client.gui.ShowRecordsDialog;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.BankStatementItem;
import de.inahware.dav.models.Record;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.EditDialog;
import de.inahware.edvj.query.Select;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class EditBankStatementItemDialog
extends EditDialog<BankStatementItem> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private Record record;
    private JLabel lblDate;
    private DatePicker dtDate;
    private JLabel lblValueDate;
    private DatePicker dtValueDate;
    private JLabel lblValue;
    private ETextField txtValue;
    private JLabel lblDescription;
    private ETextField txtDescription;
    private JLabel lblRecord;
    private JPanel panel_1;
    private ETextField txtRecord;
    private JButton btnSearch;
    private JButton btnReset;
    private JButton btnShow;

    private EditBankStatementItemDialog() {
        this.initialize();
    }

    public EditBankStatementItemDialog(ClientContext ctx, BankStatementItem item, BankStatementItem placeholder, boolean editable) {
        super(item, placeholder);
        this.ctx = ctx;
        this.setWindowSize(640, 270);
        this.initialize();
        if (editable) {
            this.setImmediate(true);
        } else {
            this.setEditable(false);
        }
        this.addEditable(this.dtDate);
        this.addEditable(this.dtValueDate);
        this.addEditable(this.txtValue);
        this.addEditable(this.txtDescription);
        this.addEditable(this.btnSearch);
        this.addEditable(this.btnReset);
        this.btnShow.addActionListener(e -> new EditRecordDialog(ctx, this.record).openInnerModal(this));
        this.btnSearch.addActionListener(e -> EUtils.catchWithDialog(this, () -> new ShowRecordsDialog(this, true, ctx).inputPage(this, record -> {
            if (record == null) {
                return;
            }
            this.record = record;
            this.txtRecord.setText(record.getDisplayName());
            this.btnShow.setEnabled(record != null);
        })));
        this.btnReset.addActionListener(e -> {
            this.record = null;
            this.txtRecord.setText("-");
        });
    }

    @Override
    protected void displayObject(BankStatementItem obj) throws Exception {
        EUtils.blocking((Component)this, blocking -> {
            this.record = null;
            if (obj.getRecordId() != null) {
                this.record = this.ctx.query(new Select<Record>(Record.MODEL, Article.COL_ID.with(obj.getRecordId())));
            }
        });
        this.dtDate.setDate(obj.getDate());
        this.dtValueDate.setDate(obj.getValueDate());
        this.txtValue.setText(I18N.formatDecimal(obj.getValue(), ""));
        this.txtDescription.setText(obj.getDescription());
        this.txtRecord.setText(this.record == null ? "-" : this.record.getDisplayName());
        this.btnShow.setEnabled(this.record != null);
    }

    @Override
    protected BankStatementItem parseObject(BankStatementItem old) throws Exception {
        BankStatementItem res = new BankStatementItem(old);
        res.setDate(this.dtDate.getDate());
        res.setValueDate(this.dtValueDate.getDate());
        try {
            String price_str = this.txtValue.getText().trim();
            if (price_str.isEmpty()) {
                res.setValue(null);
            } else {
                BigDecimal price = I18N.parseDecimal(price_str);
                res.setValue(price.setScale(2, RoundingMode.UNNECESSARY));
            }
        }
        catch (ArithmeticException | ParseException e) {
            throw new RuntimeException(this.BUNDLE.getString("EditLineItemDialog.messages.invalid_price"), e);
        }
        res.setDescription(this.txtDescription.getText());
        res.setRecordId(this.record == null ? null : this.record.getId());
        return res;
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[][grow]", "[][][][][]"));
        this.lblDate = new JLabel(this.BUNDLE.getString("BankStatementItem.DATE") + ":");
        this.rootPanel.add((Component)this.lblDate, "cell 0 0,alignx trailing");
        this.dtDate = new DatePicker();
        this.rootPanel.add((Component)this.dtDate, "cell 1 0,growx");
        this.lblValueDate = new JLabel(this.BUNDLE.getString("BankStatementItem.VALUE_DATE") + ":");
        this.rootPanel.add((Component)this.lblValueDate, "cell 0 1,alignx trailing");
        this.dtValueDate = new DatePicker();
        this.rootPanel.add((Component)this.dtValueDate, "cell 1 1,growx");
        this.lblValue = new JLabel(this.BUNDLE.getString("BankStatementItem.VALUE") + ":");
        this.rootPanel.add((Component)this.lblValue, "cell 0 2,alignx trailing");
        this.txtValue = new ETextField();
        this.rootPanel.add((Component)this.txtValue, "cell 1 2,growx");
        this.txtValue.setColumns(10);
        this.lblDescription = new JLabel(this.BUNDLE.getString("BankStatementItem.DESCRIPTION") + ":");
        this.rootPanel.add((Component)this.lblDescription, "cell 0 3,alignx trailing");
        this.txtDescription = new ETextField();
        this.rootPanel.add((Component)this.txtDescription, "cell 1 3,growx");
        this.txtDescription.setColumns(10);
        this.lblRecord = new JLabel(this.BUNDLE.getString("Record") + ":");
        this.rootPanel.add((Component)this.lblRecord, "cell 0 4,alignx trailing");
        this.panel_1 = new JPanel();
        this.rootPanel.add((Component)this.panel_1, "cell 1 4,growx");
        this.panel_1.setLayout(new MigLayout("", "0[grow]0[]0[]0[]0", "0[]0"));
        this.txtRecord = new ETextField();
        this.txtRecord.setEditable(false);
        this.panel_1.add((Component)this.txtRecord, "flowx,cell 0 0,growx,aligny center");
        this.txtRecord.setColumns(10);
        this.btnShow = new JButton(this.BUNDLE.getString("generic.button.show"));
        this.panel_1.add((Component)this.btnShow, "cell 1 0");
        this.btnSearch = new JButton(this.BUNDLE.getString("generic.button.search"));
        this.panel_1.add((Component)this.btnSearch, "cell 2 0");
        this.btnReset = new JButton(this.BUNDLE.getString("generic.button.reset"));
        this.panel_1.add((Component)this.btnReset, "cell 3 0");
    }
}

