/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.Counter;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextField;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class EditCounterDialog
extends DefaultDataEditDialog<Counter> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JLabel lblPrefix;
    private ETextField txtPrefix;
    private JLabel lblLength;
    private ETextField txtLength;
    private JLabel lblSuffix;
    private ETextField txtSuffix;
    private JCheckBox chkResetOnPrefixChange;

    private EditCounterDialog() {
        this.initialize();
    }

    public EditCounterDialog(ClientContext ctx, Counter counter) {
        super(Counter.MODEL, ctx, counter);
        this.ctx = ctx;
        this.setWindowSize(480, 270);
        this.initialize();
        this.addEditable(this.txtPrefix);
        this.addEditable(this.txtLength);
        this.addEditable(this.txtSuffix);
        this.addEditable(this.chkResetOnPrefixChange);
    }

    @Override
    protected void displayObject(Counter counter) {
        this.setTitle(this.BUNDLE.getString("Counter") + " " + this.BUNDLE.getString("Counters." + counter.getName()));
        this.txtPrefix.setText(counter.getPrefix());
        this.txtLength.setText(counter.getLength().toString());
        this.txtSuffix.setText(counter.getSuffix());
        this.chkResetOnPrefixChange.setSelected(counter.getResetOnPrefixChange());
        this.setEditable(this.ctx.getPermissions().contains(Counter.MODEL.getName() + ".update"));
    }

    @Override
    protected Counter parseObject(Counter old) throws Exception {
        Counter obj = new Counter(old);
        obj.setPrefix(this.txtPrefix.getText());
        try {
            obj.setLength(Byte.parseByte(this.txtLength.getText()));
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException(this.BUNDLE.getString("generic.messages.invalid_length"), ex);
        }
        obj.setSuffix(this.txtSuffix.getText());
        obj.setResetOnPrefixChange(this.chkResetOnPrefixChange.isSelected());
        return obj;
    }

    private void initialize() {
        FlowLayout flowLayout = (FlowLayout)this.bottomPanel.getLayout();
        flowLayout.setAlignment(0);
        this.rootPanel.setLayout(new MigLayout("", "[][381.00,grow]", "[][][][]"));
        this.lblPrefix = new JLabel(this.BUNDLE.getString("Counter.PREFIX") + ":");
        this.rootPanel.add((Component)this.lblPrefix, "cell 0 0,alignx trailing");
        this.txtPrefix = new ETextField();
        this.rootPanel.add((Component)this.txtPrefix, "cell 1 0,growx");
        this.txtPrefix.setColumns(10);
        this.lblLength = new JLabel(this.BUNDLE.getString("Counter.LENGTH") + ":");
        this.rootPanel.add((Component)this.lblLength, "cell 0 1,alignx trailing");
        this.txtLength = new ETextField();
        this.rootPanel.add((Component)this.txtLength, "cell 1 1,growx");
        this.txtLength.setColumns(10);
        this.lblSuffix = new JLabel(this.BUNDLE.getString("Counter.SUFFIX") + ":");
        this.rootPanel.add((Component)this.lblSuffix, "cell 0 2,alignx trailing");
        this.txtSuffix = new ETextField();
        this.rootPanel.add((Component)this.txtSuffix, "cell 1 2,growx");
        this.txtSuffix.setColumns(10);
        this.chkResetOnPrefixChange = new JCheckBox(this.BUNDLE.getString("Counter.RESET_ON_PREFIX_CHANGE"));
        this.rootPanel.add((Component)this.chkResetOnPrefixChange, "cell 1 3");
    }
}

