/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditAddressDialog;
import de.inahware.dav.client.gui.ShowAttachmentsDialog;
import de.inahware.dav.models.Address;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.Contact;
import de.inahware.dav.models.types.ContactType;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.gui.DataTablePanel;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETable;
import de.inahware.edvj.gui.ETableModel;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.gui.FormattedTableCellRenderer;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.Update;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.query.filter.Or;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.miginfocom.swing.MigLayout;

public class EditCustomerDialog
extends DefaultDataEditDialog<Customer> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JSplitPane splitPane;
    private JPanel panelLeft;
    private JLabel lblNumber;
    private ETextField txtNumber;
    private JPanel panel_1;
    private JComboBox<Salutation> cmbSalutation;
    private JLabel lblPrefix;
    private ETextField txtPrefix;
    private JLabel lblFirstName;
    private ETextField txtFirstName;
    private JLabel lblLastName;
    private ETextField txtLastName;
    private JLabel lblCompany;
    private ETextField txtCompany;
    private JLabel lblContact;
    private JScrollPane scrollPane;
    private ETable<Contact> tableContacts;
    private JPanel panel;
    private JButton btnAddContact;
    private JButton btnRemoveContact;
    private JPanel panelRight;
    private JLabel lblAddresses;
    private DataTablePanel<Address> tableAddresses;
    private JButton btnAttachments;

    private EditCustomerDialog() {
        this.initialize();
    }

    public EditCustomerDialog(ClientContext ctx, Customer obj) {
        this(ctx, obj, null);
    }

    public EditCustomerDialog(ClientContext ctx, Customer customer, Customer placeholder) {
        super(Customer.MODEL, ctx, customer, placeholder);
        this.ctx = ctx;
        this.setTitle(this.BUNDLE.getString("Customer"));
        this.setWindowSize(800, 450);
        this.initialize();
        this.addEditable(this.cmbSalutation);
        this.addEditable(this.txtPrefix);
        this.addEditable(this.txtFirstName);
        this.addEditable(this.txtLastName);
        this.addEditable(this.txtCompany);
        this.addEditable(this.tableContacts);
        this.cmbSalutation.addItemListener(ev -> {
            boolean enabled = this.cmbSalutation.getSelectedItem() != null;
            this.txtPrefix.setEnabled(enabled);
            this.txtFirstName.setEnabled(enabled);
            this.txtLastName.setEnabled(enabled);
        });
        this.cmbSalutation.setRenderer(new FormattedListCellRenderer(type -> type == null ? "-" : ((Salutation)((Object)((Object)type))).getLocalizedString(this.BUNDLE)));
        this.cmbSalutation.addItem(null);
        for (Salutation s2 : Salutation.values()) {
            this.cmbSalutation.addItem(s2);
        }
        this.cmbSalutation.setSelectedIndex(1);
        this.cmbSalutation.setSelectedIndex(0);
        this.tableContacts.addColumn("", ContactType.class, c -> c.type, (c, value) -> {
            c.type = (ContactType)((Object)((Object)value));
        });
        this.tableContacts.addColumn("", c -> c.value, (c, value) -> {
            c.value = value.toString();
        });
        this.tableContacts.setDefaultRenderer(ContactType.class, new FormattedTableCellRenderer(type -> type == null ? null : ((ContactType)((Object)((Object)type))).getLocalizedString(this.BUNDLE)));
        JComboBox<ContactType> comboBox = new JComboBox<ContactType>(ContactType.values());
        comboBox.setRenderer(new FormattedListCellRenderer(type -> ((ContactType)((Object)((Object)type))).getLocalizedString(this.BUNDLE)));
        this.tableContacts.setDefaultEditor(ContactType.class, new DefaultCellEditor(comboBox));
        this.tableContacts.connect(this.btnAddContact, sel -> this.tableContacts.isEditable(), sel -> ((ETableModel)this.tableContacts.getModel()).addRow(new Contact(ContactType.PHONE, "")));
        this.tableContacts.connect(this.btnRemoveContact, sel -> this.tableContacts.isEditable() && sel != null, sel -> {
            int row = this.tableContacts.getSelectedRow();
            ((ETableModel)this.tableContacts.getModel()).deleteRow(row);
        });
        this.tableAddresses.disableSearch();
        this.tableAddresses.addColumn(Address.COL_DEFAULT_ADDRESS);
        this.tableAddresses.addColumn(Address.COL_DEFAULT_SHIPPING_ADDRESS);
        this.tableAddresses.addColumn(Address.COL_COMPANY);
        this.tableAddresses.addColumn(Address.COL_SALUTATION, s -> s == null ? "-" : s.getLocalizedString(this.BUNDLE));
        this.tableAddresses.addColumn(Address.COL_PREFIX);
        this.tableAddresses.addColumn(Address.COL_FIRST_NAME);
        this.tableAddresses.addColumn(Address.COL_LAST_NAME);
        this.tableAddresses.addColumn(Address.COL_ADDRESS1);
        this.tableAddresses.addColumn(Address.COL_ADDRESS2);
        this.tableAddresses.addColumn(Address.COL_COUNTRY, c -> new Locale("", (String)c).getDisplayCountry());
        this.tableAddresses.setFilter(new Or(new Filter[0]));
        this.tableAddresses.addDoubleClickAction(obj -> new EditAddressDialog(ctx, (Address)obj).openInnerModal(this, () -> this.tableAddresses.refresh()));
        if (ctx.getPermissions().contains(Address.MODEL.getName() + ".insert")) {
            this.tableAddresses.addButton(this.BUNDLE.getString("generic.button.new"), _obj -> this.getObject() != null, _obj -> {
                Customer obj = (Customer)this.getObject();
                Address address = new Address();
                address.setCustomerId(obj.getId());
                address.setSalutation(obj.getSalutation());
                address.setPrefix(obj.getPrefix());
                address.setFirstName(obj.getFirstName());
                address.setLastName(obj.getLastName());
                address.setCompany(obj.getCompany());
                new EditAddressDialog(ctx, null, address).openInnerModal(this, () -> this.tableAddresses.refresh());
            });
        }
        this.tableAddresses.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> new EditAddressDialog(ctx, (Address)obj).openInnerModal(this, () -> this.tableAddresses.refresh()));
        if (ctx.getPermissions().contains(Address.MODEL.getName() + ".delete")) {
            this.tableAddresses.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null, obj -> {
                int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditPersonDialog.messages.delete_address_confirm.text1") + "\n\n    " + obj.getDisplayString(this.BUNDLE) + "\n\n" + this.BUNDLE.getString("EditPersonDialog.messages.delete_address_confirm.text2"), this.getTitle(), 0);
                if (answer != 0) {
                    return;
                }
                EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<Address>(Address.MODEL, obj.getPrimaryFilter())));
                this.tableAddresses.refresh();
            });
        }
        this.tableAddresses.addButton(this.BUNDLE.getString("EditPersonDialog.button.set_address"), obj -> obj != null && obj.isDefaultAddress() == false, obj -> {
            EUtils.blocking((Component)this, blocking -> ctx.query(new Update<Address>(Address.MODEL, List.of(Address.COL_DEFAULT_ADDRESS.with(true)), Address.COL_ID.with(obj.getId()))));
            this.tableAddresses.refresh();
        });
        this.tableAddresses.addButton(this.BUNDLE.getString("EditPersonDialog.button.set_shipping_address"), obj -> obj != null && obj.isDefaultShippingAddress() == false, obj -> {
            EUtils.blocking((Component)this, blocking -> ctx.query(new Update<Address>(Address.MODEL, List.of(Address.COL_DEFAULT_SHIPPING_ADDRESS.with(true)), Address.COL_ID.with(obj.getId()))));
            this.tableAddresses.refresh();
        });
        this.btnAttachments.addActionListener(e -> new ShowAttachmentsDialog(ctx, this.getTitle(), AttachmentObjectType.CUSTOMER, ((Customer)this.getObject()).getId()).openInnerModal(this));
    }

    @Override
    public void displayObject(Customer obj) throws Exception {
        this.setEditable(this.ctx.getPermissions().contains(Customer.MODEL.getName() + ".update"));
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("Customer") + " " + this.BUNDLE.getString("generic.title.new"));
            this.txtNumber.setText(this.BUNDLE.getString("generic.text.generated"));
            this.btnAttachments.setEnabled(false);
        } else {
            this.setTitle(this.BUNDLE.getString("Customer") + " " + obj.getNumber());
            this.txtNumber.setText(obj.getNumber());
            this.btnAttachments.setEnabled(true);
        }
        this.cmbSalutation.setSelectedItem((Object)obj.getSalutation());
        this.txtPrefix.setText(obj.getPrefix());
        this.txtFirstName.setText(obj.getFirstName());
        this.txtLastName.setText(obj.getLastName());
        this.txtCompany.setText(obj.getCompany());
        this.tableContacts.setData(obj.getContactList());
        if (obj.getId() == null) {
            this.tableAddresses.setFilter(new Or(new Filter[0]));
        } else {
            this.tableAddresses.setFilter(Address.COL_CUSTOMER_ID.with(obj.getId()));
        }
        this.tableAddresses.refresh();
    }

    @Override
    public Customer parseObject(Customer old) throws Exception {
        Customer obj = new Customer(old);
        obj.setSalutation((Salutation)((Object)this.cmbSalutation.getSelectedItem()));
        if (obj.getSalutation() == null) {
            obj.setPrefix("");
            obj.setFirstName("");
            obj.setLastName("");
        } else {
            obj.setPrefix(this.txtPrefix.getText().trim());
            obj.setFirstName(this.txtFirstName.getText().trim());
            obj.setLastName(this.txtLastName.getText().trim());
        }
        obj.setCompany(this.txtCompany.getText().trim());
        obj.setContactList(this.tableContacts.getData());
        obj.validate();
        return obj;
    }

    private void initialize() {
        this.rootPanel.setLayout(new BorderLayout(0, 0));
        FlowLayout flowLayout = (FlowLayout)this.bottomPanel.getLayout();
        flowLayout.setAlignment(0);
        this.splitPane = new JSplitPane();
        this.rootPanel.add(this.splitPane);
        this.panelLeft = new JPanel();
        this.splitPane.setLeftComponent(this.panelLeft);
        this.panelLeft.setLayout(new MigLayout("", "[][grow]", "[][][][][][grow][]"));
        this.lblNumber = new JLabel(this.BUNDLE.getString("Customer.NUMBER") + ":");
        this.panelLeft.add((Component)this.lblNumber, "cell 0 0,alignx trailing");
        this.txtNumber = new ETextField();
        this.txtNumber.setEditable(false);
        this.panelLeft.add((Component)this.txtNumber, "cell 1 0,growx");
        this.txtNumber.setColumns(10);
        this.lblPrefix = new JLabel(this.BUNDLE.getString("Customer.SALUTATION") + ":");
        this.panelLeft.add((Component)this.lblPrefix, "cell 0 2,alignx trailing");
        this.panel_1 = new JPanel();
        this.panelLeft.add((Component)this.panel_1, "flowx,cell 1 2,grow");
        this.panel_1.setLayout(new BorderLayout(0, 0));
        this.cmbSalutation = new JComboBox();
        this.panel_1.add(this.cmbSalutation, "West");
        this.txtPrefix = new ETextField();
        this.panel_1.add(this.txtPrefix);
        this.txtPrefix.setColumns(10);
        this.lblFirstName = new JLabel(this.BUNDLE.getString("Customer.FIRST_NAME") + ":");
        this.panelLeft.add((Component)this.lblFirstName, "cell 0 3,alignx trailing");
        this.txtFirstName = new ETextField();
        this.panelLeft.add((Component)this.txtFirstName, "cell 1 3,growx");
        this.txtFirstName.setColumns(10);
        this.lblLastName = new JLabel(this.BUNDLE.getString("Customer.LAST_NAME") + ":");
        this.panelLeft.add((Component)this.lblLastName, "cell 0 4,alignx trailing");
        this.txtLastName = new ETextField();
        this.panelLeft.add((Component)this.txtLastName, "cell 1 4,growx");
        this.txtLastName.setColumns(10);
        this.lblCompany = new JLabel(this.BUNDLE.getString("Customer.COMPANY") + ":");
        this.panelLeft.add((Component)this.lblCompany, "cell 0 1,alignx trailing");
        this.txtCompany = new ETextField();
        this.panelLeft.add((Component)this.txtCompany, "cell 1 1,growx");
        this.txtCompany.setColumns(10);
        this.lblContact = new JLabel(this.BUNDLE.getString("Customer.CONTACT") + ":");
        this.panelLeft.add((Component)this.lblContact, "cell 0 5,alignx trailing,aligny top");
        this.scrollPane = new JScrollPane();
        this.panelLeft.add((Component)this.scrollPane, "cell 1 5,grow");
        this.tableContacts = new ETable();
        this.tableContacts.setFillsViewportHeight(true);
        this.tableContacts.setTableHeader(null);
        this.scrollPane.setViewportView(this.tableContacts);
        this.panel = new JPanel();
        FlowLayout fl_panel = (FlowLayout)this.panel.getLayout();
        fl_panel.setVgap(0);
        fl_panel.setHgap(0);
        fl_panel.setAlignment(2);
        this.panelLeft.add((Component)this.panel, "cell 1 6,grow");
        this.btnAddContact = new JButton(this.BUNDLE.getString("generic.button.new"));
        this.panel.add(this.btnAddContact);
        this.btnRemoveContact = new JButton(this.BUNDLE.getString("generic.button.remove"));
        this.panel.add(this.btnRemoveContact);
        this.panelRight = new JPanel();
        this.splitPane.setRightComponent(this.panelRight);
        this.panelRight.setLayout(new MigLayout("", "[grow]", "[][grow]"));
        this.lblAddresses = new JLabel(this.BUNDLE.getString("Addresses") + ":");
        this.panelRight.add((Component)this.lblAddresses, "cell 0 0");
        this.tableAddresses = new DataTablePanel<Address>(Address.MODEL, this.ctx.getClient());
        this.panelRight.add(this.tableAddresses, "cell 0 1,grow");
        this.btnAttachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.bottomPanel.add(this.btnAttachments);
    }
}

