/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import com.github.lgooddatepicker.components.DatePicker;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ChooseArticleGroupDialog;
import de.inahware.dav.client.gui.ShowArticlesDialog;
import de.inahware.dav.client.gui.ShowCustomersDialog;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.ArticleGroup;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.Discount;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextArea;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Select;
import java.awt.Component;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class EditDiscountDialog
extends DefaultDataEditDialog<Discount> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private Customer customer;
    private ArticleGroup group;
    private Article article;
    private JLabel lblFromUntil;
    private DatePicker txtFrom;
    private DatePicker txtUntil;
    private JLabel lblCustomer;
    private JPanel panel;
    private ETextField txtCustomer;
    private JButton btnCustomer;
    private JLabel lblArticleGroup;
    private JPanel panel_1;
    private ETextField txtArticleGroup;
    private JButton btnArticleGroup;
    private JLabel lblArticle;
    private JPanel panel_2;
    private ETextField txtArticle;
    private JButton btnArticle;
    private JLabel lblDiscount;
    private ETextField txtDiscount;
    private JLabel lblDescription;
    private JScrollPane scrollPane;
    private ETextArea txtDescription;

    private EditDiscountDialog() {
        this.initialize();
    }

    public EditDiscountDialog(ClientContext ctx, Discount discount) {
        this(ctx, discount, null);
    }

    public EditDiscountDialog(ClientContext ctx, Discount discount, Discount placeholder) {
        super(Discount.MODEL, ctx, discount, placeholder);
        this.ctx = ctx;
        this.setTitle(this.BUNDLE.getString("Discount"));
        this.setWindowSize(480, 270);
        this.initialize();
        this.addEditable(this.txtFrom);
        this.addEditable(this.txtUntil);
        this.addEditable(this.btnCustomer);
        this.addEditable(this.btnArticleGroup);
        this.addEditable(this.btnArticle);
        this.addEditable(this.txtDiscount);
        this.addEditable(this.txtDescription);
        this.btnCustomer.addActionListener(ev -> EUtils.catchWithDialog(this, () -> new ShowCustomersDialog(true, ctx).inputInnerModal(this, obj -> {
            if (obj == null) {
                return;
            }
            this.customer = obj;
            this.txtCustomer.setText(obj.getNumber() + " - " + obj.getDisplayName(this.BUNDLE));
        })));
        this.btnArticleGroup.addActionListener(ev -> EUtils.catchWithDialog(this, () -> new ChooseArticleGroupDialog(ctx).inputInnerModal(this, group -> {
            if (group == null) {
                return;
            }
            this.group = group;
            this.txtArticleGroup.setText(group == null ? "-" : group.getTitle());
            this.article = null;
            this.txtArticle.setText("-");
        })));
        this.btnArticle.addActionListener(ev -> EUtils.catchWithDialog(this, () -> new ShowArticlesDialog(true, ctx).inputInnerModal(this, (Article article) -> {
            if (article == null) {
                return;
            }
            this.article = article;
            this.txtArticle.setText(article.getDisplayName());
            this.group = null;
            this.txtArticleGroup.setText("-");
        })));
    }

    @Override
    protected void displayObject(Discount obj) throws Exception {
        EUtils.blocking((Component)this, blocking -> {
            this.customer = null;
            if (obj.getCustomerId() != null) {
                this.customer = this.ctx.query(new Select<Customer>(Customer.MODEL, Customer.COL_ID.with(obj.getCustomerId())));
            }
            this.group = null;
            if (obj.getArticleGroupId() != null) {
                this.group = this.ctx.query(new Select<ArticleGroup>(ArticleGroup.MODEL, ArticleGroup.COL_ID.with(obj.getArticleGroupId())));
            }
            if (obj.getArticleId() != null) {
                this.article = this.ctx.query(new Select<Article>(Article.MODEL, Article.COL_ID.with(obj.getArticleId())));
            }
        });
        this.setEditable(this.ctx.getPermissions().contains(Discount.MODEL.getName() + ".update"));
        this.txtFrom.setDate(obj.getFrom());
        this.txtUntil.setDate(obj.getUntil());
        this.txtCustomer.setText((String)(this.customer == null ? "-" : this.customer.getNumber() + " - " + this.customer.getDisplayName(this.BUNDLE)));
        this.txtArticleGroup.setText(this.group == null ? "-" : this.group.getTitle());
        this.txtArticle.setText(this.article == null ? "-" : this.article.getDisplayName());
        this.txtDiscount.setText(I18N.formatDecimal(obj.getDiscount(), ""));
        this.txtDescription.setText(obj.getDescription());
    }

    @Override
    protected Discount parseObject(Discount old) throws Exception {
        Discount obj = new Discount(old);
        obj.setFrom(this.txtFrom.getDate());
        obj.setUntil(this.txtUntil.getDate());
        obj.setCustomerId(this.customer == null ? null : this.customer.getId());
        obj.setArticleGroupId(this.group == null ? null : this.group.getId());
        obj.setArticleId(this.article == null ? null : this.article.getId());
        try {
            obj.setDiscount(I18N.parseDecimal(this.txtDiscount.getText()));
        }
        catch (ParseException ex) {
            throw new RuntimeException(this.BUNDLE.getString("generic.messages.invalid_discount"), ex);
        }
        obj.setDescription(this.txtDescription.getText());
        obj.validate();
        return obj;
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[][grow][grow]", "[][][][][][grow]"));
        this.lblFromUntil = new JLabel(this.BUNDLE.getString("Discount.BEGIN") + "/" + this.BUNDLE.getString("Discount.END") + ":");
        this.rootPanel.add((Component)this.lblFromUntil, "cell 0 0,alignx trailing,aligny center");
        this.txtFrom = new DatePicker();
        this.rootPanel.add((Component)this.txtFrom, "cell 1 0,growx");
        this.txtUntil = new DatePicker();
        this.rootPanel.add((Component)this.txtUntil, "cell 2 0,growx");
        this.lblCustomer = new JLabel(this.BUNDLE.getString("Discount.CUSTOMER") + ":");
        this.rootPanel.add((Component)this.lblCustomer, "cell 0 1,alignx trailing");
        this.panel = new JPanel();
        this.rootPanel.add((Component)this.panel, "cell 1 1 2 1,grow");
        this.panel.setLayout(new MigLayout("", "0[grow][]0", "0[]0"));
        this.txtCustomer = new ETextField();
        this.txtCustomer.setEditable(false);
        this.panel.add((Component)this.txtCustomer, "cell 0 0,growx,aligny center");
        this.txtCustomer.setColumns(10);
        this.btnCustomer = new JButton(this.BUNDLE.getString("generic.button.search"));
        this.panel.add((Component)this.btnCustomer, "cell 1 0");
        this.lblArticleGroup = new JLabel(this.BUNDLE.getString("Discount.ARTICLE_GROUP") + ":");
        this.rootPanel.add((Component)this.lblArticleGroup, "cell 0 2,alignx trailing");
        this.panel_1 = new JPanel();
        this.rootPanel.add((Component)this.panel_1, "cell 1 2 2 1,grow");
        this.panel_1.setLayout(new MigLayout("", "0[grow][]0", "0[]0"));
        this.txtArticleGroup = new ETextField();
        this.txtArticleGroup.setEditable(false);
        this.panel_1.add((Component)this.txtArticleGroup, "cell 0 0,growx,aligny center");
        this.txtArticleGroup.setColumns(10);
        this.btnArticleGroup = new JButton(this.BUNDLE.getString("generic.button.search"));
        this.panel_1.add((Component)this.btnArticleGroup, "cell 1 0");
        this.lblArticle = new JLabel(this.BUNDLE.getString("Discount.ARTICLE") + ":");
        this.rootPanel.add((Component)this.lblArticle, "cell 0 3,alignx trailing");
        this.panel_2 = new JPanel();
        this.rootPanel.add((Component)this.panel_2, "cell 1 3 2 1,grow");
        this.panel_2.setLayout(new MigLayout("", "0[grow][]0", "0[]0"));
        this.txtArticle = new ETextField();
        this.txtArticle.setEditable(false);
        this.panel_2.add((Component)this.txtArticle, "cell 0 0,growx,aligny center");
        this.txtArticle.setColumns(10);
        this.btnArticle = new JButton(this.BUNDLE.getString("generic.button.search"));
        this.panel_2.add((Component)this.btnArticle, "cell 1 0");
        this.lblDiscount = new JLabel(this.BUNDLE.getString("Discount.DISCOUNT") + ":");
        this.rootPanel.add((Component)this.lblDiscount, "cell 0 4,alignx trailing");
        this.txtDiscount = new ETextField();
        this.rootPanel.add((Component)this.txtDiscount, "cell 1 4 2 1,growx");
        this.txtDiscount.setColumns(10);
        this.lblDescription = new JLabel(this.BUNDLE.getString("Discount.DESCRIPTION") + ":");
        this.rootPanel.add((Component)this.lblDescription, "cell 0 5,alignx trailing,aligny top");
        this.scrollPane = new JScrollPane();
        this.rootPanel.add((Component)this.scrollPane, "cell 1 5 2 1,grow");
        this.txtDescription = new ETextArea();
        this.scrollPane.setViewportView(this.txtDescription);
    }
}

