/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import com.github.lgooddatepicker.components.DatePicker;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.ClientDocumentRenderer;
import de.inahware.dav.client.gui.ChooseAddressDialog;
import de.inahware.dav.client.gui.ChooseDocumentsDialog;
import de.inahware.dav.client.gui.ChooseLineItemsDialog;
import de.inahware.dav.client.gui.EditAttachmentDialogs;
import de.inahware.dav.client.gui.EditLineItemDialog;
import de.inahware.dav.client.gui.EditLineItemDialog2;
import de.inahware.dav.client.gui.PrintDialog;
import de.inahware.dav.client.gui.ShowAttachmentsDialog;
import de.inahware.dav.client.gui.ShowCustomersDialog;
import de.inahware.dav.client.gui.ShowVendorsDialog;
import de.inahware.dav.models.Address;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.Deduction;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.LineItem;
import de.inahware.dav.models.Order;
import de.inahware.dav.models.OrderDocumentView;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.DocumentServiceType;
import de.inahware.dav.models.types.DocumentType;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.models.types.Salutation;
import de.inahware.dav.models.types.Taxation;
import de.inahware.dav.models.types.TotalPrice;
import de.inahware.dav.requests.DocumentCancel;
import de.inahware.dav.requests.DocumentCancelItems;
import de.inahware.dav.requests.DocumentComplete;
import de.inahware.dav.requests.DocumentFinishDraft;
import de.inahware.dav.requests.DocumentMerge;
import de.inahware.dav.requests.DocumentPay;
import de.inahware.dav.requests.DocumentPrinted;
import de.inahware.dav.requests.DocumentSplit;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.EDataTable;
import de.inahware.edvj.gui.ETableModel;
import de.inahware.edvj.gui.ETextArea;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.EditDialog;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.SelectAll;
import de.inahware.edvj.query.filter.And;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Path;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.pdfbox.pdmodel.PDDocument;

public class EditDocumentDialog
extends DefaultDataEditDialog<DocumentFull> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private List<TaxRate> taxes;
    private DocumentType type;
    private Customer customer;
    private Vendor vendor;
    private Taxation taxation;
    private List<Order> orders;
    private List<DocumentFull> parents;
    private JSplitPane splitPane;
    private JPanel panel;
    private JLabel lblType;
    private ETextField txtType;
    private JLabel lblNumber;
    private ETextField txtNumber;
    private JLabel lblDate;
    private DatePicker dtDate;
    private JComboBox<DocumentServiceType> cmbServiceType;
    private DatePicker dtServiceDate1;
    private DatePicker dtServiceDate2;
    private JLabel lblDueDate;
    private DatePicker dtDueDate;
    private JPanel panel_1;
    private JLabel lblPersonId;
    private ETextField txtPersonId;
    private JButton btnSearchPerson;
    private JPanel panel_2;
    private JLabel lblAddress;
    private JButton btnSelectAddress;
    private JLabel lblSalutation;
    private JPanel panel_3;
    private JComboBox<Salutation> cmbSalutation;
    private ETextField txtPrefix;
    private JLabel lblFirstName;
    private ETextField txtFirstName;
    private JLabel lblLastName;
    private ETextField txtLastName;
    private JLabel lblCompany;
    private ETextField txtCompany;
    private JLabel lblAddress1;
    private ETextField txtAddress1;
    private JLabel lblAddress2;
    private ETextField txtAddress2;
    private JLabel lblCountry;
    private JComboBox<String> cmbCountry;
    private JLabel lblReferenceNumber;
    private ETextField txtReferenceNumber;
    private JLabel lblText;
    private JScrollPane scrollPane;
    private ETextArea txtText;
    private JPanel panel_4;
    private JSplitPane splitPane_1;
    private JPanel panel_5;
    private JLabel lblItems;
    private JScrollPane scrollPane_1;
    private EDataTable<LineItem> tblItems;
    private JPanel panel_6;
    private JPanel panel_items_buttons;
    private JPanel panel_7;
    private JButton btnShow;
    private JPanel panel_8;
    private JButton btnShow2;
    private JButton btnSplit;
    private JButton btnMerge;
    private JPanel panel_9;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnMoveUp;
    private JButton btnMoveDown;
    private JPanel panel_10;
    private JLabel lblNetPrice;
    private ETextField txtNetPrice;
    private JLabel lblTotalPrice;
    private ETextField txtTotalPrice;
    private JPanel panel_11;
    private JLabel lblDeductions;
    private JScrollPane scrollPane_2;
    private EDataTable<Deduction> tblDeductions;
    private JLabel lblPartialPrice;
    private JSeparator separator;
    private JPanel buttons_done;
    private JButton btn_done_attachments;
    private JButton btn_done_print;
    private JPanel buttons_offer;
    private JButton btn_offer_attachments;
    private JButton btn_offer_print;
    private JButton btn_offer_create_confirm;
    private JButton btn_offer_cancel;
    private JPanel buttons_confirm;
    private JButton btn_confirm_attachments;
    private JButton btn_confirm_print;
    private JButton btn_confirm_create_receipt;
    private JButton btn_confirm_create_invoice;
    private JButton btn_confirm_cancel;
    private JPanel buttons_receipt;
    private JButton btn_receipt_attachments;
    private JButton btn_receipt_print;
    private JButton btn_receipt_create_invoice;
    private JButton btn_receipt_cancel;
    private JPanel buttons_invoice;
    private JButton btn_invoice_attachments;
    private JButton btn_invoice_print;
    private JButton btn_invoice_confirm;
    private JButton btn_invoice_cancel;
    private JPanel buttons_deposit_invoice;
    private JButton btn_deposit_invoice_attachments;
    private JButton btn_deposit_invoice_print;
    private JButton btn_deposit_invoice_confirm;
    private JButton btn_deposit_invoice_cancel;
    private JButton btn_deposit_invoice_create_receipt;
    private JButton btn_deposit_invoice_create_next_invoice;
    private JPanel buttons_partial_invoice;
    private JButton btn_partial_invoice_attachments;
    private JButton btn_partial_invoice_print;
    private JButton btn_partial_invoice_confirm;
    private JButton btn_partial_invoice_cancel;
    private JButton btn_partial_invoice_create_next_invoice;
    private JPanel buttons_invoice_completed;
    private JButton btn_invoice_completed_attachments;
    private JButton btn_invoice_completed_print;
    private JButton btn_invoice_completed_create_cancelinvoice;
    private JPanel buttons_request;
    private JButton btn_request_attachments;
    private JButton btn_request_print;
    private JButton btn_request_create_purchase;
    private JButton btn_request_cancel;
    private JPanel buttons_purchase;
    private JButton btn_purchase_attachments;
    private JButton btn_purchase_print;
    private JButton btn_purchase_create_payment;
    private JButton btn_purchase_complete;
    private JButton btn_purchase_cancel;
    private JPanel buttons_payment;
    private JButton btn_payment_attachments;
    private JButton btn_payment_print;
    private JButton btn_payment_confirm;
    private JButton btn_payment_cancel;
    private JPanel buttons_cancel;
    private JButton btn_cancel_attachments;
    private JButton btn_cancel_print;
    private JButton btn_cancel_confirm;
    private JButton btn_cancel_cancel;
    private JPanel buttons_draft;
    private JButton btn_draft_attachments;
    private JButton btn_draft_print;
    private JButton btn_draft_finish;
    private JButton btn_draft_discard;
    private JPanel panel_12;
    private ETextField txtPartialPrice;

    private EditDocumentDialog() {
        this.initialize();
    }

    public EditDocumentDialog(ClientContext ctx, DocumentFull document) {
        this(ctx, document, null);
    }

    public EditDocumentDialog(ClientContext ctx, DocumentFull document, DocumentFull placeholder) {
        super(DocumentFull.MODEL, ctx, document, placeholder);
        this.ctx = ctx;
        this.setWindowSize(1280, 720);
        this.initialize();
        this.addEditable(this.dtDate);
        this.addEditable(this.dtDueDate);
        this.addEditable(this.cmbServiceType);
        this.addEditable(this.dtServiceDate1);
        this.addEditable(this.dtServiceDate2);
        this.addEditable(this.btnSearchPerson);
        this.addEditable(this.btnSelectAddress);
        this.addEditable(this.cmbSalutation);
        this.addEditable(this.txtPrefix);
        this.addEditable(this.txtLastName);
        this.addEditable(this.txtFirstName);
        this.addEditable(this.txtCompany);
        this.addEditable(this.cmbCountry);
        this.addEditable(this.txtAddress1);
        this.addEditable(this.txtAddress2);
        this.addEditable(this.txtReferenceNumber);
        this.addEditable(this.txtText);
        this.addEditable(this.tblItems);
        this.addEditable(this.tblDeductions);
        this.addEditable(this.txtPartialPrice);
        this.addEditable((Boolean e) -> {
            CardLayout card = (CardLayout)this.panel_items_buttons.getLayout();
            if (e.booleanValue()) {
                if (this.isEnabled(this.tblItems)) {
                    card.show(this.panel_items_buttons, "editing");
                } else {
                    card.show(this.panel_items_buttons, "viewing");
                }
            } else if (this.type != null) {
                if (this.type.isCompletable()) {
                    card.show(this.panel_items_buttons, "viewing_completable");
                } else {
                    card.show(this.panel_items_buttons, "viewing");
                }
            }
        });
        this.addOpenListener(() -> this.splitPane_1.setDividerLocation(0.66));
        this.btnSearchPerson.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            if (this.type.usesCustomer()) {
                new ShowCustomersDialog(true, ctx).inputInnerModal(this, this::setCustomer);
            } else {
                new ShowVendorsDialog(true, ctx).inputInnerModal(this, this::setVendor);
            }
        }));
        this.btnSelectAddress.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            if (this.customer == null && this.vendor == null) {
                throw new RuntimeException("no customer/vendor selected");
            }
            new ChooseAddressDialog(ctx, this.customer, this.vendor).inputInnerModal(this, address -> {
                if (address == null) {
                    return;
                }
                this.cmbSalutation.setSelectedItem((Object)address.getSalutation());
                this.txtPrefix.setText(address.getPrefix());
                this.txtLastName.setText(address.getLastName());
                this.txtFirstName.setText(address.getFirstName());
                this.txtCompany.setText(address.getCompany());
                this.cmbCountry.setSelectedItem(address.getCountry());
                this.txtAddress1.setText(address.getAddress1());
                this.txtAddress2.setText(address.getAddress2());
            });
        }));
        this.cmbSalutation.setRenderer(new FormattedListCellRenderer(type -> type == null ? "-" : ((Salutation)((Object)((Object)((Object)type)))).getLocalizedString(this.BUNDLE)));
        this.cmbSalutation.addItemListener(ev -> {
            boolean enabled = this.cmbSalutation.getSelectedItem() != null;
            this.txtPrefix.setEnabled(enabled);
            this.txtFirstName.setEnabled(enabled);
            this.txtLastName.setEnabled(enabled);
        });
        this.cmbSalutation.addItem(null);
        for (Salutation salutation : Salutation.values()) {
            this.cmbSalutation.addItem(salutation);
        }
        this.cmbSalutation.setSelectedIndex(1);
        this.cmbSalutation.setSelectedIndex(0);
        this.cmbServiceType.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.cmbServiceType.setRenderer(new FormattedListCellRenderer(10, type -> type == null ? "-" : ((DocumentServiceType)((Object)((Object)((Object)type)))).getLocalizedString(this.BUNDLE) + ":"));
        this.cmbServiceType.addItemListener(ev -> {
            DocumentServiceType type = (DocumentServiceType)((Object)((Object)((Object)this.cmbServiceType.getSelectedItem())));
            if (type == null) {
                this.setEnabled(this.dtServiceDate1, false);
                this.setEnabled(this.dtServiceDate2, false);
            } else {
                this.setEnabled(this.dtServiceDate1, true);
                this.setEnabled(this.dtServiceDate2, type == DocumentServiceType.SERVICE_PERIOD);
            }
        });
        this.cmbServiceType.addItem(null);
        for (Enum enum_ : DocumentServiceType.values()) {
            this.cmbServiceType.addItem((DocumentServiceType)enum_);
        }
        this.cmbServiceType.setSelectedIndex(1);
        this.cmbServiceType.setSelectedIndex(0);
        this.cmbCountry.setRenderer(new FormattedListCellRenderer(c -> c == null ? "-" : new Locale("", (String)c).getDisplayCountry()));
        Locale.getISOCountries(Locale.IsoCountryCode.PART1_ALPHA2).stream().sorted(Comparator.comparing(s -> new Locale("", (String)s).getDisplayCountry(), Collator.getInstance())).forEach(c -> this.cmbCountry.addItem((String)c));
        this.tblItems.addColumn(LineItem.COL_STATE, state -> state == null ? "-" : state.getLocalizedString(this.BUNDLE));
        this.tblItems.addColumn(LineItem.COL_ARTICLE_NUMBER);
        this.tblItems.addColumn(LineItem.COL_ARTICLE_TITLE);
        this.tblItems.addColumn(LineItem.COL_TEXT, text -> text.replace('\n', ' '));
        this.tblItems.addColumn(LineItem.COL_AMOUNT);
        this.tblItems.addColumn(LineItem.COL_UNIT);
        this.tblItems.addColumn(LineItem.COL_PRICE);
        this.tblItems.addColumn(LineItem.COL_DISCOUNT);
        this.tblItems.addColumn(this.BUNDLE.getString("generic.label.price"), BigDecimal.class, e -> e.getTotalPrice());
        ((AbstractTableModel)this.tblItems.getModel()).addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                TotalPrice price = LineItem.computeTotalPrice(EditDocumentDialog.this.taxes, EditDocumentDialog.this.taxation, EditDocumentDialog.this.tblItems.getData());
                EditDocumentDialog.this.txtNetPrice.setText((price.isComplete() ? "" : "*") + I18N.formatDecimal(price.getNetSum()));
                EditDocumentDialog.this.txtTotalPrice.setText((price.isComplete() ? "" : "*") + I18N.formatDecimal(price.getTotalSum()));
            }
        });
        FailableConsumer edit = obj -> {
            if (this.tblItems.isEditable() && obj.getPrevLineItemId() == null) {
                this.getLineItemDialog((LineItem)obj, null, true).inputInnerModal(this, item -> {
                    if (item != null) {
                        ((ETableModel)this.tblItems.getModel()).replaceRow(this.tblItems.getSelectedRow(), item);
                    }
                });
            } else {
                this.getLineItemDialog((LineItem)obj, null, false).openInnerModal(this);
            }
        };
        this.tblItems.addDoubleClickAction(edit);
        this.tblItems.connect(this.btnShow, obj -> obj != null, edit);
        this.tblItems.connect(this.btnShow2, obj -> obj != null, edit);
        this.tblItems.connect(this.btnSplit, obj -> obj != null && obj.getState() == OrderState.ONGOING && obj.getNextLineItemId() == null, obj -> {
            String input_first = JOptionPane.showInputDialog(this, (Object)"input amount");
            if (input_first == null) {
                return;
            }
            BigDecimal first = I18N.parseDecimal(input_first);
            DocumentFull res = EUtils.blocking((Component)this, blocking -> {
                ctx.query(new DocumentSplit(((DocumentFull)this.getObject()).getId(), obj.getId(), first));
                return ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, ((DocumentFull)this.getObject()).getPrimaryFilter()));
            });
            this.objectSaved(res);
        });
        this.tblItems.connect(this.btnMerge, obj -> obj != null && obj.getState() == OrderState.ONGOING && obj.getPrevLineItemId() == null && obj.getNextLineItemId() == null, obj -> {
            List<LineItem> items = this.tblItems.getData().stream().filter(item -> obj.compatibleTo((LineItem)item)).collect(Collectors.toList());
            if (items.size() == 1) {
                throw new RuntimeException("cannot merge; no matching items");
            }
            new ChooseLineItemsDialog(items, true).inputInnerModal(this, selected -> {
                if (selected == null || selected.size() == 1) {
                    return;
                }
                List selected_ids = selected.stream().map(item -> item.getId()).collect(Collectors.toList());
                DocumentFull res = EUtils.blocking((Component)this, blocking -> {
                    ctx.query(new DocumentMerge(((DocumentFull)this.getObject()).getId(), selected_ids));
                    return ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, ((DocumentFull)this.getObject()).getPrimaryFilter()));
                });
                this.objectSaved(res);
            });
        });
        this.tblItems.connect(this.btnAdd, _obj -> this.getLineItemDialog(null, new LineItem(), true).inputInnerModal(this, item -> {
            if (item != null) {
                ((ETableModel)this.tblItems.getModel()).addRow(item);
            }
        }));
        this.tblItems.connect(this.btnEdit, obj -> obj != null, edit);
        this.tblItems.connect(this.btnRemove, obj -> obj != null && obj.getPrevDocumentId() == null, obj -> {
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditDocumentDialog.messages.remove_item_confirm.text1") + "\n\n    " + obj.getDisplayName() + "\n\n" + this.BUNDLE.getString("EditDocumentDialog.messages.remove_item_confirm.text2"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            ((ETableModel)this.tblItems.getModel()).deleteRow(this.tblItems.getSelectedRow());
        });
        this.tblItems.connect(this.btnMoveUp, obj -> obj != null && this.tblItems.getSelectedRow() > 0, _obj -> {
            int idx = this.tblItems.getSelectedRow();
            TableModel model = this.tblItems.getModel();
            LineItem item = (LineItem)((ETableModel)model).getRow(idx);
            ((ETableModel)model).deleteRow(idx);
            ((ETableModel)model).addRow(--idx, item);
            this.tblItems.setRowSelectionInterval(idx, idx);
        });
        this.tblItems.connect(this.btnMoveDown, obj -> obj != null && this.tblItems.getSelectedRow() < this.tblItems.getRowCount() - 1, _obj -> {
            int idx = this.tblItems.getSelectedRow();
            TableModel model = this.tblItems.getModel();
            LineItem item = (LineItem)((ETableModel)model).getRow(idx);
            ((ETableModel)model).deleteRow(idx);
            ((ETableModel)model).addRow(++idx, item);
            this.tblItems.setRowSelectionInterval(idx, idx);
        });
        this.tblDeductions.addColumn(Deduction.COL_TITLE);
        this.tblDeductions.addColumn(Deduction.COL_PRICE);
        ActionListener action_attachments = e -> new ShowAttachmentsDialog(ctx, this.getTitle(), AttachmentObjectType.DOCUMENT, ((DocumentFull)this.getObject()).getId()).openInnerModal(this);
        ActionListener action_print = e -> EUtils.catchWithDialog(this, () -> {
            String filename;
            PDDocument doc;
            boolean debug;
            DocumentFull obj = (DocumentFull)this.getObject();
            JComboBox<Object> cmb = new JComboBox<Object>();
            cmb.addItem(false);
            cmb.addItem(true);
            cmb.setSelectedIndex(0);
            cmb.setRenderer(new FormattedListCellRenderer(headless -> (Boolean)headless != false ? "headless" : "normal"));
            int answer = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
            if (answer != 0) {
                return;
            }
            Boolean headless2 = (Boolean)cmb.getSelectedItem();
            boolean bl = debug = (e.getModifiers() & 2) != 0 && (e.getModifiers() & 8) != 0 && (e.getModifiers() & 1) != 0;
            if (debug || obj.getAttachmentId() == null) {
                doc = EUtils.blocking((Component)this, blocking -> {
                    ClientDocumentRenderer renderer = new ClientDocumentRenderer(this.BUNDLE, ctx);
                    renderer.setDebug(debug);
                    return renderer.renderDocument(obj, headless2);
                });
                filename = "draft.pdf";
            } else {
                Long id = headless2 != false ? obj.getHeadlessAttachmentId() : obj.getAttachmentId();
                Attachment attachment = ctx.query(new Select<Attachment>(Attachment.MODEL, Attachment.COL_ID.with(id)));
                Path tmp = EditAttachmentDialogs.download((Component)this, ctx, attachment);
                try {
                    doc = PDDocument.load(tmp.toFile());
                    filename = attachment.getFilename();
                }
                finally {
                    tmp.toFile().delete();
                }
            }
            PrintDialog dialog = new PrintDialog(filename, doc, obj.getState() != OrderState.DRAFT);
            dialog.openPage(this, () -> {
                if (obj.getState() == OrderState.DRAFT || !dialog.isPrinted()) {
                    return;
                }
                DocumentFull obj2 = EUtils.blocking((Component)this, blocking -> ctx.query(new DocumentPrinted(obj.getId())));
                this.objectSaved(obj2);
            });
        });
        ActionListener actionListener = e -> EUtils.catchWithDialog(this, () -> {
            DocumentFull obj = (DocumentFull)this.getObject();
            boolean cancelable = obj.getItems().stream().allMatch(item -> item.getState() != OrderState.ONGOING || item.getNextLineItemId() == null);
            if (!cancelable) {
                throw new RuntimeException(this.BUNDLE.getString("EditDocumentDialog.messages.cancel_ongoing_used_items"));
            }
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditDocumentDialog.messages.confirm_cancel"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            DocumentFull res = EUtils.blocking((Component)this, blocking -> {
                ctx.query(new DocumentCancel(((DocumentFull)this.getObject()).getId()));
                return ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, ((DocumentFull)this.getObject()).getPrimaryFilter()));
            });
            this.objectSaved(res);
        });
        ActionListener action_complete = e -> EUtils.catchWithDialog(this, () -> {
            DocumentFull obj = (DocumentFull)this.getObject();
            boolean confirmable = obj.getItems().stream().allMatch(item -> item.getState() != OrderState.ONGOING);
            if (!confirmable) {
                throw new RuntimeException(this.BUNDLE.getString("EditDocumentDialog.messages.complete_ongoing_items"));
            }
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditDocumentDialog.messages.confirm_complete"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            DocumentFull res = EUtils.blocking((Component)this, blocking -> {
                ctx.query(new DocumentComplete(((DocumentFull)this.getObject()).getId()));
                return ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, ((DocumentFull)this.getObject()).getPrimaryFilter()));
            });
            this.objectSaved(res);
        });
        ActionListener action_confirm = e -> EUtils.catchWithDialog(this, () -> {
            int answer;
            DocumentFull obj = (DocumentFull)this.getObject();
            if (obj.getRemainingPrice() == null) {
                throw new RuntimeException("already paid");
            }
            if (obj.getPrinted() == 0L && (answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditDocumentDialog.messages.confirm_payment_unprinted"), this.getTitle(), 0, 2)) != 0) {
                return;
            }
            String input = I18N.formatDecimal(obj.getRemainingPrice());
            BigDecimal inputAmount = null;
            while (true) {
                if ((input = JOptionPane.showInputDialog(this, "input paid amount", input)) == null || input.isEmpty()) {
                    return;
                }
                try {
                    inputAmount = I18N.parseDecimal(input).setScale(2, RoundingMode.UNNECESSARY);
                    if (inputAmount.signum() < 0) {
                        EUtils.showErrorDialog((Component)this, "invalid amount");
                        continue;
                    }
                    BigDecimal rem = obj.getRemainingPrice().subtract(inputAmount);
                    if (rem.signum() >= 0) break;
                    EUtils.showErrorDialog((Component)this, "too much");
                }
                catch (Exception ex) {
                    EUtils.showErrorDialog((Component)this, "invalid number");
                }
            }
            BigDecimal amount = inputAmount;
            BigDecimal remaining = obj.getRemainingPrice().subtract(amount);
            int answer2 = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditDocumentDialog.messages.confirm_payment") + "\n\n    " + I18N.formatDecimal(inputAmount) + " -> " + I18N.formatDecimal(remaining), this.getTitle(), 0);
            if (answer2 != 0) {
                return;
            }
            DocumentFull res = EUtils.blocking((Component)this, blocking -> ctx.query(new DocumentPay(obj.getId(), amount)));
            this.objectSaved(res);
        });
        this.addReadOnly(this.btn_draft_attachments);
        this.btn_draft_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_draft_print);
        this.btn_draft_print.addActionListener(action_print);
        this.addReadOnly(this.btn_draft_finish);
        this.btn_draft_finish.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditDocumentDialog.messages.confirm_finish"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            DocumentFull res = EUtils.blocking((Component)this, blocking -> {
                ctx.query(new DocumentFinishDraft(((DocumentFull)this.getObject()).getId()));
                return ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, ((DocumentFull)this.getObject()).getPrimaryFilter()));
            });
            this.objectSaved(res);
        }));
        this.addReadOnly(this.btn_draft_discard);
        this.btn_draft_discard.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditDocumentDialog.messages.confirm_discard"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            EUtils.blocking((Component)this, blocking -> ctx.query(new DocumentCancel(((DocumentFull)this.getObject()).getId())));
            this.close();
        }));
        this.addReadOnly(this.btn_done_attachments);
        this.btn_done_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_done_print);
        this.btn_done_print.addActionListener(action_print);
        this.addReadOnly(this.btn_offer_attachments);
        this.btn_offer_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_offer_print);
        this.btn_offer_print.addActionListener(action_print);
        this.addReadOnly(this.btn_offer_create_confirm);
        this.btn_offer_create_confirm.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            DocumentFull doc2 = DocumentFull.createConfirmFromOffer((DocumentFull)this.getObject());
            this.setDocumentAddress(doc2);
            new EditDocumentDialog(ctx, null, doc2).openPage(this, () -> this.reselect());
        }));
        this.addReadOnly(this.btn_offer_cancel);
        this.btn_offer_cancel.addActionListener(actionListener);
        this.addReadOnly(this.btn_confirm_attachments);
        this.btn_confirm_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_confirm_print);
        this.btn_confirm_print.addActionListener(action_print);
        this.addReadOnly(this.btn_confirm_create_receipt);
        this.btn_confirm_create_receipt.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            DocumentFull doc2 = DocumentFull.createReceiptFromConfirm((DocumentFull)this.getObject());
            this.setDocumentAddress(doc2);
            new ChooseLineItemsDialog(doc2.getItems()).inputInnerModal(this, items -> {
                if (items == null) {
                    return;
                }
                doc2.setItems((List<LineItem>)items);
                new EditDocumentDialog(ctx, null, doc2).openPage(this, () -> this.reselect());
            });
        }));
        this.addReadOnly(this.btn_confirm_create_invoice);
        this.btn_confirm_create_invoice.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            DocumentFull obj = (DocumentFull)this.getObject();
            JComboBox<Object> cmb = new JComboBox<Object>();
            cmb.addItem((Object)DocumentType.INVOICE);
            cmb.addItem((Object)DocumentType.DEPOSITINVOICE);
            cmb.addItem((Object)DocumentType.PARTIALPAYMENTINVOICE);
            cmb.setRenderer(new FormattedListCellRenderer(type -> ((DocumentType)((Object)((Object)((Object)((Object)((Object)type)))))).getLocalizedString(this.BUNDLE)));
            int answer = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
            if (answer != 0) {
                return;
            }
            DocumentType type2 = (DocumentType)((Object)((Object)((Object)((Object)cmb.getSelectedItem()))));
            DocumentFull document2 = switch (type2) {
                case DocumentType.INVOICE -> DocumentFull.createInvoiceFromConfirm(obj);
                case DocumentType.DEPOSITINVOICE -> DocumentFull.createDepositInvoiceFromConfirm(obj);
                case DocumentType.PARTIALPAYMENTINVOICE -> DocumentFull.createPartialInvoiceFromConfirm(obj);
                default -> throw new RuntimeException("unreachable");
            };
            this.setDocumentAddress(document2);
            new ChooseLineItemsDialog(document2.getItems()).inputInnerModal(this, items -> {
                if (items == null) {
                    return;
                }
                document2.setItems((List<LineItem>)items);
                new EditDocumentDialog(ctx, null, document2).openPage(this, () -> this.reselect());
            });
        }));
        this.addReadOnly(this.btn_confirm_cancel);
        this.btn_confirm_cancel.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            DocumentFull obj = (DocumentFull)this.getObject();
            List<LineItem> items = obj.getItems().stream().filter(item -> item.getState() == null && item.getNextLineItemId() == null).collect(Collectors.toList());
            new ChooseLineItemsDialog(items).inputInnerModal(this, cancel -> {
                if (cancel == null || cancel.isEmpty()) {
                    return;
                }
                int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditDocumentDialog.messages.confirm_cancel_items.text1") + "\n\n" + cancel.stream().map(e -> "    " + e.getDisplayName()).collect(Collectors.joining("\n")) + "\n\n" + this.BUNDLE.getString("EditDocumentDialog.messages.confirm_cancel_items.text2"), this.getTitle(), 0);
                if (answer != 0) {
                    return;
                }
                DocumentFull res = EUtils.blocking((Component)this, blocking -> {
                    List<Long> ids = cancel.stream().map(e -> e.getId()).collect(Collectors.toList());
                    ctx.query(new DocumentCancelItems(((DocumentFull)this.getObject()).getId(), ids));
                    return ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, ((DocumentFull)this.getObject()).getPrimaryFilter()));
                });
                this.objectSaved(res);
                boolean completable = res.getItems().stream().allMatch(item -> item.getState() != OrderState.ONGOING);
                if (completable) {
                    answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditDocumentDialog.messages.completable_after_cancel"), this.getTitle(), 0);
                    if (answer != 0) {
                        return;
                    }
                    DocumentFull res2 = EUtils.blocking((Component)this, blocking -> {
                        ctx.query(new DocumentComplete(obj.getId()));
                        return ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, ((DocumentFull)this.getObject()).getPrimaryFilter()));
                    });
                    this.objectSaved(res2);
                }
            });
        }));
        this.addReadOnly(this.btn_receipt_attachments);
        this.btn_receipt_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_receipt_print);
        this.btn_receipt_print.addActionListener(action_print);
        this.addReadOnly(this.btn_receipt_create_invoice);
        this.btn_receipt_create_invoice.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            DocumentFull obj = (DocumentFull)this.getObject();
            if (!this.parents.isEmpty() && this.parents.get(0).getType().isPartialInvoice()) {
                int answer;
                List receipts = EUtils.blocking((Component)this, blocking -> {
                    this.parents.set(0, ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(this.parents.get(0).getId()))));
                    HashSet<Long> successors = new HashSet<Long>();
                    for (LineItem item : this.parents.get(0).getItems()) {
                        if (item.getNextDocumentId() == null) continue;
                        successors.add(item.getNextDocumentId());
                    }
                    ArrayList<DocumentFull> res = new ArrayList<DocumentFull>();
                    for (Long id : successors) {
                        res.add(ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(id))));
                    }
                    res.sort(Comparator.comparing(doc -> doc.getNumber()));
                    return res;
                });
                DocumentFull draft = receipts.stream().filter(r -> r.getState() == OrderState.DRAFT).findAny().orElse(null);
                if (draft != null) {
                    throw new RuntimeException("document comes from\n\n    " + this.parents.get(0).getType().getLocalizedString(this.BUNDLE) + " " + this.parents.get(0).getNumber() + "\n\ntherefore, the following receipts must be used:\n\n" + receipts.stream().map(receipt -> "    " + receipt.getType().getLocalizedString(this.BUNDLE) + " " + receipt.getNumber()).collect(Collectors.joining("\n")) + "\n\nhowever, the following document is still a draft:\n\n    " + draft.getType().getLocalizedString(this.BUNDLE) + " " + draft.getNumber());
                }
                List remaining = this.parents.get(0).getItems().stream().filter(item -> item.getNextLineItemId() == null).collect(Collectors.toList());
                if (remaining.isEmpty() ? (answer = JOptionPane.showConfirmDialog(this, "document comes from\n\n    " + this.parents.get(0).getType().getLocalizedString(this.BUNDLE) + " " + this.parents.get(0).getNumber() + "\n\ntherefore, the following receipts will be used:\n\n" + receipts.stream().map(receipt -> "    " + receipt.getType().getLocalizedString(this.BUNDLE) + " " + receipt.getNumber()).collect(Collectors.joining("\n")) + "\n\nconfirm?", this.getTitle(), 0)) != 0 : (answer = JOptionPane.showConfirmDialog(this, "document comes from\n\n    " + this.parents.get(0).getType().getLocalizedString(this.BUNDLE) + " " + this.parents.get(0).getNumber() + "\n\ntherefore, the following receipts will be used:\n\n" + receipts.stream().map(receipt -> "    " + receipt.getType().getLocalizedString(this.BUNDLE) + " " + receipt.getNumber()).collect(Collectors.joining("\n")) + "\n\nremaining items:\n\n" + remaining.stream().map(item -> "    " + item.getDisplayName()).collect(Collectors.joining("\n")) + "\n\nconfirm?", this.getTitle(), 0)) != 0) {
                    return;
                }
                JComboBox<Object> cmb = new JComboBox<Object>();
                cmb.addItem((Object)DocumentType.FINALPAYMENTINVOICE);
                cmb.addItem((Object)DocumentType.PARTIALPAYMENTINVOICE);
                cmb.setRenderer(new FormattedListCellRenderer(type -> ((DocumentType)((Object)((Object)((Object)((Object)((Object)type)))))).getLocalizedString(this.BUNDLE)));
                int answer2 = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
                if (answer2 != 0) {
                    return;
                }
                DocumentType type2 = (DocumentType)((Object)((Object)((Object)((Object)cmb.getSelectedItem()))));
                DocumentFull res = switch (type2) {
                    case DocumentType.FINALPAYMENTINVOICE -> DocumentFull.createFinalInvoiceFromReceipts(this.BUNDLE, this.parents.get(0), receipts);
                    case DocumentType.PARTIALPAYMENTINVOICE -> DocumentFull.createPartialInvoiceFromReceipts(this.BUNDLE, this.parents.get(0), receipts);
                    default -> throw new RuntimeException("unreachable");
                };
                this.setDocumentAddress(res);
                new EditDocumentDialog(ctx, null, res).openPage(this, () -> this.reselect());
            } else {
                List chain = EUtils.blocking((Component)this, blocking -> (List)((Object)ctx.query(new SelectAll<OrderDocumentView>(OrderDocumentView.MODEL, OrderDocumentView.COL_ORDER_ID.with(obj.getOrders().get(0))))));
                List<OrderDocumentView> receipts = chain.stream().filter(o -> o.getType() == DocumentType.RECEIPT && o.getState() == OrderState.ONGOING).collect(Collectors.toList());
                new ChooseDocumentsDialog(receipts, obj.getId()).inputInnerModal(this, selected -> {
                    if (selected == null) {
                        return;
                    }
                    List selected_receipts = EUtils.blocking((Component)this, blocking -> {
                        ArrayList<DocumentFull> res = new ArrayList<DocumentFull>();
                        for (OrderDocumentView next : selected) {
                            res.add(ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(next.getId()))));
                        }
                        return res;
                    });
                    JComboBox<Object> cmb = new JComboBox<Object>();
                    cmb.addItem((Object)DocumentType.INVOICE);
                    cmb.addItem((Object)DocumentType.PARTIALPAYMENTINVOICE);
                    cmb.setRenderer(new FormattedListCellRenderer(type -> ((DocumentType)((Object)((Object)((Object)((Object)((Object)((Object)type))))))).getLocalizedString(this.BUNDLE)));
                    int answer = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
                    if (answer != 0) {
                        return;
                    }
                    DocumentType type2 = (DocumentType)((Object)((Object)((Object)((Object)((Object)cmb.getSelectedItem())))));
                    DocumentFull res = switch (type2) {
                        case DocumentType.INVOICE -> DocumentFull.createInvoiceFromReceipts(selected_receipts);
                        case DocumentType.PARTIALPAYMENTINVOICE -> DocumentFull.createPartialInvoiceFromReceipts(this.BUNDLE, null, selected_receipts);
                        default -> throw new RuntimeException("unreachable");
                    };
                    this.setDocumentAddress(res);
                    new EditDocumentDialog(ctx, null, res).openPage(this, () -> this.reselect());
                });
            }
        }));
        this.addReadOnly(this.btn_receipt_cancel);
        this.btn_receipt_cancel.addActionListener(actionListener);
        this.addReadOnly(this.btn_invoice_attachments);
        this.btn_invoice_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_invoice_print);
        this.btn_invoice_print.addActionListener(action_print);
        this.addReadOnly(this.btn_invoice_confirm);
        this.btn_invoice_confirm.addActionListener(action_confirm);
        this.addReadOnly(this.btn_invoice_cancel);
        this.btn_invoice_cancel.addActionListener(actionListener);
        this.addReadOnly(this.btn_deposit_invoice_attachments);
        this.btn_deposit_invoice_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_deposit_invoice_print);
        this.btn_deposit_invoice_print.addActionListener(action_print);
        this.addReadOnly(this.btn_deposit_invoice_confirm);
        this.btn_deposit_invoice_confirm.addActionListener(action_confirm);
        this.addReadOnly(this.btn_deposit_invoice_cancel);
        this.btn_deposit_invoice_cancel.addActionListener(actionListener);
        this.addReadOnly(this.btn_deposit_invoice_create_receipt);
        this.btn_deposit_invoice_create_receipt.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            DocumentFull doc2 = DocumentFull.createReceiptFromDepositInvoice((DocumentFull)this.getObject());
            if (doc2.getItems().isEmpty()) {
                throw new RuntimeException("no items left");
            }
            this.setDocumentAddress(doc2);
            new ChooseLineItemsDialog(doc2.getItems()).inputInnerModal(this, items -> {
                if (items == null) {
                    return;
                }
                doc2.setItems((List<LineItem>)items);
                new EditDocumentDialog(ctx, null, doc2).openPage(this, () -> this.reselect());
            });
        }));
        this.addReadOnly(this.btn_deposit_invoice_create_next_invoice);
        this.btn_deposit_invoice_create_next_invoice.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            DocumentFull obj = (DocumentFull)this.getObject();
            if (obj.getItems().stream().anyMatch(item -> item.getNextLineItemId() != null)) {
                int answer;
                List receipts = EUtils.blocking((Component)this, blocking -> {
                    HashSet<Long> successors = new HashSet<Long>();
                    for (LineItem item : obj.getItems()) {
                        if (item.getNextDocumentId() == null) continue;
                        successors.add(item.getNextDocumentId());
                    }
                    ArrayList<DocumentFull> res = new ArrayList<DocumentFull>();
                    for (Long id : successors) {
                        res.add(ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(id))));
                    }
                    res.sort(Comparator.comparing(doc -> doc.getNumber()));
                    return res;
                });
                boolean nextInvoiceExists = receipts.stream().anyMatch(r -> r.getType() != DocumentType.RECEIPT || r.getState() == OrderState.COMPLETED);
                if (nextInvoiceExists) {
                    throw new RuntimeException("next invoice already exists");
                }
                DocumentFull draft = receipts.stream().filter(r -> r.getState() == OrderState.DRAFT).findAny().orElse(null);
                if (draft != null) {
                    throw new RuntimeException("document comes from\n\n    " + this.parents.get(0).getType().getLocalizedString(this.BUNDLE) + " " + this.parents.get(0).getNumber() + "\n\ntherefore, the following receipts must be used:\n\n" + receipts.stream().map(receipt -> "    " + receipt.getType().getLocalizedString(this.BUNDLE) + " " + receipt.getNumber()).collect(Collectors.joining("\n")) + "\n\nhowever, the following document is still a draft:\n\n    " + draft.getType().getLocalizedString(this.BUNDLE) + " " + draft.getNumber());
                }
                List remaining = obj.getItems().stream().filter(item -> item.getNextLineItemId() == null).collect(Collectors.toList());
                if (remaining.isEmpty() ? (answer = JOptionPane.showConfirmDialog(this, "all items are used by these receipts:\n\n" + receipts.stream().map(receipt -> "    " + receipt.getType().getLocalizedString(this.BUNDLE) + " " + receipt.getNumber()).collect(Collectors.joining("\n")) + "\n\nconfirm?", this.getTitle(), 0)) != 0 : (answer = JOptionPane.showConfirmDialog(this, "some items are used by these receipts:\n\n" + receipts.stream().map(receipt -> "    " + receipt.getType().getLocalizedString(this.BUNDLE) + " " + receipt.getNumber()).collect(Collectors.joining("\n")) + "\n\nremaining items:\n\n" + remaining.stream().map(item -> "    " + item.getDisplayName()).collect(Collectors.joining("\n")) + "\n\nconfirm?", this.getTitle(), 0)) != 0) {
                    return;
                }
                JComboBox<Object> cmb = new JComboBox<Object>();
                cmb.addItem((Object)DocumentType.FINALPAYMENTINVOICE);
                cmb.addItem((Object)DocumentType.PARTIALPAYMENTINVOICE);
                cmb.setRenderer(new FormattedListCellRenderer(type -> ((DocumentType)((Object)((Object)((Object)((Object)((Object)type)))))).getLocalizedString(this.BUNDLE)));
                int answer2 = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
                if (answer2 != 0) {
                    return;
                }
                DocumentType type2 = (DocumentType)((Object)((Object)((Object)((Object)cmb.getSelectedItem()))));
                DocumentFull res = switch (type2) {
                    case DocumentType.FINALPAYMENTINVOICE -> DocumentFull.createFinalInvoiceFromReceipts(this.BUNDLE, obj, receipts);
                    case DocumentType.PARTIALPAYMENTINVOICE -> DocumentFull.createPartialInvoiceFromReceipts(this.BUNDLE, obj, receipts);
                    default -> throw new RuntimeException("unreachable");
                };
                this.setDocumentAddress(res);
                new EditDocumentDialog(ctx, null, res).openPage(this, () -> this.reselect());
            } else {
                JComboBox<Object> cmb = new JComboBox<Object>();
                cmb.addItem((Object)DocumentType.FINALPAYMENTINVOICE);
                cmb.addItem((Object)DocumentType.PARTIALPAYMENTINVOICE);
                cmb.setRenderer(new FormattedListCellRenderer(type -> ((DocumentType)((Object)((Object)((Object)((Object)((Object)type)))))).getLocalizedString(this.BUNDLE)));
                int answer = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
                if (answer != 0) {
                    return;
                }
                DocumentType type3 = (DocumentType)((Object)((Object)((Object)((Object)cmb.getSelectedItem()))));
                DocumentFull document2 = switch (type3) {
                    case DocumentType.FINALPAYMENTINVOICE -> DocumentFull.createFinalInvoiceFromPartialInvoice(this.BUNDLE, obj);
                    case DocumentType.PARTIALPAYMENTINVOICE -> DocumentFull.createPartialInvoiceFromPartialInvoice(this.BUNDLE, obj);
                    default -> throw new RuntimeException("unreachable");
                };
                this.setDocumentAddress(document2);
                new EditDocumentDialog(ctx, null, document2).openPage(this, () -> this.reselect());
            }
        }));
        this.addReadOnly(this.btn_partial_invoice_attachments);
        this.btn_partial_invoice_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_partial_invoice_print);
        this.btn_partial_invoice_print.addActionListener(action_print);
        this.addReadOnly(this.btn_partial_invoice_confirm);
        this.btn_partial_invoice_confirm.addActionListener(action_confirm);
        this.addReadOnly(this.btn_partial_invoice_cancel);
        this.btn_partial_invoice_cancel.addActionListener(actionListener);
        this.addReadOnly(this.btn_partial_invoice_create_next_invoice);
        this.btn_partial_invoice_create_next_invoice.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            DocumentFull obj = (DocumentFull)this.getObject();
            if (obj.getItems().stream().anyMatch(item -> item.getNextLineItemId() != null)) {
                throw new RuntimeException("next invoice already exists");
            }
            JComboBox<Object> cmb = new JComboBox<Object>();
            cmb.addItem((Object)DocumentType.FINALPAYMENTINVOICE);
            cmb.addItem((Object)DocumentType.PARTIALPAYMENTINVOICE);
            cmb.setRenderer(new FormattedListCellRenderer(type -> ((DocumentType)((Object)((Object)((Object)((Object)((Object)type)))))).getLocalizedString(this.BUNDLE)));
            int answer = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
            if (answer != 0) {
                return;
            }
            DocumentType type2 = (DocumentType)((Object)((Object)((Object)((Object)cmb.getSelectedItem()))));
            DocumentFull document2 = switch (type2) {
                case DocumentType.FINALPAYMENTINVOICE -> DocumentFull.createFinalInvoiceFromPartialInvoice(this.BUNDLE, obj);
                case DocumentType.PARTIALPAYMENTINVOICE -> DocumentFull.createPartialInvoiceFromPartialInvoice(this.BUNDLE, obj);
                default -> throw new RuntimeException("unreachable");
            };
            this.setDocumentAddress(document2);
            new EditDocumentDialog(ctx, null, document2).openPage(this, () -> this.reselect());
        }));
        this.addReadOnly(this.btn_invoice_completed_attachments);
        this.btn_invoice_completed_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_invoice_completed_print);
        this.btn_invoice_completed_print.addActionListener(action_print);
        this.addReadOnly(this.btn_invoice_completed_create_cancelinvoice);
        this.btn_invoice_completed_create_cancelinvoice.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            DocumentFull doc2 = DocumentFull.createCancelInvoiceFromInvoice((DocumentFull)this.getObject());
            if (doc2.getItems().isEmpty()) {
                throw new RuntimeException("no items left");
            }
            this.setDocumentAddress(doc2);
            new ChooseLineItemsDialog(doc2.getItems()).inputInnerModal(this, items -> {
                if (items == null) {
                    return;
                }
                doc2.setItems((List<LineItem>)items);
                new EditDocumentDialog(ctx, null, doc2).openPage(this, () -> this.reselect());
            });
        }));
        this.addReadOnly(this.btn_request_attachments);
        this.btn_request_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_request_print);
        this.btn_request_print.addActionListener(action_print);
        this.addReadOnly(this.btn_request_create_purchase);
        this.btn_request_create_purchase.addActionListener(e -> {
            DocumentFull doc2 = DocumentFull.createPurchaseFromRequest((DocumentFull)this.getObject());
            this.setDocumentAddress(doc2);
            new EditDocumentDialog(ctx, null, doc2).openPage(this, () -> this.reselect());
        });
        this.addReadOnly(this.btn_request_cancel);
        this.btn_request_cancel.addActionListener(actionListener);
        this.addReadOnly(this.btn_purchase_attachments);
        this.btn_purchase_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_purchase_print);
        this.btn_purchase_print.addActionListener(action_print);
        this.addReadOnly(this.btn_purchase_create_payment);
        this.btn_purchase_create_payment.addActionListener(e -> {
            DocumentFull doc2 = DocumentFull.createPaymentFromPurchase((DocumentFull)this.getObject());
            this.setDocumentAddress(doc2);
            new ChooseLineItemsDialog(doc2.getItems()).inputInnerModal(this, items -> {
                if (items == null) {
                    return;
                }
                doc2.setItems((List<LineItem>)items);
                new EditDocumentDialog(ctx, null, doc2).openPage(this, () -> this.reselect());
            });
        });
        this.addReadOnly(this.btn_purchase_complete);
        this.btn_purchase_complete.addActionListener(action_complete);
        this.addReadOnly(this.btn_purchase_cancel);
        this.btn_purchase_cancel.addActionListener(e -> {
            DocumentFull doc2 = DocumentFull.createCancelFromPurchase((DocumentFull)this.getObject());
            this.setDocumentAddress(doc2);
            List<LineItem> items = doc2.getItems().stream().filter(item -> item.getState() == OrderState.ONGOING).collect(Collectors.toList());
            new ChooseLineItemsDialog(items).inputInnerModal(this, cancel -> {
                if (cancel == null) {
                    return;
                }
                doc2.setItems(items);
                new EditDocumentDialog(ctx, null, doc2).openPage(this, () -> this.reselect());
            });
        });
        this.addReadOnly(this.btn_payment_attachments);
        this.btn_payment_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_payment_print);
        this.btn_payment_print.addActionListener(action_print);
        this.addReadOnly(this.btn_payment_confirm);
        this.btn_payment_confirm.addActionListener(action_confirm);
        this.addReadOnly(this.btn_payment_cancel);
        this.btn_payment_cancel.addActionListener(actionListener);
        this.addReadOnly(this.btn_cancel_attachments);
        this.btn_cancel_attachments.addActionListener(action_attachments);
        this.addReadOnly(this.btn_cancel_print);
        this.btn_cancel_print.addActionListener(action_print);
        this.addReadOnly(this.btn_cancel_confirm);
        this.btn_cancel_confirm.addActionListener(action_confirm);
        this.addReadOnly(this.btn_cancel_cancel);
        this.btn_cancel_cancel.addActionListener(actionListener);
    }

    private void setDocumentAddress(DocumentFull doc) {
        if (doc.getType() == DocumentType.RECEIPT) {
            if (this.orders.size() == 1) {
                Order order = this.orders.get(0);
                doc.setSalutation(order.getShippingSalutation());
                doc.setPrefix(order.getShippingPrefix());
                doc.setFirstName(order.getShippingFirstName());
                doc.setLastName(order.getShippingLastName());
                doc.setCompany(order.getShippingCompany());
                doc.setCountry(order.getShippingCountry());
                doc.setAddress1(order.getShippingAddress1());
                doc.setAddress2(order.getShippingAddress2());
            }
        } else if (this.orders.size() == 1) {
            Order order = this.orders.get(0);
            doc.setSalutation(order.getSalutation());
            doc.setPrefix(order.getPrefix());
            doc.setFirstName(order.getFirstName());
            doc.setLastName(order.getLastName());
            doc.setCompany(order.getCompany());
            doc.setCountry(order.getCountry());
            doc.setAddress1(order.getAddress1());
            doc.setAddress2(order.getAddress2());
        }
    }

    private void setCustomer(Customer obj) throws Exception {
        if (obj == null) {
            return;
        }
        this.customer = obj;
        this.txtPersonId.setText(obj.getNumber());
        Address address = EUtils.blocking((Component)this, blocking -> this.ctx.query(new Select<Address>(Address.MODEL, new And(Address.COL_CUSTOMER_ID.with(obj.getId()), Address.COL_DEFAULT_ADDRESS.with(true)))));
        if (address != null) {
            this.cmbSalutation.setSelectedItem((Object)address.getSalutation());
            this.txtPrefix.setText(address.getPrefix());
            this.txtLastName.setText(address.getLastName());
            this.txtFirstName.setText(address.getFirstName());
            this.txtCompany.setText(address.getCompany());
            this.cmbCountry.setSelectedItem(address.getCountry());
            this.txtAddress1.setText(address.getAddress1());
            this.txtAddress2.setText(address.getAddress2());
        } else {
            this.cmbSalutation.setSelectedItem((Object)obj.getSalutation());
            this.txtPrefix.setText(obj.getPrefix());
            this.txtLastName.setText(obj.getLastName());
            this.txtFirstName.setText(obj.getFirstName());
            this.txtCompany.setText(obj.getCompany());
            this.txtAddress1.setText("");
            this.txtAddress2.setText("");
        }
    }

    private void setVendor(Vendor obj) throws Exception {
        if (obj == null) {
            return;
        }
        this.vendor = obj;
        this.txtPersonId.setText(obj.getNumber());
        Address address = EUtils.blocking((Component)this, blocking -> this.ctx.query(new Select<Address>(Address.MODEL, new And(Address.COL_VENDOR_ID.with(obj.getId()), Address.COL_DEFAULT_ADDRESS.with(true)))));
        if (address != null) {
            this.cmbSalutation.setSelectedItem((Object)address.getSalutation());
            this.txtPrefix.setText(address.getPrefix());
            this.txtLastName.setText(address.getLastName());
            this.txtFirstName.setText(address.getFirstName());
            this.txtCompany.setText(address.getCompany());
            this.cmbCountry.setSelectedItem(address.getCountry());
            this.txtAddress1.setText(address.getAddress1());
            this.txtAddress2.setText(address.getAddress2());
        } else {
            this.cmbSalutation.setSelectedItem((Object)obj.getSalutation());
            this.txtPrefix.setText(obj.getPrefix());
            this.txtLastName.setText(obj.getLastName());
            this.txtFirstName.setText(obj.getFirstName());
            this.txtCompany.setText(obj.getCompany());
            this.txtAddress1.setText("");
            this.txtAddress2.setText("");
        }
    }

    private EditDialog<LineItem> getLineItemDialog(LineItem obj, LineItem placeholder, boolean editable) {
        if (this.type.usesCustomer()) {
            return new EditLineItemDialog(this.ctx, this.customer, obj, placeholder, editable);
        }
        return new EditLineItemDialog2(this.ctx, this.vendor, obj, placeholder, editable);
    }

    private void reselect() throws Exception {
        DocumentFull obj = EUtils.blocking((Component)this, blocking -> this.ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, ((DocumentFull)this.getObject()).getPrimaryFilter())));
        this.objectSaved(obj);
    }

    @Override
    protected void displayObject(DocumentFull obj) throws Exception {
        EUtils.blocking((Component)this, blocking -> {
            this.taxes = (List)((Object)this.ctx.query(new SelectAll<TaxRate>(TaxRate.MODEL)));
            this.customer = null;
            if (obj.getCustomerId() != null) {
                this.customer = this.ctx.query(new Select<Customer>(Customer.MODEL, Customer.COL_ID.with(obj.getCustomerId())));
            }
            this.vendor = null;
            if (obj.getVendorId() != null) {
                this.vendor = this.ctx.query(new Select<Vendor>(Vendor.MODEL, Vendor.COL_ID.with(obj.getVendorId())));
            }
            this.orders = new ArrayList<Order>();
            for (Long id : obj.getOrders()) {
                this.orders.add(this.ctx.query(new Select<Order>(Order.MODEL, Order.COL_ID.with(id))));
            }
            this.parents = new ArrayList<DocumentFull>();
            for (Long id : obj.getParents()) {
                this.parents.add(this.ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(id))));
            }
        });
        this.type = obj.getType();
        this.taxation = obj.getTaxation();
        if (obj.getId() == null) {
            this.setTitle(this.type.getLocalizedString(this.BUNDLE) + " " + this.BUNDLE.getString("generic.title.new"));
            this.txtNumber.setText(this.BUNDLE.getString("generic.text.generated"));
        } else {
            String title = this.type.getLocalizedString(this.BUNDLE) + " " + obj.getNumber();
            if (obj.getState() != OrderState.ONGOING) {
                title = title + " [" + obj.getState().getLocalizedString(this.BUNDLE) + "]";
            }
            if (obj.getState() != OrderState.DRAFT && obj.getPrinted() == 0L) {
                title = title + " [" + this.BUNDLE.getString("EditDocumentDialog.title.not_printed") + "]";
            }
            if (obj.getRemainingPrice() != null) {
                title = title + " [" + I18N.formatDecimal(obj.getRemainingPrice()) + " " + this.BUNDLE.getString("EditDocumentDialog.title.remaining") + "]";
            }
            this.setTitle(title);
            this.txtNumber.setText(obj.getNumber());
        }
        this.txtType.setText(this.type.getLocalizedString(this.BUNDLE));
        this.dtDate.setDate(obj.getDate());
        this.dtDueDate.setDate(obj.getDueDate());
        this.cmbServiceType.setSelectedItem((Object)obj.getServiceType());
        this.dtServiceDate1.setDate(obj.getServiceDate1());
        this.dtServiceDate2.setDate(obj.getServiceDate2());
        if (this.type.usesVendor()) {
            this.lblPersonId.setText(this.BUNDLE.getString("Order.VENDOR_ID") + ":");
        }
        this.txtPersonId.setText("-");
        if (this.customer != null) {
            this.txtPersonId.setText(this.customer.getNumber());
        }
        if (this.vendor != null) {
            this.txtPersonId.setText(this.vendor.getNumber());
        }
        this.cmbSalutation.setSelectedItem((Object)obj.getSalutation());
        this.txtPrefix.setText(obj.getPrefix());
        this.txtLastName.setText(obj.getLastName());
        this.txtFirstName.setText(obj.getFirstName());
        this.txtCompany.setText(obj.getCompany());
        this.cmbCountry.setSelectedItem(obj.getCountry());
        this.txtAddress1.setText(obj.getAddress1());
        this.txtAddress2.setText(obj.getAddress2());
        this.txtReferenceNumber.setText(obj.getReferenceNumber());
        this.txtText.setText(obj.getText());
        this.tblItems.setData(obj.getItems());
        this.tblDeductions.setData(obj.getDeductions());
        this.setEnabled(this.tblItems, true);
        if (!this.parents.isEmpty() && this.parents.get(0).getType().isPartialInvoice()) {
            this.setEnabled(this.tblItems, false);
        }
        if (this.type.isPartialInvoice()) {
            this.setEnabled(this.txtPartialPrice, true);
            this.txtPartialPrice.setText(obj.getPartialPrice() == null ? "" : I18N.formatDecimal(obj.getPartialPrice()));
        } else {
            this.setEnabled(this.txtPartialPrice, false);
            this.txtPartialPrice.setText("-");
        }
        if (!this.ctx.getPermissions().contains(Document.MODEL.getName() + ".update")) {
            this.setEditable(false);
        } else {
            this.setEditable(obj.getId() == null || obj.getState() == OrderState.DRAFT);
        }
        CardLayout card = (CardLayout)this.bottomPanel.getLayout();
        block0 : switch (obj.getState()) {
            case DRAFT: {
                card.show(this.bottomPanel, OrderState.DRAFT.toString());
                break;
            }
            case ONGOING: {
                switch (obj.getType()) {
                    case OFFER: {
                        card.show(this.bottomPanel, "offer");
                        break block0;
                    }
                    case CONFIRM: {
                        card.show(this.bottomPanel, "confirm");
                        break block0;
                    }
                    case RECEIPT: {
                        card.show(this.bottomPanel, "receipt");
                        break block0;
                    }
                    case INVOICE: 
                    case FINALPAYMENTINVOICE: 
                    case CANCELINVOICE: {
                        card.show(this.bottomPanel, "invoice");
                        break block0;
                    }
                    case DEPOSITINVOICE: {
                        card.show(this.bottomPanel, "deposit_invoice");
                        break block0;
                    }
                    case PARTIALPAYMENTINVOICE: {
                        card.show(this.bottomPanel, "partial_invoice");
                        break block0;
                    }
                    case REQUEST: {
                        card.show(this.bottomPanel, "request");
                        break block0;
                    }
                    case PURCHASE: {
                        card.show(this.bottomPanel, "purchase");
                        break block0;
                    }
                    case PAYMENT: {
                        card.show(this.bottomPanel, "payment");
                        break block0;
                    }
                    case CANCEL: {
                        card.show(this.bottomPanel, "cancel");
                        break block0;
                    }
                }
                break;
            }
            case COMPLETED: {
                switch (obj.getType()) {
                    case INVOICE: 
                    case FINALPAYMENTINVOICE: 
                    case DEPOSITINVOICE: 
                    case PARTIALPAYMENTINVOICE: {
                        card.show(this.bottomPanel, "invoice.completed");
                        break block0;
                    }
                }
                card.show(this.bottomPanel, "done");
                break;
            }
            case CANCELED: {
                card.show(this.bottomPanel, "done");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected DocumentFull parseObject(DocumentFull old) throws Exception {
        obj = new DocumentFull(old);
        obj.setDate(this.dtDate.getDate());
        obj.setDueDate(this.dtDueDate.getDate());
        obj.setServiceType((DocumentServiceType)this.cmbServiceType.getSelectedItem());
        if (obj.getServiceType() == null) {
            obj.setServiceDate1(this.dtServiceDate1.getDate());
            obj.setServiceDate2(this.dtServiceDate2.getDate());
        } else {
            obj.setServiceDate1(this.dtServiceDate1.getDate());
            obj.setServiceDate2(obj.getServiceType() == DocumentServiceType.SERVICE_PERIOD ? this.dtServiceDate2.getDate() : null);
        }
        if (this.customer != null) {
            obj.setCustomerId(this.customer.getId());
        }
        if (this.vendor != null) {
            obj.setVendorId(this.vendor.getId());
        }
        obj.setSalutation((Salutation)this.cmbSalutation.getSelectedItem());
        if (obj.getSalutation() == null) {
            obj.setPrefix("");
            obj.setFirstName("");
            obj.setLastName("");
        } else {
            obj.setPrefix(this.txtPrefix.getText().trim());
            obj.setFirstName(this.txtFirstName.getText().trim());
            obj.setLastName(this.txtLastName.getText().trim());
        }
        obj.setCompany(this.txtCompany.getText().trim());
        obj.setCountry((String)this.cmbCountry.getSelectedItem());
        obj.setAddress1(this.txtAddress1.getText().trim());
        obj.setAddress2(this.txtAddress2.getText().trim());
        obj.setReferenceNumber(this.txtReferenceNumber.getText().trim());
        obj.setText(this.txtText.getText());
        if (this.type.isPartialInvoice()) {
            try {
                price_str = this.txtPartialPrice.getText().trim();
                if (price_str.isEmpty()) ** GOTO lbl40
                price = I18N.parseDecimal(price_str);
                obj.setPartialPrice(price.setScale(2, RoundingMode.UNNECESSARY));
            }
            catch (ArithmeticException | ParseException e) {
                throw new RuntimeException(this.BUNDLE.getString("generic.messages.invalid_price"), e);
            }
        } else {
            obj.setPartialPrice(null);
        }
lbl40:
        // 3 sources

        row = 0L;
        for (LineItem item : this.tblItems.getData()) {
            item.setRow(row++);
        }
        obj.setItems(new ArrayList<LineItem>(this.tblItems.getData()));
        row = 0L;
        for (Deduction deduction : this.tblDeductions.getData()) {
            deduction.setRow(row++);
        }
        obj.setDeductions(new ArrayList<Deduction>(this.tblDeductions.getData()));
        price = obj.computeTotalPrice(this.taxes);
        obj.setTotalPrice(price.getTotalSum());
        obj.validate();
        return obj;
    }

    private void initialize() {
        this.rootPanel.setLayout(new BorderLayout(0, 0));
        this.splitPane = new JSplitPane();
        this.rootPanel.add((Component)this.splitPane, "Center");
        this.panel = new JPanel();
        this.splitPane.setLeftComponent(this.panel);
        this.panel.setLayout(new MigLayout("", "[grow][grow]", "[][][][][][][][20px][20px][][][][][][][][20px][][grow]"));
        this.lblType = new JLabel(this.BUNDLE.getString("Document.TYPE") + ":");
        this.panel.add((Component)this.lblType, "cell 0 0,alignx trailing");
        this.txtType = new ETextField();
        this.txtType.setEditable(false);
        this.panel.add((Component)this.txtType, "cell 1 0,growx");
        this.txtType.setColumns(10);
        this.lblNumber = new JLabel(this.BUNDLE.getString("Document.NUMBER") + ":");
        this.panel.add((Component)this.lblNumber, "cell 0 1,alignx trailing");
        this.txtNumber = new ETextField();
        this.txtNumber.setEditable(false);
        this.panel.add((Component)this.txtNumber, "cell 1 1,growx");
        this.txtNumber.setColumns(10);
        this.lblDate = new JLabel(this.BUNDLE.getString("Document.DATE") + ":");
        this.panel.add((Component)this.lblDate, "cell 0 2,alignx trailing");
        this.dtDate = new DatePicker();
        this.panel.add((Component)this.dtDate, "cell 1 2,growx");
        this.cmbServiceType = new JComboBox();
        this.panel.add(this.cmbServiceType, "cell 0 4,growx");
        this.dtServiceDate1 = new DatePicker();
        this.panel.add((Component)this.dtServiceDate1, "flowx,cell 1 4,growx");
        this.dtServiceDate2 = new DatePicker();
        this.panel.add((Component)this.dtServiceDate2, "cell 1 5,growx");
        this.lblDueDate = new JLabel(this.BUNDLE.getString("Document.DUE_DATE") + ":");
        this.panel.add((Component)this.lblDueDate, "cell 0 3,alignx trailing");
        this.dtDueDate = new DatePicker();
        this.panel.add((Component)this.dtDueDate, "cell 1 3,growx");
        this.lblPersonId = new JLabel(this.BUNDLE.getString("Document.CUSTOMER_ID") + ":");
        this.panel.add((Component)this.lblPersonId, "cell 0 6,alignx trailing,aligny center");
        this.panel_1 = new JPanel();
        this.panel.add((Component)this.panel_1, "cell 1 6,growx");
        this.panel_1.setLayout(new MigLayout("", "0[grow][]0", "0[]0"));
        this.txtPersonId = new ETextField();
        this.txtPersonId.setEditable(false);
        this.panel_1.add((Component)this.txtPersonId, "flowx,cell 0 0,growx,aligny center");
        this.txtPersonId.setColumns(10);
        this.btnSearchPerson = new JButton(this.BUNDLE.getString("generic.button.search"));
        this.panel_1.add((Component)this.btnSearchPerson, "cell 1 0");
        this.panel_2 = new JPanel();
        this.panel.add((Component)this.panel_2, "cell 0 8 2 1,grow");
        this.panel_2.setLayout(new BorderLayout(0, 0));
        this.lblAddress = new JLabel(this.BUNDLE.getString("Address") + ":");
        this.lblAddress.setFont(new Font("Dialog", 1, 12));
        this.panel_2.add((Component)this.lblAddress, "Center");
        this.btnSelectAddress = new JButton(this.BUNDLE.getString("generic.button.select"));
        this.panel_2.add((Component)this.btnSelectAddress, "East");
        this.lblSalutation = new JLabel(this.BUNDLE.getString("Document.SALUTATION") + ":");
        this.panel.add((Component)this.lblSalutation, "cell 0 10,alignx trailing");
        this.panel_3 = new JPanel();
        this.panel.add((Component)this.panel_3, "flowx,cell 1 10,grow");
        this.panel_3.setLayout(new BorderLayout(0, 0));
        this.cmbSalutation = new JComboBox();
        this.panel_3.add(this.cmbSalutation, "West");
        this.txtPrefix = new ETextField();
        this.panel_3.add(this.txtPrefix);
        this.txtPrefix.setColumns(10);
        this.lblFirstName = new JLabel(this.BUNDLE.getString("Document.FIRST_NAME") + ":");
        this.panel.add((Component)this.lblFirstName, "cell 0 11,alignx trailing");
        this.txtFirstName = new ETextField();
        this.panel.add((Component)this.txtFirstName, "cell 1 11,growx");
        this.txtFirstName.setColumns(10);
        this.lblLastName = new JLabel(this.BUNDLE.getString("Document.LAST_NAME") + ":");
        this.panel.add((Component)this.lblLastName, "cell 0 12,alignx trailing");
        this.txtLastName = new ETextField();
        this.panel.add((Component)this.txtLastName, "cell 1 12,growx");
        this.txtLastName.setColumns(10);
        this.lblCompany = new JLabel(this.BUNDLE.getString("Document.COMPANY") + ":");
        this.panel.add((Component)this.lblCompany, "cell 0 9,alignx trailing");
        this.txtCompany = new ETextField();
        this.panel.add((Component)this.txtCompany, "cell 1 9,growx");
        this.txtCompany.setColumns(10);
        this.lblAddress1 = new JLabel(this.BUNDLE.getString("Document.ADDRESS1") + ":");
        this.panel.add((Component)this.lblAddress1, "cell 0 13,alignx trailing");
        this.txtAddress1 = new ETextField();
        this.panel.add((Component)this.txtAddress1, "cell 1 13,growx");
        this.txtAddress1.setColumns(10);
        this.lblAddress2 = new JLabel(this.BUNDLE.getString("Document.ADDRESS2") + ":");
        this.panel.add((Component)this.lblAddress2, "cell 0 14,alignx trailing");
        this.txtAddress2 = new ETextField();
        this.panel.add((Component)this.txtAddress2, "cell 1 14,growx");
        this.txtAddress2.setColumns(10);
        this.lblCountry = new JLabel(this.BUNDLE.getString("Document.COUNTRY") + ":");
        this.panel.add((Component)this.lblCountry, "cell 0 15,alignx trailing");
        this.cmbCountry = new JComboBox();
        this.panel.add(this.cmbCountry, "cell 1 15,growx");
        this.lblReferenceNumber = new JLabel(this.BUNDLE.getString("Document.REFERENCE_NUMBER") + ":");
        this.panel.add((Component)this.lblReferenceNumber, "cell 0 17,alignx trailing");
        this.txtReferenceNumber = new ETextField();
        this.panel.add((Component)this.txtReferenceNumber, "cell 1 17,growx");
        this.txtReferenceNumber.setColumns(10);
        this.lblText = new JLabel(this.BUNDLE.getString("Document.TEXT") + ":");
        this.panel.add((Component)this.lblText, "cell 0 18,alignx trailing,aligny top");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.panel.add((Component)this.scrollPane, "cell 1 18,grow");
        this.txtText = new ETextArea();
        this.txtText.setLineWrap(true);
        this.txtText.setWrapStyleWord(true);
        this.scrollPane.setViewportView(this.txtText);
        this.panel_4 = new JPanel();
        this.splitPane.setRightComponent(this.panel_4);
        this.panel_4.setLayout(new BorderLayout(0, 0));
        this.splitPane_1 = new JSplitPane();
        this.splitPane_1.setOrientation(0);
        this.panel_4.add(this.splitPane_1);
        this.panel_5 = new JPanel();
        this.splitPane_1.setLeftComponent(this.panel_5);
        this.panel_5.setLayout(new MigLayout("", "[grow]", "[][grow][]"));
        this.lblItems = new JLabel(this.BUNDLE.getString("LineItems") + ":");
        this.lblItems.setFont(new Font("Dialog", 1, 12));
        this.panel_5.add((Component)this.lblItems, "cell 0 0");
        this.scrollPane_1 = new JScrollPane();
        this.panel_5.add((Component)this.scrollPane_1, "cell 0 1,grow");
        this.tblItems = new EDataTable<LineItem>(LineItem.MODEL);
        this.tblItems.setFillsViewportHeight(true);
        this.scrollPane_1.setViewportView(this.tblItems);
        this.panel_6 = new JPanel();
        this.panel_5.add((Component)this.panel_6, "cell 0 2,growx");
        this.panel_6.setLayout(new BorderLayout(0, 0));
        this.panel_items_buttons = new JPanel();
        this.panel_6.add((Component)this.panel_items_buttons, "Center");
        this.panel_items_buttons.setLayout(new CardLayout(0, 0));
        this.panel_7 = new JPanel();
        this.panel_items_buttons.add((Component)this.panel_7, "viewing");
        this.panel_7.setLayout(new FlowLayout(0, 0, 0));
        this.btnShow = new JButton(this.BUNDLE.getString("generic.button.show"));
        this.btnShow.setEnabled(false);
        this.panel_7.add(this.btnShow);
        this.panel_8 = new JPanel();
        this.panel_items_buttons.add((Component)this.panel_8, "viewing_completable");
        this.panel_8.setLayout(new FlowLayout(0, 0, 0));
        this.btnShow2 = new JButton(this.BUNDLE.getString("generic.button.show"));
        this.btnShow2.setEnabled(false);
        this.panel_8.add(this.btnShow2);
        this.btnSplit = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.splitItem"));
        this.btnSplit.setEnabled(false);
        this.panel_8.add(this.btnSplit);
        this.btnMerge = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.mergeItems"));
        this.btnMerge.setEnabled(false);
        this.panel_8.add(this.btnMerge);
        this.panel_9 = new JPanel();
        this.panel_items_buttons.add((Component)this.panel_9, "editing");
        this.panel_9.setLayout(new FlowLayout(0, 0, 0));
        this.btnAdd = new JButton(this.BUNDLE.getString("generic.button.new"));
        this.panel_9.add(this.btnAdd);
        this.btnEdit = new JButton(this.BUNDLE.getString("generic.button.edit"));
        this.btnEdit.setEnabled(false);
        this.panel_9.add(this.btnEdit);
        this.btnRemove = new JButton(this.BUNDLE.getString("generic.button.remove"));
        this.btnRemove.setEnabled(false);
        this.panel_9.add(this.btnRemove);
        this.btnMoveUp = new JButton(this.BUNDLE.getString("generic.button.moveUp"));
        this.btnMoveUp.setEnabled(false);
        this.panel_9.add(this.btnMoveUp);
        this.btnMoveDown = new JButton(this.BUNDLE.getString("generic.button.moveDown"));
        this.btnMoveDown.setEnabled(false);
        this.panel_9.add(this.btnMoveDown);
        this.panel_10 = new JPanel();
        this.panel_6.add((Component)this.panel_10, "East");
        this.panel_10.setLayout(new FlowLayout(2, 0, 0));
        this.lblNetPrice = new JLabel(this.BUNDLE.getString("generic.label.netPrice") + ": ");
        this.panel_10.add(this.lblNetPrice);
        this.txtNetPrice = new ETextField();
        this.txtNetPrice.setHorizontalAlignment(11);
        this.txtNetPrice.setEditable(false);
        this.panel_10.add(this.txtNetPrice);
        this.txtNetPrice.setColumns(8);
        this.lblTotalPrice = new JLabel(" " + this.BUNDLE.getString("generic.label.totalPrice") + ": ");
        this.panel_10.add(this.lblTotalPrice);
        this.txtTotalPrice = new ETextField();
        this.txtTotalPrice.setHorizontalAlignment(11);
        this.txtTotalPrice.setEditable(false);
        this.panel_10.add(this.txtTotalPrice);
        this.txtTotalPrice.setColumns(8);
        this.panel_11 = new JPanel();
        this.splitPane_1.setRightComponent(this.panel_11);
        this.panel_11.setLayout(new MigLayout("", "[grow]", "[][grow][]"));
        this.lblDeductions = new JLabel(this.BUNDLE.getString("Deductions") + ":");
        this.lblDeductions.setFont(new Font("Dialog", 1, 12));
        this.panel_11.add((Component)this.lblDeductions, "cell 0 0");
        this.scrollPane_2 = new JScrollPane();
        this.panel_11.add((Component)this.scrollPane_2, "cell 0 1,grow");
        this.tblDeductions = new EDataTable<Deduction>(Deduction.MODEL);
        this.tblDeductions.setFillsViewportHeight(true);
        this.scrollPane_2.setViewportView(this.tblDeductions);
        this.panel_12 = new JPanel();
        this.panel_11.add((Component)this.panel_12, "cell 0 2,grow");
        this.panel_12.setLayout(new MigLayout("", "[][grow]", "[15px]"));
        this.lblPartialPrice = new JLabel(this.BUNDLE.getString("Document.PARTIAL_PRICE") + ":");
        this.panel_12.add((Component)this.lblPartialPrice, "cell 0 0,alignx trailing");
        this.txtPartialPrice = new ETextField();
        this.txtPartialPrice.setColumns(10);
        this.panel_12.add((Component)this.txtPartialPrice, "cell 1 0,growx");
        this.separator = new JSeparator();
        this.rootPanel.add((Component)this.separator, "South");
        this.bottomPanel.setLayout(new CardLayout(0, 0));
        this.buttons_draft = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.buttons_draft.getLayout();
        flowLayout.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_draft, "draft");
        this.btn_draft_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_draft.add(this.btn_draft_attachments);
        this.btn_draft_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_draft.add(this.btn_draft_print);
        this.btn_draft_finish = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.finish"));
        this.buttons_draft.add(this.btn_draft_finish);
        this.btn_draft_discard = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.discard"));
        this.buttons_draft.add(this.btn_draft_discard);
        this.buttons_done = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)this.buttons_done.getLayout();
        flowLayout_1.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_done, "done");
        this.btn_done_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_done.add(this.btn_done_attachments);
        this.btn_done_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_done.add(this.btn_done_print);
        this.buttons_offer = new JPanel();
        FlowLayout flowLayout_2 = (FlowLayout)this.buttons_offer.getLayout();
        flowLayout_2.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_offer, "offer");
        this.btn_offer_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_offer.add(this.btn_offer_attachments);
        this.btn_offer_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_offer.add(this.btn_offer_print);
        this.btn_offer_create_confirm = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.createConfirm"));
        this.buttons_offer.add(this.btn_offer_create_confirm);
        this.btn_offer_cancel = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.cancel"));
        this.buttons_offer.add(this.btn_offer_cancel);
        this.buttons_confirm = new JPanel();
        FlowLayout flowLayout_3 = (FlowLayout)this.buttons_confirm.getLayout();
        flowLayout_3.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_confirm, "confirm");
        this.btn_confirm_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_confirm.add(this.btn_confirm_attachments);
        this.btn_confirm_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_confirm.add(this.btn_confirm_print);
        this.btn_confirm_create_receipt = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.createReceipt"));
        this.buttons_confirm.add(this.btn_confirm_create_receipt);
        this.btn_confirm_create_invoice = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.createInvoice"));
        this.buttons_confirm.add(this.btn_confirm_create_invoice);
        this.btn_confirm_cancel = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.cancel"));
        this.buttons_confirm.add(this.btn_confirm_cancel);
        this.buttons_receipt = new JPanel();
        FlowLayout flowLayout_4 = (FlowLayout)this.buttons_receipt.getLayout();
        flowLayout_4.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_receipt, "receipt");
        this.btn_receipt_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_receipt.add(this.btn_receipt_attachments);
        this.btn_receipt_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_receipt.add(this.btn_receipt_print);
        this.btn_receipt_create_invoice = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.createInvoice"));
        this.buttons_receipt.add(this.btn_receipt_create_invoice);
        this.btn_receipt_cancel = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.cancel"));
        this.buttons_receipt.add(this.btn_receipt_cancel);
        this.buttons_invoice = new JPanel();
        FlowLayout flowLayout_5 = (FlowLayout)this.buttons_invoice.getLayout();
        flowLayout_5.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_invoice, "invoice");
        this.btn_invoice_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_invoice.add(this.btn_invoice_attachments);
        this.btn_invoice_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_invoice.add(this.btn_invoice_print);
        this.btn_invoice_confirm = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.confirm"));
        this.buttons_invoice.add(this.btn_invoice_confirm);
        this.btn_invoice_cancel = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.cancel"));
        this.buttons_invoice.add(this.btn_invoice_cancel);
        this.buttons_deposit_invoice = new JPanel();
        FlowLayout flowLayout_6 = (FlowLayout)this.buttons_deposit_invoice.getLayout();
        flowLayout_6.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_deposit_invoice, "deposit_invoice");
        this.btn_deposit_invoice_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_deposit_invoice.add(this.btn_deposit_invoice_attachments);
        this.btn_deposit_invoice_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_deposit_invoice.add(this.btn_deposit_invoice_print);
        this.btn_deposit_invoice_confirm = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.confirm"));
        this.buttons_deposit_invoice.add(this.btn_deposit_invoice_confirm);
        this.btn_deposit_invoice_cancel = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.cancel"));
        this.buttons_deposit_invoice.add(this.btn_deposit_invoice_cancel);
        this.btn_deposit_invoice_create_receipt = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.createReceipt"));
        this.buttons_deposit_invoice.add(this.btn_deposit_invoice_create_receipt);
        this.btn_deposit_invoice_create_next_invoice = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.createNextInvoice"));
        this.buttons_deposit_invoice.add(this.btn_deposit_invoice_create_next_invoice);
        this.buttons_partial_invoice = new JPanel();
        FlowLayout flowLayout_7 = (FlowLayout)this.buttons_partial_invoice.getLayout();
        flowLayout_7.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_partial_invoice, "partial_invoice");
        this.btn_partial_invoice_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_partial_invoice.add(this.btn_partial_invoice_attachments);
        this.btn_partial_invoice_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_partial_invoice.add(this.btn_partial_invoice_print);
        this.btn_partial_invoice_confirm = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.confirm"));
        this.buttons_partial_invoice.add(this.btn_partial_invoice_confirm);
        this.btn_partial_invoice_cancel = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.cancel"));
        this.buttons_partial_invoice.add(this.btn_partial_invoice_cancel);
        this.btn_partial_invoice_create_next_invoice = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.createNextInvoice"));
        this.buttons_partial_invoice.add(this.btn_partial_invoice_create_next_invoice);
        this.buttons_invoice_completed = new JPanel();
        FlowLayout flowLayout_8 = (FlowLayout)this.buttons_invoice_completed.getLayout();
        flowLayout_8.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_invoice_completed, "invoice.completed");
        this.btn_invoice_completed_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_invoice_completed.add(this.btn_invoice_completed_attachments);
        this.btn_invoice_completed_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_invoice_completed.add(this.btn_invoice_completed_print);
        this.btn_invoice_completed_create_cancelinvoice = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.createCancelInvoice"));
        this.buttons_invoice_completed.add(this.btn_invoice_completed_create_cancelinvoice);
        this.buttons_request = new JPanel();
        FlowLayout flowLayout_9 = (FlowLayout)this.buttons_request.getLayout();
        flowLayout_9.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_request, "request");
        this.btn_request_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_request.add(this.btn_request_attachments);
        this.btn_request_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_request.add(this.btn_request_print);
        this.btn_request_create_purchase = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.createPurchase"));
        this.buttons_request.add(this.btn_request_create_purchase);
        this.btn_request_cancel = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.cancel"));
        this.buttons_request.add(this.btn_request_cancel);
        this.buttons_purchase = new JPanel();
        FlowLayout flowLayout_10 = (FlowLayout)this.buttons_purchase.getLayout();
        flowLayout_10.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_purchase, "purchase");
        this.btn_purchase_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_purchase.add(this.btn_purchase_attachments);
        this.btn_purchase_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_purchase.add(this.btn_purchase_print);
        this.btn_purchase_create_payment = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.createPayment"));
        this.buttons_purchase.add(this.btn_purchase_create_payment);
        this.btn_purchase_complete = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.complete"));
        this.buttons_purchase.add(this.btn_purchase_complete);
        this.btn_purchase_cancel = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.cancel"));
        this.buttons_purchase.add(this.btn_purchase_cancel);
        this.buttons_payment = new JPanel();
        FlowLayout flowLayout_11 = (FlowLayout)this.buttons_payment.getLayout();
        flowLayout_11.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_payment, "payment");
        this.btn_payment_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_payment.add(this.btn_payment_attachments);
        this.btn_payment_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_payment.add(this.btn_payment_print);
        this.btn_payment_confirm = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.confirm"));
        this.buttons_payment.add(this.btn_payment_confirm);
        this.btn_payment_cancel = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.cancel"));
        this.buttons_payment.add(this.btn_payment_cancel);
        this.buttons_cancel = new JPanel();
        FlowLayout flowLayout_12 = (FlowLayout)this.buttons_cancel.getLayout();
        flowLayout_12.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_cancel, "cancel");
        this.btn_cancel_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_cancel.add(this.btn_cancel_attachments);
        this.btn_cancel_print = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.print"));
        this.buttons_cancel.add(this.btn_cancel_print);
        this.btn_cancel_confirm = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.confirm"));
        this.buttons_cancel.add(this.btn_cancel_confirm);
        this.btn_cancel_cancel = new JButton(this.BUNDLE.getString("EditDocumentDialog.buttons.cancel"));
        this.buttons_cancel.add(this.btn_cancel_cancel);
    }
}

