/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ShowArticlesDialog;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.ArticleVendor;
import de.inahware.dav.models.LineItem;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.models.types.ArticlePrice;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.ETextArea;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.EditDialog;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.SelectAll;
import de.inahware.edvj.query.filter.And;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class EditLineItemDialog2
extends EditDialog<LineItem> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private Article article;
    private List<TaxRate> taxes;
    private HashMap<Long, TaxRate> taxes_by_id;
    private JLabel lblArticleNumber;
    private JPanel panel_1;
    private ETextField txtArticleNumber;
    private JButton btnSearch;
    private JLabel lblVendorsArticleNumber;
    private ETextField txtVendorsArticleNumber;
    private JLabel lblArticleTitle;
    private ETextField txtArticleTitle;
    private JLabel lblPrice;
    private ETextField txtPrice;
    private JLabel lblUnit;
    private JComboBox<String> cmbUnit;
    private JLabel lblAmount;
    private ETextField txtAmount;
    private JLabel lblTax;
    private JComboBox<TaxRate> cmbTax;
    private JLabel lblDiscount;
    private ETextField txtDiscount;
    private JLabel lblText;
    private JScrollPane scrollPane;
    private ETextArea txtText;

    private EditLineItemDialog2() {
        this.initialize();
    }

    public EditLineItemDialog2(ClientContext ctx, Vendor vendor, LineItem entry, LineItem placeholder, boolean editable) {
        super(entry, placeholder);
        this.ctx = ctx;
        this.setWindowSize(480, 360);
        this.initialize();
        if (editable) {
            this.setImmediate(true);
        } else {
            this.setEditable(false);
        }
        this.addEditable(this.btnSearch);
        this.addEditable(this.txtVendorsArticleNumber);
        this.addEditable(this.txtArticleTitle);
        this.addEditable(this.txtPrice);
        this.addEditable(this.cmbUnit);
        this.addEditable(this.cmbTax);
        this.addEditable(this.txtAmount);
        this.addEditable(this.txtDiscount);
        this.addEditable(this.txtText);
        for (String next : this.BUNDLE.getString("Units").split(",")) {
            this.cmbUnit.addItem(next);
        }
        this.cmbTax.setRenderer(new FormattedListCellRenderer(obj -> ((TaxRate)obj).getDisplayName()));
        this.btnSearch.addActionListener(e -> EUtils.catchWithDialog(this, () -> new ShowArticlesDialog(true, ctx).inputPage(this, (Article article) -> {
            if (article == null) {
                return;
            }
            this.article = article;
            this.txtArticleNumber.setText(article.getNumber());
            this.txtArticleTitle.setText(article.getTitle());
            if (vendor != null) {
                ArticleVendor av = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<ArticleVendor>(ArticleVendor.MODEL, new And(ArticleVendor.COL_ARTICLE_ID.with(article.getId()), ArticleVendor.COL_VENDOR_ID.with(vendor.getId())))));
                if (av == null) {
                    return;
                }
                this.txtVendorsArticleNumber.setText(av.getVendorsArticleNumber());
                ArrayList<ArticlePrice> prices = av.getPriceList();
                this.txtPrice.setText(I18N.formatDecimal(prices.get((int)0).price));
                if (prices.size() > 1) {
                    JComboBox<Object> cmb = new JComboBox<Object>();
                    for (ArticlePrice p : prices) {
                        cmb.addItem(p);
                    }
                    cmb.setSelectedIndex(0);
                    cmb.setRenderer(new FormattedListCellRenderer(obj -> {
                        ArticlePrice p = (ArticlePrice)obj;
                        if (p.comment.isEmpty()) {
                            return I18N.formatDecimal(p.price);
                        }
                        return I18N.formatDecimal(p.price) + " (" + p.comment + ")";
                    }));
                    int answer = JOptionPane.showConfirmDialog(this, cmb, this.BUNDLE.getString("EditLineItemDialog.messages.select_price"), 2, 3);
                    if (answer == 0) {
                        this.txtPrice.setText(I18N.formatDecimal(((ArticlePrice)cmb.getSelectedItem()).price));
                    }
                }
            }
            this.cmbUnit.setSelectedItem(article.getUnit());
            this.txtText.setText(article.getDescription());
        })));
    }

    @Override
    protected void displayObject(LineItem obj) throws Exception {
        EUtils.blocking((Component)this, blocking -> {
            this.taxes = (List)((Object)this.ctx.query(new SelectAll<TaxRate>(TaxRate.MODEL)));
            this.taxes_by_id = new HashMap();
            for (TaxRate tax : this.taxes) {
                this.taxes_by_id.put(tax.getId(), tax);
            }
            this.article = null;
            if (obj.getArticleId() != null) {
                this.article = this.ctx.query(new Select<Article>(Article.MODEL, Article.COL_ID.with(obj.getArticleId())));
            }
        });
        this.cmbTax.removeAllItems();
        for (TaxRate tax : this.taxes) {
            if (!tax.isEnabled().booleanValue() && (obj == null || !tax.getId().equals(obj.getTaxRateId()))) continue;
            this.cmbTax.addItem(tax);
        }
        this.txtArticleNumber.setText(obj.getArticleNumber());
        this.txtVendorsArticleNumber.setText(obj.getVendorsArticleNumber());
        this.txtArticleTitle.setText(obj.getArticleTitle());
        this.txtPrice.setText(obj.getPrice() == null ? "" : I18N.formatDecimal(obj.getPrice()));
        this.cmbUnit.setSelectedItem(obj.getUnit());
        if (obj.getTaxRateId() == null) {
            this.cmbTax.setSelectedIndex(0);
        } else {
            this.cmbTax.setSelectedItem(this.taxes_by_id.get(obj.getTaxRateId()));
        }
        this.txtAmount.setText(I18N.formatDecimal(obj.getAmount()));
        this.txtDiscount.setText(I18N.formatDecimal(obj.getDiscount()));
        this.txtText.setText(obj.getText());
    }

    @Override
    protected LineItem parseObject(LineItem old) throws Exception {
        LineItem res = new LineItem(old);
        res.setArticleId(this.article == null ? null : this.article.getId());
        res.setArticleNumber(this.txtArticleNumber.getText());
        res.setVendorsArticleNumber(this.txtVendorsArticleNumber.getText());
        res.setArticleTitle(this.txtArticleTitle.getText());
        try {
            String price_str = this.txtPrice.getText().trim();
            if (price_str.isEmpty()) {
                res.setPrice(null);
            } else {
                BigDecimal price = I18N.parseDecimal(price_str);
                res.setPrice(price.setScale(2, RoundingMode.UNNECESSARY));
            }
        }
        catch (ArithmeticException | ParseException e) {
            throw new RuntimeException(this.BUNDLE.getString("EditLineItemDialog.messages.invalid_price"), e);
        }
        res.setUnit(this.cmbUnit.getSelectedItem().toString().trim());
        res.setTaxRateId(((TaxRate)this.cmbTax.getSelectedItem()).getId());
        try {
            String amount_str = this.txtAmount.getText().trim();
            BigDecimal amount = I18N.parseDecimal(amount_str);
            res.setAmount(amount.setScale(2, RoundingMode.UNNECESSARY));
        }
        catch (ArithmeticException | ParseException e) {
            throw new RuntimeException(this.BUNDLE.getString("EditLineItemDialog.messages.invalid_amount"), e);
        }
        try {
            String discount_str = this.txtDiscount.getText().trim();
            BigDecimal discount = I18N.parseDecimal(discount_str);
            res.setDiscount(discount.setScale(2, RoundingMode.UNNECESSARY));
        }
        catch (ArithmeticException | ParseException e) {
            throw new RuntimeException(this.BUNDLE.getString("EditLineItemDialog.messages.invalid_discount"), e);
        }
        res.setText(this.txtText.getText());
        return res;
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[][grow][][100px]", "[][][][][][][][grow]"));
        this.lblArticleNumber = new JLabel(this.BUNDLE.getString("LineItem.ARTICLE_NUMBER") + ":");
        this.rootPanel.add((Component)this.lblArticleNumber, "cell 0 0,alignx trailing");
        this.panel_1 = new JPanel();
        this.rootPanel.add((Component)this.panel_1, "cell 1 0 3 1,growx");
        this.panel_1.setLayout(new MigLayout("", "0[grow][]0", "0[]0"));
        this.txtArticleNumber = new ETextField();
        this.txtArticleNumber.setEditable(false);
        this.panel_1.add((Component)this.txtArticleNumber, "flowx,cell 0 0,growx,aligny center");
        this.txtArticleNumber.setColumns(10);
        this.btnSearch = new JButton(this.BUNDLE.getString("generic.button.search"));
        this.panel_1.add((Component)this.btnSearch, "cell 1 0");
        this.lblVendorsArticleNumber = new JLabel(this.BUNDLE.getString("LineItem.VENDORS_ARTICLE_NUMBER") + ":");
        this.rootPanel.add((Component)this.lblVendorsArticleNumber, "cell 0 1,alignx trailing");
        this.txtVendorsArticleNumber = new ETextField();
        this.rootPanel.add((Component)this.txtVendorsArticleNumber, "cell 1 1 3 1,growx");
        this.txtVendorsArticleNumber.setColumns(10);
        this.lblArticleTitle = new JLabel(this.BUNDLE.getString("LineItem.ARTICLE_TITLE") + ":");
        this.rootPanel.add((Component)this.lblArticleTitle, "cell 0 2,alignx trailing");
        this.txtArticleTitle = new ETextField();
        this.rootPanel.add((Component)this.txtArticleTitle, "cell 1 2 3 1,growx");
        this.txtArticleTitle.setColumns(10);
        this.lblPrice = new JLabel(this.BUNDLE.getString("LineItem.PRICE") + ":");
        this.rootPanel.add((Component)this.lblPrice, "cell 0 3,alignx trailing");
        this.txtPrice = new ETextField();
        this.rootPanel.add((Component)this.txtPrice, "cell 1 3,growx");
        this.txtPrice.setColumns(10);
        this.lblUnit = new JLabel(this.BUNDLE.getString("LineItem.UNIT") + ":");
        this.rootPanel.add((Component)this.lblUnit, "cell 2 3,alignx trailing");
        this.cmbUnit = new JComboBox();
        this.rootPanel.add(this.cmbUnit, "cell 3 3,growx");
        this.cmbUnit.setEditable(true);
        this.lblTax = new JLabel(this.BUNDLE.getString("LineItem.TAX_RATE_ID") + ":");
        this.rootPanel.add((Component)this.lblTax, "cell 0 4,alignx trailing");
        this.cmbTax = new JComboBox();
        this.rootPanel.add(this.cmbTax, "cell 1 4 3 1,growx");
        this.lblAmount = new JLabel(this.BUNDLE.getString("LineItem.AMOUNT") + ":");
        this.rootPanel.add((Component)this.lblAmount, "cell 0 5,alignx trailing");
        this.txtAmount = new ETextField();
        this.rootPanel.add((Component)this.txtAmount, "cell 1 5 3 1,growx");
        this.txtAmount.setColumns(10);
        this.lblDiscount = new JLabel(this.BUNDLE.getString("LineItem.DISCOUNT") + ":");
        this.rootPanel.add((Component)this.lblDiscount, "cell 0 6,alignx trailing");
        this.txtDiscount = new ETextField();
        this.rootPanel.add((Component)this.txtDiscount, "cell 1 6 3 1,growx");
        this.txtDiscount.setColumns(10);
        this.lblText = new JLabel(this.BUNDLE.getString("LineItem.TEXT") + ":");
        this.rootPanel.add((Component)this.lblText, "cell 0 7,alignx trailing,aligny top");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.rootPanel.add((Component)this.scrollPane, "cell 1 7 3 1,grow");
        this.txtText = new ETextArea();
        this.txtText.setLineWrap(true);
        this.txtText.setWrapStyleWord(true);
        this.scrollPane.setViewportView(this.txtText);
    }
}

