/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import com.github.lgooddatepicker.components.DatePicker;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.ClientDocumentRenderer;
import de.inahware.dav.client.gui.ChooseAddressDialog;
import de.inahware.dav.client.gui.EditAttachmentDialogs;
import de.inahware.dav.client.gui.PrintDialog;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.Notice;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.models.types.Salutation;
import de.inahware.dav.requests.NoticeCancel;
import de.inahware.dav.requests.NoticeFinishDraft;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.query.Select;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Path;
import java.text.Collator;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.pdfbox.pdmodel.PDDocument;

public class EditNoticeDialog
extends DefaultDataEditDialog<Notice> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private Customer customer;
    private JLabel lblDocument;
    private JTextField txtDocument;
    private JLabel lblCount;
    private JTextField txtCount;
    private JLabel lblDate;
    private DatePicker dtDate;
    private JLabel lblPaymentDate;
    private DatePicker dtPaymentDate;
    private JLabel lblAddress;
    private JLabel lblCompany;
    private ETextField txtCompany;
    private JLabel lblSalutation;
    private JPanel panel;
    private JComboBox<Salutation> cmbSalutation;
    private ETextField txtPrefix;
    private JLabel lblFirstName;
    private ETextField txtFirstName;
    private JLabel lblLastName;
    private ETextField txtLastName;
    private JLabel lblAddress1;
    private ETextField txtAddress1;
    private JLabel lblAddress2;
    private ETextField txtAddress2;
    private JLabel lblCountry;
    private JComboBox<String> cmbCountry;
    private JLabel lblRemainingPrice;
    private JTextField txtRemainingPrice;
    private JButton btnSelectAddress;
    private JPanel panel_buttons_draft;
    private JPanel panel_buttons_done;
    private JButton btn_draft_print;
    private JButton btn_draft_finish;
    private JButton btn_done_print;
    private JButton btn_draft_discard;
    private JLabel lblCustomer;
    private JTextField txtCustomer;

    private EditNoticeDialog() {
        this.initialize();
    }

    public EditNoticeDialog(ClientContext ctx, Notice obj) {
        this(ctx, obj, null);
    }

    public EditNoticeDialog(ClientContext ctx, Notice obj, Notice placeholder) {
        super(Notice.MODEL, ctx, obj, placeholder);
        this.ctx = ctx;
        this.setTitle(this.BUNDLE.getString("Notice"));
        this.setWindowSize(800, 600);
        this.initialize();
        this.addEditable(this.dtDate);
        this.addEditable(this.dtPaymentDate);
        this.addEditable(this.txtRemainingPrice);
        this.addEditable(this.btnSelectAddress);
        this.addEditable(this.txtCompany);
        this.addEditable(this.cmbSalutation);
        this.addEditable(this.txtPrefix);
        this.addEditable(this.txtFirstName);
        this.addEditable(this.txtLastName);
        this.addEditable(this.txtAddress1);
        this.addEditable(this.txtAddress2);
        this.addEditable(this.cmbCountry);
        this.btnSelectAddress.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            if (this.customer == null) {
                throw new RuntimeException("no customer selected");
            }
            new ChooseAddressDialog(ctx, this.customer, null).inputInnerModal(this, address -> {
                if (address == null) {
                    return;
                }
                this.txtCompany.setText(address.getCompany());
                this.cmbSalutation.setSelectedItem((Object)address.getSalutation());
                this.txtPrefix.setText(address.getPrefix());
                this.txtLastName.setText(address.getLastName());
                this.txtFirstName.setText(address.getFirstName());
                this.txtAddress1.setText(address.getAddress1());
                this.txtAddress2.setText(address.getAddress2());
                this.cmbCountry.setSelectedItem(address.getCountry());
            });
        }));
        this.cmbSalutation.addItemListener(ev -> {
            boolean enabled = this.cmbSalutation.getSelectedItem() != null;
            this.txtPrefix.setEnabled(enabled);
            this.txtFirstName.setEnabled(enabled);
            this.txtLastName.setEnabled(enabled);
        });
        this.cmbSalutation.setRenderer(new FormattedListCellRenderer(type -> type == null ? "-" : ((Salutation)((Object)((Object)type))).getLocalizedString(this.BUNDLE)));
        this.cmbSalutation.addItem(null);
        for (Salutation s2 : Salutation.values()) {
            this.cmbSalutation.addItem(s2);
        }
        this.cmbSalutation.setSelectedIndex(1);
        this.cmbSalutation.setSelectedIndex(0);
        this.cmbCountry.setRenderer(new FormattedListCellRenderer(c -> c == null ? "-" : new Locale("", (String)c).getDisplayCountry()));
        Locale.getISOCountries(Locale.IsoCountryCode.PART1_ALPHA2).stream().sorted(Comparator.comparing(s -> new Locale("", (String)s).getDisplayCountry(), Collator.getInstance())).forEach(c -> this.cmbCountry.addItem((String)c));
        this.addReadOnly(this.btn_draft_print);
        this.btn_draft_print.addActionListener(ev -> EUtils.catchWithDialog(this, () -> this.print(ev)));
        this.addReadOnly(this.btn_draft_finish);
        this.btn_draft_finish.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditNoticeDialog.messages.confirm_finish"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            Notice res = EUtils.blocking((Component)this, blocking -> ctx.query(new NoticeFinishDraft(((Notice)this.getObject()).getId())));
            this.objectSaved(res);
        }));
        this.addReadOnly(this.btn_draft_discard);
        this.btn_draft_discard.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditNoticeDialog.messages.confirm_discard"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            EUtils.blocking((Component)this, blocking -> ctx.query(new NoticeCancel(((Notice)this.getObject()).getId())));
            this.close();
        }));
        this.addReadOnly(this.btn_done_print);
        this.btn_done_print.addActionListener(ev -> EUtils.catchWithDialog(this, () -> this.print(ev)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(ActionEvent ev) throws Exception {
        String filename;
        PDDocument doc;
        boolean debug;
        Notice notice = (Notice)this.getObject();
        JComboBox<Object> cmb = new JComboBox<Object>();
        cmb.addItem(false);
        cmb.addItem(true);
        cmb.setSelectedIndex(0);
        cmb.setRenderer(new FormattedListCellRenderer(headless -> (Boolean)headless != false ? "headless" : "normal"));
        int answer = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
        if (answer != 0) {
            return;
        }
        Boolean headless2 = (Boolean)cmb.getSelectedItem();
        boolean bl = debug = (ev.getModifiers() & 2) != 0 && (ev.getModifiers() & 8) != 0 && (ev.getModifiers() & 1) != 0;
        if (debug || notice.getAttachmentId() == null) {
            doc = EUtils.blocking((Component)this, blocking -> {
                ClientDocumentRenderer renderer = new ClientDocumentRenderer(this.BUNDLE, this.ctx);
                renderer.setDebug(debug);
                return renderer.renderNotice(notice, headless2);
            });
            filename = "draft.pdf";
        } else {
            Long id = headless2 != false ? notice.getHeadlessAttachmentId() : notice.getAttachmentId();
            Attachment attachment = this.ctx.query(new Select<Attachment>(Attachment.MODEL, Attachment.COL_ID.with(id)));
            Path tmp = EditAttachmentDialogs.download((Component)this, this.ctx, attachment);
            try {
                doc = PDDocument.load(tmp.toFile());
                filename = attachment.getFilename();
            }
            finally {
                tmp.toFile().delete();
            }
        }
        PrintDialog dialog = new PrintDialog(filename, doc, notice.getState() != OrderState.DRAFT);
        dialog.openPage(this, () -> {
            if (notice.getState() == OrderState.DRAFT || !dialog.isPrinted()) {
                return;
            }
        });
    }

    @Override
    public void displayObject(Notice obj) throws Exception {
        EUtils.blocking((Component)this, blocking -> {
            this.customer = null;
            if (obj.getCustomerId() != null) {
                this.customer = this.ctx.query(new Select<Customer>(Customer.MODEL, Customer.COL_ID.with(obj.getCustomerId())));
            }
        });
        this.setEditable(this.ctx.getPermissions().contains(Notice.MODEL.getName() + ".update"));
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("Notice") + " " + this.BUNDLE.getString("generic.title.new") + " - " + obj.getDocumentNumber());
        } else {
            String title = this.BUNDLE.getString("Notice") + " - " + obj.getDocumentNumber();
            if (obj.getState() != OrderState.ONGOING) {
                title = title + " [" + obj.getState().getLocalizedString(this.BUNDLE) + "]";
            }
            this.setTitle(title);
        }
        this.txtDocument.setText(obj.getDocumentNumber());
        this.txtCustomer.setText(this.customer == null ? "-" : this.customer.getDisplayName(this.BUNDLE));
        this.dtDate.setDate(obj.getDate());
        this.dtPaymentDate.setDate(obj.getPaymentDate());
        this.txtCount.setText(obj.getCount() + ". " + this.BUNDLE.getString("Notice"));
        this.txtRemainingPrice.setText(I18N.formatDecimal(obj.getRemainingPrice()));
        this.cmbSalutation.setSelectedItem((Object)obj.getSalutation());
        this.txtPrefix.setText(obj.getPrefix());
        this.txtFirstName.setText(obj.getFirstName());
        this.txtLastName.setText(obj.getLastName());
        this.txtCompany.setText(obj.getCompany());
        this.cmbCountry.setSelectedItem(obj.getCountry());
        this.txtAddress1.setText(obj.getAddress1());
        this.txtAddress2.setText(obj.getAddress2());
        if (!this.ctx.getPermissions().contains(Notice.MODEL.getName() + ".update")) {
            this.setEditable(false);
        } else {
            this.setEditable(obj.getId() == null || obj.getState() == OrderState.DRAFT);
        }
        CardLayout card = (CardLayout)this.bottomPanel.getLayout();
        if (obj.getId() == null || obj.getState() == OrderState.DRAFT) {
            card.show(this.bottomPanel, "draft");
        } else {
            card.show(this.bottomPanel, "done");
        }
    }

    @Override
    public Notice parseObject(Notice old) throws Exception {
        Notice obj = new Notice(old);
        obj.setDate(this.dtDate.getDate());
        obj.setPaymentDate(this.dtPaymentDate.getDate());
        try {
            String amount_str = this.txtRemainingPrice.getText().trim();
            BigDecimal amount = I18N.parseDecimal(amount_str);
            obj.setRemainingPrice(amount.setScale(2, RoundingMode.UNNECESSARY));
        }
        catch (ArithmeticException | ParseException e) {
            throw new RuntimeException(this.BUNDLE.getString("generic.messages.invalid_price"), e);
        }
        obj.setSalutation((Salutation)((Object)this.cmbSalutation.getSelectedItem()));
        if (obj.getSalutation() == null) {
            obj.setPrefix("");
            obj.setFirstName("");
            obj.setLastName("");
        } else {
            obj.setPrefix(this.txtPrefix.getText().trim());
            obj.setFirstName(this.txtFirstName.getText().trim());
            obj.setLastName(this.txtLastName.getText().trim());
        }
        obj.setCompany(this.txtCompany.getText().trim());
        obj.setCountry((String)this.cmbCountry.getSelectedItem());
        obj.setAddress1(this.txtAddress1.getText().trim());
        obj.setAddress2(this.txtAddress2.getText().trim());
        obj.validate();
        return obj;
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[][75px:75px,grow]", "[][][][][][][20px][][][][][][][][]"));
        this.lblDocument = new JLabel(this.BUNDLE.getString("Document") + ":");
        this.rootPanel.add((Component)this.lblDocument, "cell 0 0,alignx trailing");
        this.txtDocument = new JTextField();
        this.txtDocument.setEditable(false);
        this.rootPanel.add((Component)this.txtDocument, "cell 1 0,growx");
        this.txtDocument.setColumns(10);
        this.lblCustomer = new JLabel(this.BUNDLE.getString("Customer") + ":");
        this.rootPanel.add((Component)this.lblCustomer, "cell 0 1,alignx trailing");
        this.txtCustomer = new JTextField();
        this.txtCustomer.setEditable(false);
        this.txtCustomer.setColumns(10);
        this.rootPanel.add((Component)this.txtCustomer, "cell 1 1,growx");
        this.lblCount = new JLabel(this.BUNDLE.getString("Notice.COUNT") + ":");
        this.rootPanel.add((Component)this.lblCount, "cell 0 4,alignx trailing");
        this.txtCount = new JTextField();
        this.txtCount.setEditable(false);
        this.txtCount.setColumns(10);
        this.rootPanel.add((Component)this.txtCount, "cell 1 4,growx");
        this.lblDate = new JLabel(this.BUNDLE.getString("Notice.DATE") + ":");
        this.rootPanel.add((Component)this.lblDate, "cell 0 2,alignx trailing");
        this.dtDate = new DatePicker();
        this.rootPanel.add((Component)this.dtDate, "cell 1 2,grow");
        this.lblPaymentDate = new JLabel(this.BUNDLE.getString("Notice.PAYMENT_DATE") + ":");
        this.rootPanel.add((Component)this.lblPaymentDate, "cell 0 3,alignx trailing");
        this.dtPaymentDate = new DatePicker();
        this.rootPanel.add((Component)this.dtPaymentDate, "cell 1 3,grow");
        this.lblRemainingPrice = new JLabel(this.BUNDLE.getString("Notice.REMAINING_PRICE") + ":");
        this.rootPanel.add((Component)this.lblRemainingPrice, "cell 0 5,alignx trailing");
        this.txtRemainingPrice = new JTextField();
        this.rootPanel.add((Component)this.txtRemainingPrice, "cell 1 5,growx");
        this.txtRemainingPrice.setColumns(10);
        this.lblAddress = new JLabel(this.BUNDLE.getString("Address") + ":");
        this.lblAddress.setFont(new Font("Dialog", 1, 12));
        this.rootPanel.add((Component)this.lblAddress, "cell 0 7");
        this.btnSelectAddress = new JButton("Select");
        this.rootPanel.add((Component)this.btnSelectAddress, "cell 1 7,alignx trailing");
        this.lblCompany = new JLabel(this.BUNDLE.getString("Notice.COMPANY") + ":");
        this.rootPanel.add((Component)this.lblCompany, "cell 0 8,alignx trailing");
        this.txtCompany = new ETextField();
        this.rootPanel.add((Component)this.txtCompany, "cell 1 8,growx");
        this.txtCompany.setColumns(10);
        this.lblSalutation = new JLabel(this.BUNDLE.getString("Notice.SALUTATION") + ":");
        this.rootPanel.add((Component)this.lblSalutation, "cell 0 9,alignx trailing");
        this.panel = new JPanel();
        this.rootPanel.add((Component)this.panel, "flowx,cell 1 9,grow");
        this.panel.setLayout(new BorderLayout(0, 0));
        this.cmbSalutation = new JComboBox();
        this.panel.add(this.cmbSalutation, "West");
        this.txtPrefix = new ETextField();
        this.panel.add(this.txtPrefix);
        this.txtPrefix.setColumns(10);
        this.lblFirstName = new JLabel(this.BUNDLE.getString("Notice.FIRST_NAME") + ":");
        this.rootPanel.add((Component)this.lblFirstName, "cell 0 10,alignx trailing");
        this.txtFirstName = new ETextField();
        this.rootPanel.add((Component)this.txtFirstName, "cell 1 10,growx");
        this.txtFirstName.setColumns(10);
        this.lblLastName = new JLabel(this.BUNDLE.getString("Notice.LAST_NAME") + ":");
        this.rootPanel.add((Component)this.lblLastName, "cell 0 11,alignx trailing");
        this.txtLastName = new ETextField();
        this.rootPanel.add((Component)this.txtLastName, "cell 1 11,growx");
        this.txtLastName.setColumns(10);
        this.lblAddress1 = new JLabel(this.BUNDLE.getString("Notice.ADDRESS1") + ":");
        this.rootPanel.add((Component)this.lblAddress1, "cell 0 12,alignx trailing");
        this.txtAddress1 = new ETextField();
        this.rootPanel.add((Component)this.txtAddress1, "cell 1 12,growx");
        this.txtAddress1.setColumns(10);
        this.lblAddress2 = new JLabel(this.BUNDLE.getString("Notice.ADDRESS2") + ":");
        this.rootPanel.add((Component)this.lblAddress2, "cell 0 13,alignx trailing");
        this.txtAddress2 = new ETextField();
        this.rootPanel.add((Component)this.txtAddress2, "cell 1 13,growx");
        this.txtAddress2.setColumns(10);
        this.lblCountry = new JLabel(this.BUNDLE.getString("Notice.COUNTRY") + ":");
        this.rootPanel.add((Component)this.lblCountry, "cell 0 14,alignx trailing");
        this.cmbCountry = new JComboBox();
        this.rootPanel.add(this.cmbCountry, "cell 1 14,growx");
        this.bottomPanel.setLayout(new CardLayout(0, 0));
        this.panel_buttons_draft = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel_buttons_draft.getLayout();
        flowLayout.setAlignment(0);
        this.bottomPanel.add((Component)this.panel_buttons_draft, "draft");
        this.btn_draft_print = new JButton(this.BUNDLE.getString("generic.button.print"));
        this.panel_buttons_draft.add(this.btn_draft_print);
        this.btn_draft_finish = new JButton(this.BUNDLE.getString("EditNoticeDialog.buttons.finish"));
        this.panel_buttons_draft.add(this.btn_draft_finish);
        this.btn_draft_discard = new JButton(this.BUNDLE.getString("EditNoticeDialog.buttons.discard"));
        this.panel_buttons_draft.add(this.btn_draft_discard);
        this.panel_buttons_done = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)this.panel_buttons_done.getLayout();
        flowLayout_1.setAlignment(0);
        this.bottomPanel.add((Component)this.panel_buttons_done, "done");
        this.btn_done_print = new JButton(this.BUNDLE.getString("generic.button.print"));
        this.panel_buttons_done.add(this.btn_done_print);
    }
}

