/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import com.github.lgooddatepicker.components.DatePicker;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ChooseAddressDialog;
import de.inahware.dav.client.gui.EditDocumentDialog;
import de.inahware.dav.client.gui.ShowAttachmentsDialog;
import de.inahware.dav.client.gui.ShowCustomersDialog;
import de.inahware.dav.models.Address;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.Order;
import de.inahware.dav.models.OrderDocumentView;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.DocumentType;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.models.types.Salutation;
import de.inahware.dav.models.types.Taxation;
import de.inahware.dav.requests.GetSettings;
import de.inahware.edvj.NamedException;
import de.inahware.edvj.gui.DataTablePanel;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.Update;
import de.inahware.edvj.query.filter.And;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.query.filter.Or;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import net.miginfocom.swing.MigLayout;

public class EditOrderDialog
extends DefaultDataEditDialog<Order> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private Customer customer;
    private Vendor vendor;
    private JSplitPane splitPane;
    private JPanel panel;
    private JLabel lblNumber;
    private ETextField txtNumber;
    private JLabel lblDate;
    private DatePicker txtDate;
    private JPanel panel_1;
    private JLabel lblPersonId;
    private ETextField txtPersonId;
    private JButton btnSearchPerson;
    private JLabel lblReferenceNumber;
    private ETextField txtReferenceNumber;
    private JPanel panel_2;
    private JLabel lblAddress;
    private JButton btnSelectAddress;
    private JLabel lblSalutation;
    private JPanel panel_4;
    private JComboBox<Salutation> cmbSalutation;
    private ETextField txtPrefix;
    private JLabel lblFirstName;
    private ETextField txtFirstName;
    private JLabel lblLastName;
    private ETextField txtLastName;
    private JLabel lblCompany;
    private ETextField txtCompany;
    private JLabel lblAddress1;
    private ETextField txtAddress1;
    private JLabel lblAddress2;
    private ETextField txtAddress2;
    private JLabel lblCountry;
    private JComboBox<String> cmbCountry;
    private JPanel panel_3;
    private JLabel lblShippingAddress;
    private JButton btnSelectShippingAddress;
    private JLabel lblShippingSalutation;
    private JPanel panel_5;
    private JComboBox<Salutation> cmbShippingSalutation;
    private ETextField txtShippingPrefix;
    private JLabel lblShippingFirstName;
    private ETextField txtShippingFirstName;
    private JLabel lblShippingLastName;
    private ETextField txtShippingLastName;
    private JLabel lblShippingCompany;
    private ETextField txtShippingCompany;
    private JLabel lblShippingAddress1;
    private ETextField txtShippingAddress1;
    private JLabel lblShippingAddress2;
    private ETextField txtShippingAddress2;
    private JLabel lblShippingCountry;
    private JComboBox<String> cmbShippingCountry;
    private DataTablePanel<OrderDocumentView> tablePanel;
    private JSeparator separator;
    private JButton btn_ongoing_attachments;
    private JPanel buttons_ongoing;
    private JPanel buttons_completed;
    private JButton btn_completed_attachments;
    private JButton btn_completed_reopen;
    private JButton btn_ongoing_complete;
    private JLabel lblTitle;
    private ETextField txtTitle;

    private EditOrderDialog() {
        this.initialize();
    }

    public EditOrderDialog(ClientContext ctx, Order order) {
        this(ctx, order, null);
    }

    public EditOrderDialog(ClientContext ctx, Order order, Order placeholder) {
        super(Order.MODEL, ctx, order, placeholder);
        this.ctx = ctx;
        this.setWindowSize(1280, 720);
        this.initialize();
        this.addEditable(this.txtDate);
        this.addEditable(this.txtTitle);
        this.addEditable(this.btnSearchPerson);
        this.addEditable(this.btnSelectAddress);
        this.addEditable(this.txtReferenceNumber);
        this.addEditable(this.cmbSalutation);
        this.addEditable(this.txtPrefix);
        this.addEditable(this.txtLastName);
        this.addEditable(this.txtFirstName);
        this.addEditable(this.txtCompany);
        this.addEditable(this.cmbCountry);
        this.addEditable(this.txtAddress1);
        this.addEditable(this.txtAddress2);
        this.addEditable(this.btnSelectShippingAddress);
        this.addEditable(this.cmbShippingSalutation);
        this.addEditable(this.txtShippingPrefix);
        this.addEditable(this.txtShippingLastName);
        this.addEditable(this.txtShippingFirstName);
        this.addEditable(this.txtShippingCompany);
        this.addEditable(this.cmbShippingCountry);
        this.addEditable(this.txtShippingAddress1);
        this.addEditable(this.txtShippingAddress2);
        this.addReadOnly(this.btn_ongoing_attachments);
        this.addReadOnly(this.btn_ongoing_complete);
        this.addReadOnly(this.btn_completed_attachments);
        this.addReadOnly(this.btn_completed_reopen);
        this.btnSearchPerson.addActionListener(e -> EUtils.catchWithDialog(this, () -> new ShowCustomersDialog(true, ctx).inputInnerModal(this, this::setCustomer)));
        this.btnSelectAddress.addActionListener(e -> EUtils.catchWithDialog(this, () -> this.chooseAddress(false)));
        this.cmbSalutation.addItemListener(ev -> {
            boolean enabled = this.cmbSalutation.getSelectedItem() != null;
            this.txtPrefix.setEnabled(enabled);
            this.txtFirstName.setEnabled(enabled);
            this.txtLastName.setEnabled(enabled);
        });
        this.cmbSalutation.setRenderer(new FormattedListCellRenderer(type -> type == null ? "-" : ((Salutation)((Object)((Object)((Object)type)))).getLocalizedString(this.BUNDLE)));
        this.cmbSalutation.addItem(null);
        for (Salutation salutation : Salutation.values()) {
            this.cmbSalutation.addItem(salutation);
        }
        this.cmbSalutation.setSelectedIndex(1);
        this.cmbSalutation.setSelectedIndex(0);
        this.cmbCountry.setRenderer(new FormattedListCellRenderer(c -> c == null ? "-" : new Locale("", (String)c).getDisplayCountry()));
        Locale.getISOCountries(Locale.IsoCountryCode.PART1_ALPHA2).stream().sorted(Comparator.comparing(s -> new Locale("", (String)s).getDisplayCountry(), Collator.getInstance())).forEach(c -> this.cmbCountry.addItem((String)c));
        this.btnSelectShippingAddress.addActionListener(e -> EUtils.catchWithDialog(this, () -> this.chooseAddress(true)));
        this.cmbShippingSalutation.addItemListener(ev -> {
            boolean enabled = this.cmbShippingSalutation.getSelectedItem() != null;
            this.txtShippingPrefix.setEnabled(enabled);
            this.txtShippingFirstName.setEnabled(enabled);
            this.txtShippingLastName.setEnabled(enabled);
        });
        this.cmbShippingSalutation.setRenderer(new FormattedListCellRenderer(type -> type == null ? "-" : ((Salutation)((Object)((Object)((Object)type)))).getLocalizedString(this.BUNDLE)));
        this.cmbShippingSalutation.addItem(null);
        for (Salutation salutation : Salutation.values()) {
            this.cmbShippingSalutation.addItem(salutation);
        }
        this.cmbShippingSalutation.setSelectedIndex(1);
        this.cmbShippingSalutation.setSelectedIndex(0);
        this.cmbShippingCountry.setRenderer(new FormattedListCellRenderer(c -> c == null ? "-" : new Locale("", (String)c).getDisplayCountry()));
        Locale.getISOCountries(Locale.IsoCountryCode.PART1_ALPHA2).stream().sorted(Comparator.comparing(s -> new Locale("", (String)s).getDisplayCountry(), Collator.getInstance())).forEach(c -> this.cmbShippingCountry.addItem((String)c));
        this.tablePanel.addSearchColumnString(OrderDocumentView.COL_NUMBER);
        this.tablePanel.addSearchColumnDate(OrderDocumentView.COL_DATE);
        this.tablePanel.addSearchColumnString(OrderDocumentView.COL_CUSTOMER_NUMBER);
        this.tablePanel.addSearchColumnString(OrderDocumentView.COL_VENDOR_NUMBER);
        this.tablePanel.addSearchColumnString(OrderDocumentView.COL_COMPANY);
        this.tablePanel.addSearchColumnString(OrderDocumentView.COL_PREFIX);
        this.tablePanel.addSearchColumnString(OrderDocumentView.COL_FIRST_NAME);
        this.tablePanel.addSearchColumnString(OrderDocumentView.COL_LAST_NAME);
        for (Enum enum_ : DocumentType.values()) {
            this.tablePanel.addSearchKeyword(((DocumentType)enum_).getLocalizedString(this.BUNDLE), OrderDocumentView.COL_TYPE.with((DocumentType)enum_));
        }
        for (Enum enum_ : OrderState.values()) {
            this.tablePanel.addSearchKeyword(((OrderState)enum_).getLocalizedString(this.BUNDLE), OrderDocumentView.COL_STATE.with((OrderState)enum_));
        }
        for (Enum enum_ : Salutation.values()) {
            this.tablePanel.addSearchKeyword(((Salutation)enum_).getLocalizedString(this.BUNDLE), OrderDocumentView.COL_SALUTATION.with((Salutation)enum_));
        }
        this.tablePanel.addColumn(OrderDocumentView.COL_STATE, state -> state.getLocalizedString(this.BUNDLE));
        this.tablePanel.addColumn(OrderDocumentView.COL_NUMBER);
        this.tablePanel.addColumn(OrderDocumentView.COL_TYPE, type -> type.getLocalizedString(this.BUNDLE));
        this.tablePanel.addColumn(OrderDocumentView.COL_DATE);
        this.tablePanel.addColumn(this.BUNDLE.getString("Customer") + " / " + this.BUNDLE.getString("Vendor"), obj -> {
            if (obj.getCustomerId() != null) {
                return obj.getCustomerNumber();
            }
            if (obj.getVendorNumber() != null) {
                return obj.getVendorNumber();
            }
            return "-";
        });
        this.tablePanel.addColumn(OrderDocumentView.COL_COMPANY);
        this.tablePanel.addColumn(OrderDocumentView.COL_SALUTATION, s -> s == null ? "-" : s.getLocalizedString(this.BUNDLE));
        this.tablePanel.addColumn(OrderDocumentView.COL_PREFIX);
        this.tablePanel.addColumn(OrderDocumentView.COL_FIRST_NAME);
        this.tablePanel.addColumn(OrderDocumentView.COL_LAST_NAME);
        this.tablePanel.setFilter(new Or(new Filter[0]));
        this.tablePanel.addDoubleClickAction(obj -> {
            DocumentFull doc = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(obj.getId()))));
            new EditDocumentDialog(ctx, doc).openPage(this, () -> this.tablePanel.refresh());
        });
        if (ctx.getPermissions().contains(DocumentFull.MODEL.getName() + ".insert")) {
            this.tablePanel.addButton(this.BUNDLE.getString("generic.button.new"), _obj -> this.getObject() != null && ((Order)this.getObject()).getState() == OrderState.ONGOING, _obj -> {
                Order obj = (Order)this.getObject();
                JComboBox<Object> cmb = new JComboBox<Object>();
                for (DocumentType type2 : DocumentType.values()) {
                    if (!type2.usesCustomer()) continue;
                    cmb.addItem((Object)type2);
                }
                cmb.setSelectedIndex(0);
                cmb.setRenderer(new FormattedListCellRenderer(type -> ((DocumentType)((Object)((Object)((Object)((Object)type))))).getLocalizedString(this.BUNDLE)));
                int answer = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
                if (answer != 0) {
                    return;
                }
                DocumentType type3 = (DocumentType)((Object)((Object)((Object)cmb.getSelectedItem())));
                DocumentFull doc = new DocumentFull(List.of(obj.getId()), type3, ctx.getLogin().getId());
                doc.setCustomerId(obj.getCustomerId());
                doc.setVendorId(obj.getVendorId());
                doc.setReferenceNumber(obj.getReferenceNumber());
                if (doc.getType() == DocumentType.RECEIPT) {
                    doc.setSalutation(obj.getShippingSalutation());
                    doc.setPrefix(obj.getShippingPrefix());
                    doc.setFirstName(obj.getShippingFirstName());
                    doc.setLastName(obj.getShippingLastName());
                    doc.setCompany(obj.getShippingCompany());
                    doc.setCountry(obj.getShippingCountry());
                    doc.setAddress1(obj.getShippingAddress1());
                    doc.setAddress2(obj.getShippingAddress2());
                } else {
                    doc.setSalutation(obj.getSalutation());
                    doc.setPrefix(obj.getPrefix());
                    doc.setFirstName(obj.getFirstName());
                    doc.setLastName(obj.getLastName());
                    doc.setCompany(obj.getCompany());
                    doc.setCountry(obj.getCountry());
                    doc.setAddress1(obj.getAddress1());
                    doc.setAddress2(obj.getAddress2());
                }
                Properties settings = EUtils.blocking((Component)this, blocking -> ctx.query(new GetSettings()));
                boolean kleinunternehmer = Boolean.parseBoolean(settings.getProperty("company.kleinunternehmer"));
                if (kleinunternehmer) {
                    doc.setTaxation(Taxation.KLEINUNTERNEHMER);
                }
                new EditDocumentDialog(ctx, null, doc).openPage(this, () -> this.tablePanel.refresh());
            });
        }
        this.tablePanel.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> {
            DocumentFull doc = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(obj.getId()))));
            new EditDocumentDialog(ctx, doc).openPage(this, () -> this.tablePanel.refresh());
        });
        if (ctx.getPermissions().contains(DocumentFull.MODEL.getName() + ".insert")) {
            this.tablePanel.addButton(this.BUNDLE.getString("generic.button.clone"), obj -> this.getObject() != null && ((Order)this.getObject()).getState() == OrderState.ONGOING && obj != null, obj -> {
                JComboBox<Object> cmb = new JComboBox<Object>();
                for (DocumentType type2 : DocumentType.values()) {
                    if (type2.usesCustomer() != obj.getType().usesCustomer()) continue;
                    cmb.addItem((Object)type2);
                }
                cmb.setSelectedItem((Object)obj.getType());
                cmb.setRenderer(new FormattedListCellRenderer(type -> ((DocumentType)((Object)((Object)((Object)((Object)type))))).getLocalizedString(this.BUNDLE)));
                int answer = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
                if (answer != 0) {
                    return;
                }
                DocumentType type3 = (DocumentType)((Object)((Object)((Object)cmb.getSelectedItem())));
                DocumentFull cloned = EUtils.blocking((Component)this, blocking -> {
                    DocumentFull doc = ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(obj.getId())));
                    Properties settings = ctx.query(new GetSettings());
                    boolean kleinunternehmer = Boolean.parseBoolean(settings.getProperty("company.kleinunternehmer"));
                    return doc.cloneDocument(type3, kleinunternehmer ? Taxation.KLEINUNTERNEHMER : Taxation.DEFAULT);
                });
                new EditDocumentDialog(ctx, null, cloned).openPage(this, () -> this.tablePanel.refresh());
            });
        }
        this.btn_ongoing_attachments.addActionListener(ev -> this.showAttachments());
        this.btn_ongoing_complete.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            Order obj = (Order)this.getObject();
            EUtils.blocking((Component)this, blocking -> {
                OrderDocumentView doc = ctx.query(new Select<OrderDocumentView>(OrderDocumentView.MODEL, new And(OrderDocumentView.COL_ORDER_ID.with(obj.getId()), OrderDocumentView.COL_STATE.with(OrderState.ONGOING))));
                if (doc != null) {
                    throw new NamedException("EditOrderDialog.messages.complete_ongoing_documents");
                }
            });
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditOrderDialog.messages.confirm_complete"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            Order obj2 = EUtils.blocking((Component)this, blocking -> {
                ctx.query(new Update<Order>(Order.MODEL, List.of(Order.COL_STATE.with(OrderState.COMPLETED)), obj.getPrimaryFilter()));
                return ctx.query(new Select<Order>(Order.MODEL, obj.getPrimaryFilter()));
            });
            this.objectSaved(obj2);
        }));
        this.btn_completed_attachments.addActionListener(ev -> this.showAttachments());
        this.btn_completed_reopen.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            Order obj = (Order)this.getObject();
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditOrderDialog.messages.confirm_reopen"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            Order obj2 = EUtils.blocking((Component)this, blocking -> {
                ctx.query(new Update<Order>(Order.MODEL, List.of(Order.COL_STATE.with(OrderState.ONGOING)), obj.getPrimaryFilter()));
                return ctx.query(new Select<Order>(Order.MODEL, obj.getPrimaryFilter()));
            });
            this.objectSaved(obj2);
        }));
    }

    private void setCustomer(Customer obj) throws Exception {
        if (obj == null) {
            return;
        }
        this.customer = obj;
        this.txtPersonId.setText(obj.getNumber());
        Address address = EUtils.blocking((Component)this, blocking -> this.ctx.query(new Select<Address>(Address.MODEL, new And(Address.COL_CUSTOMER_ID.with(obj.getId()), Address.COL_DEFAULT_ADDRESS.with(true)))));
        if (address != null) {
            this.cmbSalutation.setSelectedItem((Object)address.getSalutation());
            this.txtPrefix.setText(address.getPrefix());
            this.txtLastName.setText(address.getLastName());
            this.txtFirstName.setText(address.getFirstName());
            this.txtCompany.setText(address.getCompany());
            this.cmbCountry.setSelectedItem(address.getCountry());
            this.txtAddress1.setText(address.getAddress1());
            this.txtAddress2.setText(address.getAddress2());
        } else {
            this.cmbSalutation.setSelectedItem((Object)obj.getSalutation());
            this.txtPrefix.setText(obj.getPrefix());
            this.txtLastName.setText(obj.getLastName());
            this.txtFirstName.setText(obj.getFirstName());
            this.txtCompany.setText(obj.getCompany());
            this.txtAddress1.setText("");
            this.txtAddress2.setText("");
        }
        Address address2 = EUtils.blocking((Component)this, blocking -> this.ctx.query(new Select<Address>(Address.MODEL, new And(Address.COL_CUSTOMER_ID.with(obj.getId()), Address.COL_DEFAULT_SHIPPING_ADDRESS.with(true)))));
        if (address2 != null) {
            this.cmbShippingSalutation.setSelectedItem((Object)address2.getSalutation());
            this.txtShippingPrefix.setText(address2.getPrefix());
            this.txtShippingLastName.setText(address2.getLastName());
            this.txtShippingFirstName.setText(address2.getFirstName());
            this.txtShippingCompany.setText(address2.getCompany());
            this.cmbShippingCountry.setSelectedItem(address2.getCountry());
            this.txtShippingAddress1.setText(address2.getAddress1());
            this.txtShippingAddress2.setText(address2.getAddress2());
        } else {
            this.cmbShippingSalutation.setSelectedItem((Object)obj.getSalutation());
            this.txtShippingPrefix.setText(obj.getPrefix());
            this.txtShippingLastName.setText(obj.getLastName());
            this.txtShippingFirstName.setText(obj.getFirstName());
            this.txtShippingCompany.setText(obj.getCompany());
            this.txtShippingAddress1.setText("");
            this.txtShippingAddress2.setText("");
        }
    }

    private void chooseAddress(boolean shipping) throws Exception {
        if (this.customer == null && this.vendor == null) {
            throw new RuntimeException("no customer/vendor selected");
        }
        new ChooseAddressDialog(this.ctx, this.customer, this.vendor).inputInnerModal(this, address -> {
            if (address == null) {
                return;
            }
            if (!shipping) {
                this.cmbSalutation.setSelectedItem((Object)address.getSalutation());
                this.txtPrefix.setText(address.getPrefix());
                this.txtLastName.setText(address.getLastName());
                this.txtFirstName.setText(address.getFirstName());
                this.txtCompany.setText(address.getCompany());
                this.cmbCountry.setSelectedItem(address.getCountry());
                this.txtAddress1.setText(address.getAddress1());
                this.txtAddress2.setText(address.getAddress2());
            } else {
                this.cmbShippingSalutation.setSelectedItem((Object)address.getSalutation());
                this.txtShippingPrefix.setText(address.getPrefix());
                this.txtShippingLastName.setText(address.getLastName());
                this.txtShippingFirstName.setText(address.getFirstName());
                this.txtShippingCompany.setText(address.getCompany());
                this.cmbShippingCountry.setSelectedItem(address.getCountry());
                this.txtShippingAddress1.setText(address.getAddress1());
                this.txtShippingAddress2.setText(address.getAddress2());
            }
        });
    }

    private void showAttachments() {
        new ShowAttachmentsDialog(this.ctx, this.getTitle(), AttachmentObjectType.ORDER, ((Order)this.getObject()).getId()).openInnerModal(this);
    }

    @Override
    protected void displayObject(Order obj) throws Exception {
        EUtils.blocking((Component)this, blocking -> {
            this.customer = null;
            if (obj.getCustomerId() != null) {
                this.customer = this.ctx.query(new Select<Customer>(Customer.MODEL, Customer.COL_ID.with(obj.getCustomerId())));
            }
            this.vendor = null;
            if (obj.getVendorId() != null) {
                this.vendor = this.ctx.query(new Select<Vendor>(Vendor.MODEL, Vendor.COL_ID.with(obj.getVendorId())));
            }
        });
        this.setEditable(this.ctx.getPermissions().contains(Order.MODEL.getName() + ".update"));
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("Order") + " " + this.BUNDLE.getString("generic.title.new"));
            this.txtNumber.setText(this.BUNDLE.getString("generic.text.generated"));
        } else {
            String title = this.BUNDLE.getString("Order") + " " + obj.getNumber();
            if (obj.getState() != OrderState.ONGOING) {
                title = title + " [" + obj.getState().getLocalizedString(this.BUNDLE) + "]";
            }
            this.setTitle(title);
            this.txtNumber.setText(obj.getNumber());
        }
        this.txtDate.setDate(obj.getDate());
        this.txtTitle.setText(obj.getTitle());
        this.txtPersonId.setText("-");
        if (obj.getCustomerId() != null) {
            this.txtPersonId.setText(this.customer.getNumber());
        }
        if (obj.getVendorId() != null) {
            this.txtPersonId.setText(this.vendor.getNumber());
        }
        this.txtReferenceNumber.setText(obj.getReferenceNumber());
        this.cmbSalutation.setSelectedItem((Object)obj.getSalutation());
        this.txtPrefix.setText(obj.getPrefix());
        this.txtLastName.setText(obj.getLastName());
        this.txtFirstName.setText(obj.getFirstName());
        this.txtCompany.setText(obj.getCompany());
        this.cmbCountry.setSelectedItem(obj.getCountry());
        this.txtAddress1.setText(obj.getAddress1());
        this.txtAddress2.setText(obj.getAddress2());
        this.cmbShippingSalutation.setSelectedItem((Object)obj.getShippingSalutation());
        this.txtShippingPrefix.setText(obj.getShippingPrefix());
        this.txtShippingLastName.setText(obj.getShippingLastName());
        this.txtShippingFirstName.setText(obj.getShippingFirstName());
        this.txtShippingCompany.setText(obj.getShippingCompany());
        this.cmbShippingCountry.setSelectedItem(obj.getShippingCountry());
        this.txtShippingAddress1.setText(obj.getShippingAddress1());
        this.txtShippingAddress2.setText(obj.getShippingAddress2());
        this.tablePanel.setFilter(OrderDocumentView.COL_ORDER_ID.with(obj.getId()));
        this.tablePanel.refresh();
        CardLayout card = (CardLayout)this.bottomPanel.getLayout();
        card.show(this.bottomPanel, obj.getState().toString());
    }

    @Override
    protected Order parseObject(Order old) throws Exception {
        Order obj = new Order(old);
        if (this.txtDate.getDate() == null) {
            throw new RuntimeException(this.BUNDLE.getString("EditOrderDialog.messages.missing_date"));
        }
        obj.setDate(this.txtDate.getDate());
        obj.setTitle(this.txtTitle.getText());
        if (this.customer != null) {
            obj.setCustomerId(this.customer.getId());
        }
        if (this.vendor != null) {
            obj.setVendorId(this.vendor.getId());
        }
        obj.setReferenceNumber(this.txtReferenceNumber.getText().trim());
        obj.setSalutation((Salutation)((Object)this.cmbSalutation.getSelectedItem()));
        if (obj.getSalutation() == null) {
            obj.setPrefix("");
            obj.setFirstName("");
            obj.setLastName("");
        } else {
            obj.setPrefix(this.txtPrefix.getText().trim());
            obj.setFirstName(this.txtFirstName.getText().trim());
            obj.setLastName(this.txtLastName.getText().trim());
        }
        obj.setCompany(this.txtCompany.getText().trim());
        obj.setCountry((String)this.cmbCountry.getSelectedItem());
        obj.setAddress1(this.txtAddress1.getText().trim());
        obj.setAddress2(this.txtAddress2.getText().trim());
        obj.setShippingSalutation((Salutation)((Object)this.cmbShippingSalutation.getSelectedItem()));
        if (obj.getShippingSalutation() == null) {
            obj.setShippingPrefix("");
            obj.setShippingFirstName("");
            obj.setShippingLastName("");
        } else {
            obj.setShippingPrefix(this.txtPrefix.getText().trim());
            obj.setShippingFirstName(this.txtFirstName.getText().trim());
            obj.setShippingLastName(this.txtLastName.getText().trim());
        }
        obj.setShippingCompany(this.txtShippingCompany.getText().trim());
        obj.setShippingCountry((String)this.cmbShippingCountry.getSelectedItem());
        obj.setShippingAddress1(this.txtShippingAddress1.getText().trim());
        obj.setShippingAddress2(this.txtShippingAddress2.getText().trim());
        obj.validate();
        return obj;
    }

    private void initialize() {
        this.rootPanel.setLayout(new BorderLayout(0, 0));
        this.splitPane = new JSplitPane();
        this.rootPanel.add((Component)this.splitPane, "Center");
        this.panel = new JPanel();
        this.splitPane.setLeftComponent(this.panel);
        this.panel.setLayout(new MigLayout("", "[grow][grow]", "[][][][][][20px][][][][][][][][][20px][20px][][][][][][][]"));
        this.lblNumber = new JLabel(this.BUNDLE.getString("Order.NUMBER") + ":");
        this.panel.add((Component)this.lblNumber, "cell 0 0,alignx trailing");
        this.txtNumber = new ETextField();
        this.txtNumber.setEditable(false);
        this.panel.add((Component)this.txtNumber, "cell 1 0,growx");
        this.txtNumber.setColumns(10);
        this.lblDate = new JLabel(this.BUNDLE.getString("Order.DATE") + ":");
        this.panel.add((Component)this.lblDate, "cell 0 1,alignx trailing");
        this.txtDate = new DatePicker();
        this.txtDate.setEnabled(false);
        this.panel.add((Component)this.txtDate, "cell 1 1,growx");
        this.lblTitle = new JLabel(this.BUNDLE.getString("Order.TITLE") + ":");
        this.panel.add((Component)this.lblTitle, "cell 0 2,alignx trailing");
        this.txtTitle = new ETextField();
        this.txtTitle.setColumns(10);
        this.panel.add((Component)this.txtTitle, "cell 1 2,growx");
        this.lblPersonId = new JLabel(this.BUNDLE.getString("Order.CUSTOMER_ID") + ":");
        this.panel.add((Component)this.lblPersonId, "cell 0 3,alignx trailing,aligny center");
        this.panel_1 = new JPanel();
        this.panel.add((Component)this.panel_1, "cell 1 3,growx");
        this.panel_1.setLayout(new MigLayout("", "0[grow][]0", "0[]0"));
        this.txtPersonId = new ETextField();
        this.txtPersonId.setEditable(false);
        this.panel_1.add((Component)this.txtPersonId, "flowx,cell 0 0,growx,aligny center");
        this.txtPersonId.setColumns(10);
        this.btnSearchPerson = new JButton(this.BUNDLE.getString("generic.button.search"));
        this.panel_1.add((Component)this.btnSearchPerson, "cell 1 0");
        this.lblReferenceNumber = new JLabel(this.BUNDLE.getString("Order.REFERENCE_NUMBER") + ":");
        this.panel.add((Component)this.lblReferenceNumber, "cell 0 4,alignx trailing");
        this.txtReferenceNumber = new ETextField();
        this.panel.add((Component)this.txtReferenceNumber, "cell 1 4,growx");
        this.txtReferenceNumber.setColumns(10);
        this.panel_2 = new JPanel();
        this.panel.add((Component)this.panel_2, "cell 0 6 2 1,grow");
        this.panel_2.setLayout(new BorderLayout(0, 0));
        this.lblAddress = new JLabel(this.BUNDLE.getString("Order.address") + ":");
        this.panel_2.add((Component)this.lblAddress, "Center");
        this.lblAddress.setFont(new Font("Dialog", 1, 12));
        this.btnSelectAddress = new JButton(this.BUNDLE.getString("generic.button.select"));
        this.panel_2.add((Component)this.btnSelectAddress, "East");
        this.lblSalutation = new JLabel(this.BUNDLE.getString("Order.SALUTATION") + ":");
        this.panel.add((Component)this.lblSalutation, "cell 0 8,alignx trailing");
        this.panel_4 = new JPanel();
        this.panel.add((Component)this.panel_4, "flowx,cell 1 8,grow");
        this.panel_4.setLayout(new BorderLayout(0, 0));
        this.txtPrefix = new ETextField();
        this.panel_4.add(this.txtPrefix);
        this.txtPrefix.setColumns(10);
        this.cmbSalutation = new JComboBox();
        this.panel_4.add(this.cmbSalutation, "West");
        this.lblFirstName = new JLabel(this.BUNDLE.getString("Order.FIRST_NAME") + ":");
        this.panel.add((Component)this.lblFirstName, "cell 0 9,alignx trailing");
        this.txtFirstName = new ETextField();
        this.panel.add((Component)this.txtFirstName, "cell 1 9,growx");
        this.txtFirstName.setColumns(10);
        this.lblLastName = new JLabel(this.BUNDLE.getString("Order.LAST_NAME") + ":");
        this.panel.add((Component)this.lblLastName, "cell 0 10,alignx trailing");
        this.txtLastName = new ETextField();
        this.panel.add((Component)this.txtLastName, "cell 1 10,growx");
        this.txtLastName.setColumns(10);
        this.lblCompany = new JLabel(this.BUNDLE.getString("Order.COMPANY") + ":");
        this.panel.add((Component)this.lblCompany, "cell 0 7,alignx trailing");
        this.txtCompany = new ETextField();
        this.panel.add((Component)this.txtCompany, "cell 1 7,growx");
        this.txtCompany.setColumns(10);
        this.lblAddress1 = new JLabel(this.BUNDLE.getString("Order.ADDRESS1") + ":");
        this.panel.add((Component)this.lblAddress1, "cell 0 11,alignx trailing");
        this.txtAddress1 = new ETextField();
        this.panel.add((Component)this.txtAddress1, "cell 1 11,growx");
        this.txtAddress1.setColumns(10);
        this.lblAddress2 = new JLabel(this.BUNDLE.getString("Order.ADDRESS2") + ":");
        this.panel.add((Component)this.lblAddress2, "cell 0 12,alignx trailing");
        this.txtAddress2 = new ETextField();
        this.panel.add((Component)this.txtAddress2, "cell 1 12,growx");
        this.txtAddress2.setColumns(10);
        this.lblCountry = new JLabel(this.BUNDLE.getString("Order.COUNTRY") + ":");
        this.panel.add((Component)this.lblCountry, "cell 0 13,alignx trailing");
        this.cmbCountry = new JComboBox();
        this.panel.add(this.cmbCountry, "cell 1 13,growx");
        this.panel_3 = new JPanel();
        this.panel.add((Component)this.panel_3, "cell 0 15 2 1,grow");
        this.panel_3.setLayout(new BorderLayout(0, 0));
        this.lblShippingAddress = new JLabel(this.BUNDLE.getString("Order.shipping_address") + ":");
        this.panel_3.add((Component)this.lblShippingAddress, "Center");
        this.lblShippingAddress.setFont(new Font("Dialog", 1, 12));
        this.btnSelectShippingAddress = new JButton(this.BUNDLE.getString("generic.button.select"));
        this.panel_3.add((Component)this.btnSelectShippingAddress, "East");
        this.lblShippingSalutation = new JLabel(this.BUNDLE.getString("Order.SALUTATION") + ":");
        this.panel.add((Component)this.lblShippingSalutation, "cell 0 17,alignx trailing");
        this.panel_5 = new JPanel();
        this.panel.add((Component)this.panel_5, "flowx,cell 1 17,grow");
        this.panel_5.setLayout(new BorderLayout(0, 0));
        this.cmbShippingSalutation = new JComboBox();
        this.panel_5.add(this.cmbShippingSalutation, "West");
        this.txtShippingPrefix = new ETextField();
        this.panel_5.add(this.txtShippingPrefix);
        this.txtShippingPrefix.setColumns(10);
        this.lblShippingFirstName = new JLabel(this.BUNDLE.getString("Order.FIRST_NAME") + ":");
        this.panel.add((Component)this.lblShippingFirstName, "cell 0 18,alignx trailing");
        this.txtShippingFirstName = new ETextField();
        this.panel.add((Component)this.txtShippingFirstName, "cell 1 18,growx");
        this.txtShippingFirstName.setColumns(10);
        this.lblShippingLastName = new JLabel(this.BUNDLE.getString("Order.LAST_NAME") + ":");
        this.panel.add((Component)this.lblShippingLastName, "cell 0 19,alignx trailing");
        this.txtShippingLastName = new ETextField();
        this.panel.add((Component)this.txtShippingLastName, "cell 1 19,growx");
        this.txtShippingLastName.setColumns(10);
        this.lblShippingCompany = new JLabel(this.BUNDLE.getString("Order.COMPANY") + ":");
        this.panel.add((Component)this.lblShippingCompany, "cell 0 16,alignx trailing");
        this.txtShippingCompany = new ETextField();
        this.panel.add((Component)this.txtShippingCompany, "cell 1 16,growx");
        this.txtShippingCompany.setColumns(10);
        this.lblShippingAddress1 = new JLabel(this.BUNDLE.getString("Order.ADDRESS1") + ":");
        this.panel.add((Component)this.lblShippingAddress1, "cell 0 20,alignx trailing");
        this.txtShippingAddress1 = new ETextField();
        this.panel.add((Component)this.txtShippingAddress1, "cell 1 20,growx");
        this.txtShippingAddress1.setColumns(10);
        this.lblShippingAddress2 = new JLabel(this.BUNDLE.getString("Order.ADDRESS2") + ":");
        this.panel.add((Component)this.lblShippingAddress2, "cell 0 21,alignx trailing");
        this.txtShippingAddress2 = new ETextField();
        this.panel.add((Component)this.txtShippingAddress2, "cell 1 21,growx");
        this.txtShippingAddress2.setColumns(10);
        this.lblShippingCountry = new JLabel(this.BUNDLE.getString("Order.COUNTRY") + ":");
        this.panel.add((Component)this.lblShippingCountry, "cell 0 22,alignx trailing");
        this.cmbShippingCountry = new JComboBox();
        this.panel.add(this.cmbShippingCountry, "cell 1 22,growx");
        this.tablePanel = new DataTablePanel<OrderDocumentView>(OrderDocumentView.MODEL, this.ctx.getClient());
        this.splitPane.setRightComponent(this.tablePanel);
        this.separator = new JSeparator();
        this.rootPanel.add((Component)this.separator, "South");
        this.bottomPanel.setLayout(new CardLayout(0, 0));
        this.buttons_ongoing = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.buttons_ongoing.getLayout();
        flowLayout.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_ongoing, OrderState.ONGOING.toString());
        this.btn_ongoing_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_ongoing.add(this.btn_ongoing_attachments);
        this.btn_ongoing_complete = new JButton(this.BUNDLE.getString("EditOrderDialog.buttons.complete"));
        this.buttons_ongoing.add(this.btn_ongoing_complete);
        this.buttons_completed = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)this.buttons_completed.getLayout();
        flowLayout_1.setAlignment(0);
        this.bottomPanel.add((Component)this.buttons_completed, OrderState.COMPLETED.toString());
        this.btn_completed_attachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.buttons_completed.add(this.btn_completed_attachments);
        this.btn_completed_reopen = new JButton(this.BUNDLE.getString("EditOrderDialog.buttons.reopen"));
        this.buttons_completed.add(this.btn_completed_reopen);
    }
}

