/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import com.github.lgooddatepicker.components.DatePicker;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditDocumentDialog;
import de.inahware.dav.client.gui.EditNoticeDialog;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.Notice;
import de.inahware.dav.models.PendingNotice;
import de.inahware.dav.models.types.DocumentType;
import de.inahware.dav.requests.PendingNoticePostpone;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Select;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.time.LocalDate;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class EditPendingNoticeDialog
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private PendingNotice notice;
    private JPanel panel;
    private JPanel panel_2;
    private JPanel panel_3;
    private JPanel panel_4;
    private JButton btnClose;
    private JButton btnPostpone;
    private JButton btnCreate;
    private JLabel lblDocument;
    private ETextField txtDocument;
    private JLabel lblDate;
    private ETextField txtDate;
    private JLabel lblCount;
    private ETextField txtCount;
    private JPanel panel_1;
    private JButton btnShowInvoice;

    private EditPendingNoticeDialog() {
        this.initialize();
    }

    public EditPendingNoticeDialog(ClientContext ctx, PendingNotice obj) {
        this.notice = obj;
        this.setWindowSize(560, 315);
        this.initialize();
        this.setTitle(this.BUNDLE.getString("PendingNotice") + " - " + DocumentType.INVOICE.getLocalizedString(this.BUNDLE) + " #" + obj.getDocumentId());
        this.txtDocument.setText("" + obj.getDocumentId());
        this.txtDate.setText(I18N.formatDate(obj.getDate()));
        this.txtCount.setText(obj.getCount() + ". " + this.BUNDLE.getString("Notice"));
        this.btnShowInvoice.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            DocumentFull doc = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(obj.getDocumentId()))));
            new EditDocumentDialog(ctx, doc).openPage(this);
        }));
        this.btnCreate.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            DocumentFull doc = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(obj.getDocumentId()))));
            Notice notice = new Notice();
            notice.setDocumentId(doc.getId());
            notice.setDocumentNumber(doc.getNumber());
            notice.setDate(LocalDate.now());
            notice.setPaymentDate(notice.getDate().plusDays(14L));
            notice.setCount(obj.getCount());
            notice.setRemainingPrice(doc.getRemainingPrice());
            notice.setCustomerId(doc.getCustomerId());
            notice.setCompany(doc.getCompany());
            notice.setSalutation(doc.getSalutation());
            notice.setPrefix(doc.getPrefix());
            notice.setFirstName(doc.getFirstName());
            notice.setLastName(doc.getLastName());
            notice.setAddress1(doc.getAddress1());
            notice.setAddress2(doc.getAddress2());
            notice.setCountry(doc.getCountry());
            new EditNoticeDialog(ctx, null, notice).inputInnerModal(this, false, obj2 -> {
                if (obj2 != null) {
                    this.close();
                }
            });
        }));
        this.btnPostpone.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            LocalDate date = this.inputDate();
            if (date == null) {
                return;
            }
            EUtils.blocking((Component)this, blocking -> ctx.query(new PendingNoticePostpone(obj.getId(), date)));
            this.close();
        }));
        this.btnClose.addActionListener(e -> this.close());
    }

    private LocalDate inputDate() {
        LocalDate date = null;
        while (true) {
            JPanel panel = new JPanel();
            panel.setLayout(new MigLayout("", "[]", "[][]"));
            panel.add((Component)new JLabel("input date"), "cell 0 0");
            DatePicker picker = new DatePicker();
            picker.getSettings().setAllowEmptyDates(false);
            picker.setDate(date);
            panel.add((Component)picker, "cell 0 1,growx");
            int answer = JOptionPane.showConfirmDialog(this, panel, this.getTitle(), 2, 3);
            if (answer != 0) {
                return null;
            }
            date = picker.getDate();
            if (!date.isBefore(this.notice.getDate())) break;
            EUtils.showErrorDialog((Component)this, this.BUNDLE.getString("EditPendingNoticeDialog.messages.date_before_noticeDate"));
        }
        return date;
    }

    private void initialize() {
        this.panel = new JPanel();
        this.add((Component)this.panel, "Center");
        this.panel.setLayout(new MigLayout("", "[][grow]", "[][][]"));
        this.lblDocument = new JLabel(this.BUNDLE.getString("PendingNotice.DOCUMENT_ID") + ":");
        this.panel.add((Component)this.lblDocument, "cell 0 0,alignx trailing,aligny center");
        this.panel_1 = new JPanel();
        this.panel.add((Component)this.panel_1, "cell 1 0,grow");
        this.panel_1.setLayout(new MigLayout("", "0[grow][]0", "0[]0"));
        this.txtDocument = new ETextField();
        this.txtDocument.setEditable(false);
        this.panel_1.add((Component)this.txtDocument, "cell 0 0,growx,aligny center");
        this.txtDocument.setColumns(10);
        this.btnShowInvoice = new JButton(this.BUNDLE.getString("generic.button.show"));
        this.panel_1.add((Component)this.btnShowInvoice, "cell 1 0");
        this.lblDate = new JLabel(this.BUNDLE.getString("PendingNotice.DATE") + ":");
        this.panel.add((Component)this.lblDate, "cell 0 1,alignx trailing");
        this.txtDate = new ETextField();
        this.txtDate.setEditable(false);
        this.panel.add((Component)this.txtDate, "cell 1 1,growx");
        this.txtDate.setColumns(10);
        this.lblCount = new JLabel(this.BUNDLE.getString("PendingNotice.COUNT") + ":");
        this.panel.add((Component)this.lblCount, "cell 0 2,alignx trailing");
        this.txtCount = new ETextField();
        this.txtCount.setEditable(false);
        this.panel.add((Component)this.txtCount, "cell 1 2,growx");
        this.txtCount.setColumns(10);
        this.panel_2 = new JPanel();
        this.add((Component)this.panel_2, "South");
        this.panel_2.setLayout(new BorderLayout(0, 0));
        this.panel_3 = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel_3.getLayout();
        flowLayout.setAlignment(0);
        this.panel_2.add((Component)this.panel_3, "Center");
        this.btnCreate = new JButton(this.BUNDLE.getString("EditPendingNoticeDialog.button.create"));
        this.panel_3.add(this.btnCreate);
        this.btnPostpone = new JButton(this.BUNDLE.getString("EditPendingNoticeDialog.button.postpone"));
        this.panel_3.add(this.btnPostpone);
        this.panel_4 = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)this.panel_4.getLayout();
        flowLayout_1.setAlignment(2);
        this.panel_2.add((Component)this.panel_4, "East");
        this.btnClose = new JButton(this.BUNDLE.getString("generic.button.close"));
        this.panel_4.add(this.btnClose);
    }
}

