/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.RecordCategory;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextField;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class EditRecordCategoryDialog
extends DefaultDataEditDialog<RecordCategory> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JLabel lblTitle;
    private ETextField txtTitle;

    private EditRecordCategoryDialog() {
        this.initialize();
    }

    public EditRecordCategoryDialog(ClientContext ctx, RecordCategory obj) {
        this(ctx, obj, null);
    }

    public EditRecordCategoryDialog(ClientContext ctx, RecordCategory obj, RecordCategory placeholder) {
        super(RecordCategory.MODEL, ctx, obj, placeholder);
        this.ctx = ctx;
        this.setWindowSize(480, 160);
        this.initialize();
        this.addEditable(this.txtTitle);
    }

    @Override
    protected void displayObject(RecordCategory obj) throws Exception {
        this.setEditable(this.ctx.getPermissions().contains(RecordCategory.MODEL.getName() + ".update"));
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("RecordCategory") + " " + this.BUNDLE.getString("generic.title.new"));
        } else {
            this.setTitle(this.BUNDLE.getString("RecordCategory") + " - " + obj.getTitle());
        }
        this.txtTitle.setText(obj.getTitle());
    }

    @Override
    protected RecordCategory parseObject(RecordCategory old) throws Exception {
        RecordCategory obj = new RecordCategory(old);
        obj.setTitle(this.txtTitle.getText());
        obj.validate();
        return obj;
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[][grow]", "[]"));
        this.lblTitle = new JLabel(this.BUNDLE.getString("RecordCategory.TITLE") + ":");
        this.rootPanel.add((Component)this.lblTitle, "cell 0 0,alignx trailing");
        this.txtTitle = new ETextField();
        this.rootPanel.add((Component)this.txtTitle, "cell 1 0,growx");
        this.txtTitle.setColumns(10);
    }
}

