/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import com.github.lgooddatepicker.components.DatePicker;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditAttachmentDialogs;
import de.inahware.dav.client.gui.EditDocumentDialog;
import de.inahware.dav.client.gui.ShowAttachmentsDialog;
import de.inahware.dav.client.gui.ShowDocumentsDialog;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.Record;
import de.inahware.dav.models.RecordCategory;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.RecordTaxEntry;
import de.inahware.edvj.I18N;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETable;
import de.inahware.edvj.gui.ETableModel;
import de.inahware.edvj.gui.ETextArea;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.gui.FormattedTableCellRenderer;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.SelectAll;
import java.awt.Component;
import java.awt.FlowLayout;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class EditRecordDialog
extends DefaultDataEditDialog<Record> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private List<RecordCategory> categories;
    private Map<Long, RecordCategory> categories_map;
    private List<TaxRate> taxRates;
    private Map<Long, TaxRate> taxRatesMap;
    private JComboBox<TaxRate> cmbTaxRate;
    private Document document;
    private Attachment att_new;
    private JLabel lblId;
    private ETextField txtId;
    private JLabel lblDate;
    private DatePicker datePicker;
    private JLabel lblCategory;
    private JComboBox<RecordCategory> cmbCategory;
    private JLabel lblAmounts;
    private JPanel panel;
    private ETextField txtNetAmount;
    private ETextField txtTotalAmount;
    private JButton btnComputeTotalAmount;
    private JLabel lblTaxes;
    private JScrollPane scrollPane;
    private ETable<RecordTaxEntry> tblTaxes;
    private JLabel lblDescription;
    private JScrollPane scrollPane_1;
    private ETextArea textArea;
    private JLabel lblDocument;
    private JLabel lblAttachment;
    private JPanel panel_1;
    private ETextField txtDocument;
    private JButton btnShowDocument;
    private JButton btnSearchDocument;
    private JButton btnResetDocument;
    private JPanel panel_2;
    private JTextField txtAttachment;
    private JButton btnViewAttachment;
    private JButton btnNewAttachment;
    private JButton btnAttachments;

    private EditRecordDialog() {
        this.initialize();
    }

    public EditRecordDialog(ClientContext ctx, Record record) {
        this(ctx, record, null);
    }

    public EditRecordDialog(ClientContext ctx, Record record, Record placeholder) {
        super(Record.MODEL, ctx, record, placeholder);
        this.ctx = ctx;
        this.setWindowSize(640, 360);
        this.initialize();
        this.addEditable(this.datePicker);
        this.addEditable(this.cmbCategory);
        this.addEditable(this.txtNetAmount);
        this.addEditable(this.txtTotalAmount);
        this.addEditable(this.btnComputeTotalAmount);
        this.addEditable(this.tblTaxes);
        this.addEditable(this.textArea);
        this.addEditable(this.btnSearchDocument);
        this.addEditable(this.btnResetDocument);
        this.addEditable(this.btnNewAttachment);
        this.addReadOnly(this.btnAttachments);
        this.cmbCategory.setRenderer(new FormattedListCellRenderer(category -> category == null ? "-" : this.getFullTitle((RecordCategory)category)));
        this.btnComputeTotalAmount.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            BigDecimal total = this.computeTotalAmount();
            this.txtTotalAmount.setText(I18N.formatDecimal(total));
        }));
        this.tblTaxes.setDefaultRenderer(TaxRate.class, new FormattedTableCellRenderer(type -> type == null ? "-" : ((TaxRate)type).getDisplayName()));
        this.cmbTaxRate = new JComboBox();
        this.cmbTaxRate.setRenderer(new FormattedListCellRenderer(obj -> obj == null ? "-" : ((TaxRate)obj).getDisplayName()));
        this.tblTaxes.setDefaultEditor(TaxRate.class, new DefaultCellEditor(this.cmbTaxRate));
        this.tblTaxes.addColumn("", TaxRate.class, entry -> this.taxRatesMap.get(entry.getTaxRateId()), (entry, value) -> entry.setTaxRateId(((TaxRate)value).getId()));
        this.tblTaxes.addColumn("", String.class, entry -> I18N.formatDecimal(entry.getAmount()), (entry, value) -> {
            try {
                BigDecimal amount = I18N.parseDecimal((String)value);
                entry.setAmount(amount.setScale(2, RoundingMode.HALF_UP));
            }
            catch (ArithmeticException | ParseException exception) {
                // empty catch block
            }
        });
        this.tblTaxes.addPopupMenuItem(this.BUNDLE.getString("generic.menu.addEntry"), obj -> this.tblTaxes.isEditable(), obj -> ((ETableModel)this.tblTaxes.getModel()).addRow(new RecordTaxEntry(null, BigDecimal.ZERO)));
        this.tblTaxes.addPopupMenuItem(this.BUNDLE.getString("generic.menu.deleteEntry"), obj -> this.tblTaxes.isEditable() && obj != null, obj -> ((ETableModel)this.tblTaxes.getModel()).deleteRow(this.tblTaxes.getSelectedRow()));
        this.btnShowDocument.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            if (this.document == null) {
                throw new RuntimeException("no document selected");
            }
            DocumentFull doc = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(this.document.getId()))));
            new EditDocumentDialog(ctx, doc).openPage(this);
        }));
        this.btnSearchDocument.addActionListener(ev -> EUtils.catchWithDialog(this, () -> new ShowDocumentsDialog(ctx, true).inputInnerModal(this, obj -> {
            if (obj == null) {
                return;
            }
            this.document = obj;
            this.txtDocument.setText(obj.getType().getLocalizedString(this.BUNDLE) + " " + obj.getNumber());
        })));
        this.btnResetDocument.addActionListener(ev -> {
            this.document = null;
            this.txtDocument.setText("-");
        });
        this.btnViewAttachment.addActionListener(e -> EUtils.catchWithDialog(this, () -> EditAttachmentDialogs.create(this, ctx, this.att_new != null ? this.att_new.getId() : ((Record)this.getObject()).getAttachmentId()).openPage(this)));
        this.btnNewAttachment.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            DefaultDataEditDialog<Attachment> dialog = EditAttachmentDialogs.create(this, ctx, AttachmentObjectType.RECORD, ((Record)this.getObject()).getId(), true, this.BUNDLE.getString("Record"));
            if (dialog == null) {
                return;
            }
            dialog.inputPage(this, res -> {
                if (res == null) {
                    return;
                }
                if (this.att_new != null) {
                    ctx.query(new Delete<Attachment>(Attachment.MODEL, this.att_new.getPrimaryFilter()));
                }
                this.att_new = res;
                this.displayAttachment(this.att_new.getId());
            });
        }));
        this.btnAttachments.addActionListener(e -> new ShowAttachmentsDialog(ctx, this.getTitle(), AttachmentObjectType.RECORD, ((Record)this.getObject()).getId()).openInnerModal(this));
    }

    @Override
    protected void displayObject(Record obj) throws Exception {
        EUtils.blocking((Component)this, blocking -> {
            this.categories = (List)((Object)this.ctx.query(new SelectAll<RecordCategory>(RecordCategory.MODEL)));
            this.categories_map = new HashMap<Long, RecordCategory>();
            for (RecordCategory c : this.categories) {
                this.categories_map.put(c.getId(), c);
            }
            this.categories.sort(Comparator.comparing(category -> this.getFullTitle((RecordCategory)category)));
            this.taxRates = (List)((Object)this.ctx.query(new SelectAll<TaxRate>(TaxRate.MODEL)));
            this.taxRatesMap = new HashMap<Long, TaxRate>();
            for (TaxRate t : this.taxRates) {
                this.taxRatesMap.put(t.getId(), t);
            }
            if (this.att_new != null) {
                this.ctx.query(new Delete<Attachment>(Attachment.MODEL, this.att_new.getPrimaryFilter()));
                this.att_new = null;
            }
            this.document = null;
            if (obj.getDocumentId() != null) {
                this.document = this.ctx.query(new Select<Document>(Document.MODEL, Document.COL_ID.with(obj.getDocumentId())));
            }
        });
        this.setEditable(this.ctx.getPermissions().contains(Record.MODEL.getName() + ".update"));
        this.cmbCategory.removeAllItems();
        this.cmbCategory.addItem(null);
        for (RecordCategory category : this.categories) {
            this.cmbCategory.addItem(category);
        }
        this.cmbTaxRate.removeAllItems();
        this.cmbTaxRate.addItem(null);
        for (TaxRate taxRate : this.taxRates) {
            this.cmbTaxRate.addItem(taxRate);
        }
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("Record") + " " + this.BUNDLE.getString("generic.title.new"));
            this.txtId.setText(this.BUNDLE.getString("generic.text.generated"));
            this.setEnabled(this.btnNewAttachment, false);
        } else {
            this.setTitle(this.BUNDLE.getString("Record") + " #" + obj.getId());
            this.txtId.setText(obj.getId().toString());
            this.setEnabled(this.btnNewAttachment, true);
        }
        this.datePicker.setDate(obj.getDate());
        if (obj.getCategoryId() == null) {
            this.cmbCategory.setSelectedItem(0);
        } else {
            this.cmbCategory.setSelectedItem(this.categories_map.get(obj.getCategoryId()));
        }
        this.txtNetAmount.setText(obj.getNetAmount() == null ? "" : I18N.formatDecimal(obj.getNetAmount()));
        this.txtTotalAmount.setText(obj.getTotalAmount() == null ? "" : I18N.formatDecimal(obj.getTotalAmount()));
        this.tblTaxes.setData(obj.getTaxEntries());
        this.textArea.setText(obj.getDescription());
        this.txtDocument.setText((String)(this.document == null ? "-" : this.document.getType().getLocalizedString(this.BUNDLE) + " " + this.document.getNumber()));
        this.displayAttachment(obj.getAttachmentId());
    }

    private String getFullTitle(RecordCategory category) {
        Object title = category.getTitle();
        while (category.getParentId() != null) {
            category = this.categories_map.get(category.getParentId());
            title = category.getTitle() + " - " + (String)title;
        }
        return title;
    }

    private void displayAttachment(Long id) {
        if (id == null) {
            this.txtAttachment.setText("-");
            this.btnViewAttachment.setEnabled(false);
        } else {
            this.txtAttachment.setText(this.BUNDLE.getString("Attachment") + " #" + id);
            this.btnViewAttachment.setEnabled(true);
        }
    }

    @Override
    protected Record parseObject(Record old) throws Exception {
        BigDecimal amount;
        String amount_str;
        Record obj = new Record(old);
        obj.setDate(this.datePicker.getDate());
        if (this.cmbCategory.getSelectedItem() == null) {
            obj.setCategoryId(null);
        } else {
            obj.setCategoryId(((RecordCategory)this.cmbCategory.getSelectedItem()).getId());
        }
        if (this.txtNetAmount.getText().isBlank()) {
            obj.setNetAmount(null);
        } else {
            try {
                amount_str = this.txtNetAmount.getText().trim();
                amount = I18N.parseDecimal(amount_str);
                obj.setNetAmount(amount.setScale(2, RoundingMode.UNNECESSARY));
            }
            catch (ArithmeticException | ParseException e) {
                throw new RuntimeException(this.BUNDLE.getString("EditRecordDialog.messages.invalid_amount"), e);
            }
        }
        if (this.txtTotalAmount.getText().isBlank()) {
            obj.setTotalAmount(null);
        } else {
            try {
                amount_str = this.txtTotalAmount.getText().trim();
                amount = I18N.parseDecimal(amount_str);
                obj.setTotalAmount(amount.setScale(2, RoundingMode.UNNECESSARY));
            }
            catch (ArithmeticException | ParseException e) {
                throw new RuntimeException(this.BUNDLE.getString("EditRecordDialog.messages.invalid_amount"), e);
            }
        }
        BigDecimal computedTotal = this.computeTotalAmount();
        if (!computedTotal.equals(obj.getTotalAmount())) {
            EUtils.showWarningDialog(this, this.BUNDLE.getString("EditRecordDialog.messages.total_amount_mismatch"));
        }
        obj.setTaxEntries(this.tblTaxes.getData());
        obj.setDescription(this.textArea.getText());
        obj.setDocumentId(this.document == null ? null : this.document.getId());
        if (this.att_new != null) {
            obj.setAttachmentId(this.att_new.getId());
        }
        obj.validate();
        return obj;
    }

    public BigDecimal computeTotalAmount() {
        try {
            String amount_str = this.txtNetAmount.getText().trim();
            BigDecimal amount = I18N.parseDecimal(amount_str).setScale(2, RoundingMode.UNNECESSARY);
            for (RecordTaxEntry entry : this.tblTaxes.getData()) {
                amount = amount.add(entry.getAmount());
            }
            return amount;
        }
        catch (ArithmeticException | ParseException e) {
            throw new RuntimeException(this.BUNDLE.getString("EditRecordDialog.messages.invalid_amount"), e);
        }
    }

    @Override
    protected Record insert(Record obj) throws Exception {
        Record res = super.insert(obj);
        this.att_new = null;
        return res;
    }

    @Override
    protected Record update(Record old, Record obj, List<DataField<?>> diff) throws Exception {
        return EUtils.blocking((Component)this, blocking -> {
            Long att_old = old.getAttachmentId();
            Record res = super.update(blocking, old, obj, diff);
            if (att_old != null && this.att_new != null) {
                this.ctx.query(new Delete<Attachment>(Attachment.MODEL, Attachment.COL_ID.with(att_old)));
            }
            this.att_new = null;
            return res;
        });
    }

    private void initialize() {
        FlowLayout flowLayout = (FlowLayout)this.bottomPanel.getLayout();
        flowLayout.setAlignment(0);
        this.rootPanel.setLayout(new MigLayout("", "[][grow]", "[][][][][60px][grow][][]"));
        this.lblId = new JLabel(this.BUNDLE.getString("Record.ID") + ":");
        this.rootPanel.add((Component)this.lblId, "cell 0 0,alignx trailing");
        this.txtId = new ETextField();
        this.txtId.setEditable(false);
        this.rootPanel.add((Component)this.txtId, "cell 1 0,growx");
        this.txtId.setColumns(10);
        this.lblDate = new JLabel(this.BUNDLE.getString("Record.DATE") + ":");
        this.rootPanel.add((Component)this.lblDate, "cell 0 1,alignx trailing");
        this.datePicker = new DatePicker();
        this.datePicker.getSettings().setAllowEmptyDates(false);
        this.rootPanel.add((Component)this.datePicker, "cell 1 1,growx");
        this.lblCategory = new JLabel(this.BUNDLE.getString("Record.CATEGORY_ID") + ":");
        this.rootPanel.add((Component)this.lblCategory, "cell 0 2,alignx trailing");
        this.cmbCategory = new JComboBox();
        this.rootPanel.add(this.cmbCategory, "cell 1 2,growx");
        this.lblAmounts = new JLabel(this.BUNDLE.getString("Record.NET_AMOUNT") + " / " + this.BUNDLE.getString("Record.TOTAL_AMOUNT") + ":");
        this.rootPanel.add((Component)this.lblAmounts, "cell 0 3,alignx trailing");
        this.panel = new JPanel();
        this.rootPanel.add((Component)this.panel, "cell 1 3,grow");
        this.panel.setLayout(new MigLayout("", "0[grow][grow][]0", "0[]0"));
        this.txtNetAmount = new ETextField();
        this.panel.add((Component)this.txtNetAmount, "cell 0 0,growx");
        this.txtNetAmount.setColumns(10);
        this.txtTotalAmount = new ETextField();
        this.panel.add((Component)this.txtTotalAmount, "cell 1 0,growx");
        this.txtTotalAmount.setColumns(10);
        this.btnComputeTotalAmount = new JButton(this.BUNDLE.getString("EditRecordDialog.button.compute_total_amount"));
        this.panel.add((Component)this.btnComputeTotalAmount, "cell 2 0");
        this.lblTaxes = new JLabel(this.BUNDLE.getString("Record.TAXES") + ":");
        this.rootPanel.add((Component)this.lblTaxes, "cell 0 4,alignx trailing,aligny top");
        this.scrollPane = new JScrollPane();
        this.rootPanel.add((Component)this.scrollPane, "cell 1 4,grow");
        this.tblTaxes = new ETable();
        this.tblTaxes.setFillsViewportHeight(true);
        this.tblTaxes.setTableHeader(null);
        this.scrollPane.setViewportView(this.tblTaxes);
        this.lblDescription = new JLabel(this.BUNDLE.getString("Record.DESCRIPTION") + ":");
        this.rootPanel.add((Component)this.lblDescription, "cell 0 5,alignx trailing,aligny top");
        this.scrollPane_1 = new JScrollPane();
        this.scrollPane_1.setHorizontalScrollBarPolicy(31);
        this.rootPanel.add((Component)this.scrollPane_1, "cell 1 5,grow");
        this.textArea = new ETextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane_1.setViewportView(this.textArea);
        this.lblDocument = new JLabel(this.BUNDLE.getString("Record.DOCUMENT_ID") + ":");
        this.rootPanel.add((Component)this.lblDocument, "cell 0 6,alignx trailing");
        this.panel_1 = new JPanel();
        this.rootPanel.add((Component)this.panel_1, "cell 1 6,grow");
        this.panel_1.setLayout(new MigLayout("", "0[grow][][][]0", "0[]0"));
        this.txtDocument = new ETextField();
        this.panel_1.add((Component)this.txtDocument, "cell 0 0,growx");
        this.txtDocument.setEditable(false);
        this.btnShowDocument = new JButton(this.BUNDLE.getString("generic.button.show"));
        this.panel_1.add((Component)this.btnShowDocument, "cell 1 0");
        this.btnSearchDocument = new JButton(this.BUNDLE.getString("generic.button.search"));
        this.panel_1.add((Component)this.btnSearchDocument, "cell 2 0");
        this.btnResetDocument = new JButton(this.BUNDLE.getString("generic.button.reset"));
        this.panel_1.add((Component)this.btnResetDocument, "cell 3 0");
        this.lblAttachment = new JLabel(this.BUNDLE.getString("Record.ATTACHMENT_ID") + ":");
        this.rootPanel.add((Component)this.lblAttachment, "cell 0 7,alignx trailing");
        this.btnAttachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.bottomPanel.add(this.btnAttachments);
        this.panel_2 = new JPanel();
        this.rootPanel.add((Component)this.panel_2, "cell 1 7,grow");
        this.panel_2.setLayout(new MigLayout("", "0[grow][][]0", "0[]0"));
        this.txtAttachment = new JTextField();
        this.txtAttachment.setEditable(false);
        this.panel_2.add((Component)this.txtAttachment, "cell 0 0,growx");
        this.txtAttachment.setColumns(10);
        this.btnViewAttachment = new JButton(this.BUNDLE.getString("generic.button.show"));
        this.panel_2.add((Component)this.btnViewAttachment, "cell 1 0");
        this.btnNewAttachment = new JButton(this.BUNDLE.getString("generic.button.new"));
        this.panel_2.add((Component)this.btnNewAttachment, "cell 2 0");
    }
}

