/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.Role;
import de.inahware.edvj.data.AttributeSet;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextArea;
import de.inahware.edvj.gui.ETextField;
import java.awt.Component;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class EditRoleDialog
extends DefaultDataEditDialog<Role> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JScrollPane scrollPane;
    private ETextArea txtPermissions;
    private ETextField txtName;
    private JLabel lblName;
    private JLabel lblPermissions;

    private EditRoleDialog() {
        this.initialize();
    }

    public EditRoleDialog(ClientContext ctx, Role role) {
        this(ctx, role, null);
    }

    public EditRoleDialog(ClientContext ctx, Role role, Role placeholder) {
        super(Role.MODEL, ctx, role, placeholder);
        this.ctx = ctx;
        this.initialize();
        this.addEditable(this.txtName);
        this.addEditable(this.txtPermissions);
    }

    @Override
    protected void displayObject(Role obj) {
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("Role") + " - " + this.BUNDLE.getString("generic.title.new"));
        } else {
            this.setTitle(this.BUNDLE.getString("Role") + " - " + obj.getName());
        }
        this.txtName.setText(obj.getName());
        this.txtPermissions.setText(obj.getPermissions().getAllPaths().stream().collect(Collectors.joining("\n")));
        this.setEditable(this.ctx.getPermissions().contains(Role.MODEL.getName() + ".update"));
    }

    @Override
    protected Role parseObject(Role old) throws Exception {
        Role obj = new Role(old);
        obj.setName(this.txtName.getText());
        AttributeSet permissions = new AttributeSet();
        this.txtPermissions.getText().lines().forEach(l -> permissions.insert((String)l));
        obj.setPermissions(permissions);
        obj.validate();
        return obj;
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[][grow]", "[][grow]"));
        this.lblName = new JLabel(this.BUNDLE.getString("Role.NAME") + ":");
        this.rootPanel.add((Component)this.lblName, "cell 0 0,alignx trailing,aligny center");
        this.txtName = new ETextField();
        this.rootPanel.add((Component)this.txtName, "cell 1 0,growx");
        this.txtName.setColumns(10);
        this.lblPermissions = new JLabel(this.BUNDLE.getString("Role.PERMISSIONS") + ":");
        this.rootPanel.add((Component)this.lblPermissions, "cell 0 1,alignx trailing,aligny top");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.rootPanel.add((Component)this.scrollPane, "cell 1 1,grow");
        this.txtPermissions = new ETextArea();
        this.txtPermissions.setLineWrap(true);
        this.txtPermissions.setWrapStyleWord(true);
        this.scrollPane.setViewportView(this.txtPermissions);
    }
}

