/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ShowCountersDialog;
import de.inahware.dav.client.gui.ShowTaxRatesDialog;
import de.inahware.dav.models.Setting;
import de.inahware.dav.models.types.Salutation;
import de.inahware.dav.requests.GetSettings;
import de.inahware.dav.requests.SetSettings;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.EditDialog;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class EditSettingsDialog
extends EditDialog<Properties> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JLabel lblName;
    private ETextField txtName;
    private JLabel lblSalutation;
    private JPanel panel;
    private JComboBox<Salutation> cmbSalutation;
    private ETextField txtPrefix;
    private JLabel lblFirstName;
    private ETextField txtFirstName;
    private JLabel lblLastName;
    private ETextField txtLastName;
    private JLabel lblAddress1;
    private ETextField txtAddress1;
    private JLabel lblAddress2;
    private ETextField txtAddress2;
    private JLabel lblCountry;
    private JComboBox<String> cmbCountry;
    private JLabel lblPhone;
    private ETextField txtPhone;
    private JLabel lblFax;
    private ETextField txtFax;
    private JLabel lblEmail;
    private ETextField txtEmail;
    private JLabel lblSteuernummer;
    private ETextField txtSteuernummer;
    private JLabel lblVATNumber;
    private ETextField txtVATNumber;
    private JLabel lblCompanyOptions;
    private JCheckBox chkKleinunternehmer;
    private JLabel lblCompany;
    private JLabel lblIBAN;
    private JLabel lblBIC;
    private ETextField txtIBAN;
    private ETextField txtBIC;
    private JLabel lblInternet;
    private ETextField txtInternet;
    private JButton btnTaxRates;
    private JButton btnCounters;

    public EditSettingsDialog(ClientContext ctx, Properties settings) {
        super(settings);
        this.ctx = ctx;
        this.setTitle(this.BUNDLE.getString("Settings"));
        this.setWindowSize(480, 560);
        this.initialize();
        this.addEditable(this.txtName);
        this.addEditable(this.cmbSalutation);
        this.addEditable(this.txtPrefix);
        this.addEditable(this.txtFirstName);
        this.addEditable(this.txtLastName);
        this.addEditable(this.txtAddress1);
        this.addEditable(this.txtAddress2);
        this.addEditable(this.cmbCountry);
        this.addEditable(this.txtPhone);
        this.addEditable(this.txtFax);
        this.addEditable(this.txtEmail);
        this.addEditable(this.txtInternet);
        this.addEditable(this.txtSteuernummer);
        this.addEditable(this.txtVATNumber);
        this.addEditable(this.txtIBAN);
        this.addEditable(this.txtBIC);
        this.addEditable(this.chkKleinunternehmer);
        this.cmbSalutation.addItemListener(ev -> {
            boolean enabled = this.cmbSalutation.getSelectedItem() != null;
            this.txtPrefix.setEnabled(enabled);
            this.txtFirstName.setEnabled(enabled);
            this.txtLastName.setEnabled(enabled);
        });
        this.cmbSalutation.setRenderer(new FormattedListCellRenderer(type -> type == null ? "-" : ((Salutation)((Object)((Object)type))).getLocalizedString(this.BUNDLE)));
        this.cmbSalutation.addItem(null);
        for (Salutation s2 : Salutation.values()) {
            this.cmbSalutation.addItem(s2);
        }
        this.cmbSalutation.setSelectedIndex(1);
        this.cmbSalutation.setSelectedIndex(0);
        this.cmbCountry.setRenderer(new FormattedListCellRenderer(c -> c == null ? "-" : new Locale("", (String)c).getDisplayCountry()));
        Locale.getISOCountries(Locale.IsoCountryCode.PART1_ALPHA2).stream().sorted(Comparator.comparing(s -> new Locale("", (String)s).getDisplayCountry(), Collator.getInstance())).forEach(c -> this.cmbCountry.addItem((String)c));
        this.btnCounters.addActionListener(ev -> new ShowCountersDialog(ctx).openInnerModal(this));
        this.btnTaxRates.addActionListener(ev -> new ShowTaxRatesDialog(ctx).openInnerModal(this));
    }

    @Override
    protected void displayObject(Properties obj) {
        this.txtName.setText(obj.getProperty("company.name"));
        String s = obj.getProperty("company.salutation");
        this.cmbSalutation.setSelectedItem((Object)(s.isEmpty() ? null : Salutation.valueOf(s)));
        this.txtPrefix.setText(obj.getProperty("company.prefix"));
        this.txtFirstName.setText(obj.getProperty("company.firstName"));
        this.txtLastName.setText(obj.getProperty("company.lastName"));
        this.txtAddress1.setText(obj.getProperty("company.address1"));
        this.txtAddress2.setText(obj.getProperty("company.address2"));
        this.cmbCountry.setSelectedItem(obj.getProperty("company.country"));
        this.txtPhone.setText(obj.getProperty("company.phone"));
        this.txtFax.setText(obj.getProperty("company.fax"));
        this.txtEmail.setText(obj.getProperty("company.email"));
        this.txtInternet.setText(obj.getProperty("company.internet"));
        this.txtSteuernummer.setText(obj.getProperty("company.steuernummer"));
        this.txtVATNumber.setText(obj.getProperty("company.vat_number"));
        this.txtIBAN.setText(obj.getProperty("company.iban"));
        this.txtBIC.setText(obj.getProperty("company.bic"));
        this.chkKleinunternehmer.setSelected(Boolean.parseBoolean(obj.getProperty("company.kleinunternehmer")));
        this.setEditable(this.ctx.getPermissions().contains(Setting.MODEL.getName() + ".update"));
    }

    @Override
    protected Properties parseObject(Properties old) throws Exception {
        Properties obj = new Properties();
        obj.setProperty("company.name", this.txtName.getText());
        obj.setProperty("company.salutation", this.cmbSalutation.getSelectedItem() == null ? "" : this.cmbSalutation.getSelectedItem().toString());
        obj.setProperty("company.prefix", this.txtPrefix.getText());
        obj.setProperty("company.firstName", this.txtFirstName.getText());
        obj.setProperty("company.lastName", this.txtLastName.getText());
        obj.setProperty("company.address1", this.txtAddress1.getText());
        obj.setProperty("company.address2", this.txtAddress2.getText());
        obj.setProperty("company.country", (String)this.cmbCountry.getSelectedItem());
        obj.setProperty("company.phone", this.txtPhone.getText());
        obj.setProperty("company.fax", this.txtFax.getText());
        obj.setProperty("company.email", this.txtEmail.getText());
        obj.setProperty("company.internet", this.txtInternet.getText());
        obj.setProperty("company.steuernummer", this.txtSteuernummer.getText());
        obj.setProperty("company.vat_number", this.txtVATNumber.getText());
        obj.setProperty("company.iban", this.txtIBAN.getText());
        obj.setProperty("company.bic", this.txtBIC.getText());
        obj.setProperty("company.kleinunternehmer", "" + this.chkKleinunternehmer.isSelected());
        return obj;
    }

    @Override
    protected void saveObject(Properties old, Properties obj) throws Exception {
        Properties res = EUtils.blocking((Component)this, blocking -> {
            this.ctx.query(new SetSettings(obj));
            return this.ctx.query(new GetSettings());
        });
        this.objectSaved(res);
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[][grow]", "[][][][][][][][][20px][][][][][][][][][20px][]"));
        this.lblCompany = new JLabel(this.BUNDLE.getString("Setting.company"));
        this.lblCompany.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.lblCompany.setBackground(Color.LIGHT_GRAY);
        this.lblCompany.setOpaque(true);
        this.rootPanel.add((Component)this.lblCompany, "cell 0 0 2 1,growx");
        this.lblName = new JLabel(this.BUNDLE.getString("Setting.company.name") + ":");
        this.rootPanel.add((Component)this.lblName, "cell 0 1,alignx trailing");
        this.txtName = new ETextField();
        this.rootPanel.add((Component)this.txtName, "cell 1 1,growx");
        this.txtName.setColumns(10);
        this.lblSalutation = new JLabel(this.BUNDLE.getString("Setting.company.salutation") + ":");
        this.rootPanel.add((Component)this.lblSalutation, "cell 0 2,alignx trailing");
        this.panel = new JPanel();
        this.rootPanel.add((Component)this.panel, "flowx,cell 1 2,grow");
        this.panel.setLayout(new BorderLayout(0, 0));
        this.cmbSalutation = new JComboBox();
        this.panel.add(this.cmbSalutation, "West");
        this.txtPrefix = new ETextField();
        this.txtPrefix.setColumns(10);
        this.panel.add((Component)this.txtPrefix, "Center");
        this.lblFirstName = new JLabel(this.BUNDLE.getString("Setting.company.firstName") + ":");
        this.rootPanel.add((Component)this.lblFirstName, "cell 0 3,alignx trailing");
        this.txtFirstName = new ETextField();
        this.txtFirstName.setColumns(10);
        this.rootPanel.add((Component)this.txtFirstName, "cell 1 3,growx");
        this.lblLastName = new JLabel(this.BUNDLE.getString("Setting.company.lastName") + ":");
        this.rootPanel.add((Component)this.lblLastName, "cell 0 4,alignx trailing");
        this.txtLastName = new ETextField();
        this.txtLastName.setColumns(10);
        this.rootPanel.add((Component)this.txtLastName, "cell 1 4,growx");
        this.lblAddress1 = new JLabel(this.BUNDLE.getString("Setting.company.address1") + ":");
        this.rootPanel.add((Component)this.lblAddress1, "cell 0 5,alignx trailing");
        this.txtAddress1 = new ETextField();
        this.rootPanel.add((Component)this.txtAddress1, "cell 1 5,growx");
        this.txtAddress1.setColumns(10);
        this.lblAddress2 = new JLabel(this.BUNDLE.getString("Setting.company.address2") + ":");
        this.rootPanel.add((Component)this.lblAddress2, "cell 0 6,alignx trailing");
        this.txtAddress2 = new ETextField();
        this.rootPanel.add((Component)this.txtAddress2, "cell 1 6,growx");
        this.txtAddress2.setColumns(10);
        this.lblCountry = new JLabel(this.BUNDLE.getString("Setting.company.country") + ":");
        this.rootPanel.add((Component)this.lblCountry, "cell 0 7,alignx trailing");
        this.cmbCountry = new JComboBox();
        this.rootPanel.add(this.cmbCountry, "cell 1 7,growx");
        this.lblPhone = new JLabel(this.BUNDLE.getString("Setting.company.phone") + ":");
        this.rootPanel.add((Component)this.lblPhone, "cell 0 9,alignx trailing");
        this.txtPhone = new ETextField();
        this.rootPanel.add((Component)this.txtPhone, "cell 1 9,growx");
        this.txtPhone.setColumns(10);
        this.lblFax = new JLabel(this.BUNDLE.getString("Setting.company.fax") + ":");
        this.rootPanel.add((Component)this.lblFax, "cell 0 10,alignx trailing");
        this.txtFax = new ETextField();
        this.rootPanel.add((Component)this.txtFax, "cell 1 10,growx");
        this.txtFax.setColumns(10);
        this.lblEmail = new JLabel(this.BUNDLE.getString("Setting.company.email") + ":");
        this.rootPanel.add((Component)this.lblEmail, "cell 0 11,alignx trailing");
        this.txtEmail = new ETextField();
        this.rootPanel.add((Component)this.txtEmail, "cell 1 11,growx");
        this.txtEmail.setColumns(10);
        this.lblInternet = new JLabel(this.BUNDLE.getString("Setting.company.internet") + ":");
        this.rootPanel.add((Component)this.lblInternet, "cell 0 12,alignx trailing");
        this.txtInternet = new ETextField();
        this.rootPanel.add((Component)this.txtInternet, "cell 1 12,growx");
        this.txtInternet.setColumns(10);
        this.lblSteuernummer = new JLabel(this.BUNDLE.getString("Setting.company.steuernummer") + ":");
        this.rootPanel.add((Component)this.lblSteuernummer, "cell 0 13,alignx trailing");
        this.txtSteuernummer = new ETextField();
        this.rootPanel.add((Component)this.txtSteuernummer, "cell 1 13,growx");
        this.txtSteuernummer.setColumns(10);
        this.lblVATNumber = new JLabel(this.BUNDLE.getString("Setting.company.vat_number") + ":");
        this.rootPanel.add((Component)this.lblVATNumber, "cell 0 14,alignx trailing");
        this.txtVATNumber = new ETextField();
        this.rootPanel.add((Component)this.txtVATNumber, "cell 1 14,growx");
        this.txtVATNumber.setColumns(10);
        this.lblIBAN = new JLabel(this.BUNDLE.getString("Setting.company.iban") + ":");
        this.rootPanel.add((Component)this.lblIBAN, "cell 0 15,alignx trailing");
        this.txtIBAN = new ETextField();
        this.rootPanel.add((Component)this.txtIBAN, "cell 1 15,growx");
        this.txtIBAN.setColumns(10);
        this.lblBIC = new JLabel(this.BUNDLE.getString("Setting.company.bic") + ":");
        this.rootPanel.add((Component)this.lblBIC, "cell 0 16,alignx trailing");
        this.txtBIC = new ETextField();
        this.rootPanel.add((Component)this.txtBIC, "cell 1 16,growx");
        this.txtBIC.setColumns(10);
        this.lblCompanyOptions = new JLabel(this.BUNDLE.getString("Setting.options") + ":");
        this.rootPanel.add((Component)this.lblCompanyOptions, "cell 0 18,alignx right");
        this.chkKleinunternehmer = new JCheckBox(this.BUNDLE.getString("Setting.company.kleinunternehmer"));
        this.rootPanel.add((Component)this.chkKleinunternehmer, "cell 1 18");
        FlowLayout flowLayout = (FlowLayout)this.bottomPanel.getLayout();
        flowLayout.setAlignment(0);
        this.btnCounters = new JButton(this.BUNDLE.getString("Counters"));
        this.bottomPanel.add(this.btnCounters);
        this.btnTaxRates = new JButton(this.BUNDLE.getString("TaxRates"));
        this.bottomPanel.add(this.btnTaxRates);
    }
}

