/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import com.github.lgooddatepicker.components.DateTimePicker;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ShowAttachmentsDialog;
import de.inahware.dav.models.Task;
import de.inahware.dav.models.User;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextArea;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Select;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class EditTaskDialog
extends DefaultDataEditDialog<Task> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private User user;
    private JLabel lblId;
    private ETextField txtId;
    private JLabel lblUserId;
    private ETextField txtUserId;
    private JLabel lblCreatedAt;
    private ETextField txtCreatedAt;
    private JLabel lblTitle;
    private ETextField txtTitle;
    private JLabel lblDueAt;
    private DateTimePicker txtDueAt;
    private JLabel lblText;
    private JScrollPane scrollPane;
    private ETextArea textArea;
    private JLabel lblCompletedAt;
    private ETextField txtCompletedAt;
    private JButton btnAttachments;

    private EditTaskDialog() {
        this.initialize();
    }

    public EditTaskDialog(ClientContext ctx, Task task) {
        this(ctx, task, null);
    }

    public EditTaskDialog(ClientContext ctx, Task task, Task placeholder) {
        super(Task.MODEL, ctx, task, placeholder);
        this.ctx = ctx;
        this.setTitle(this.BUNDLE.getString("Task"));
        this.setWindowSize(480, 400);
        this.initialize();
        this.addEditable(this.txtTitle);
        this.addEditable(this.txtDueAt);
        this.addEditable(this.textArea);
        this.btnAttachments.addActionListener(e -> new ShowAttachmentsDialog(ctx, this.getTitle(), AttachmentObjectType.TASK, ((Task)this.getObject()).getId()).openInnerModal(this));
    }

    @Override
    public void displayObject(Task obj) throws Exception {
        EUtils.blocking((Component)this, blocking -> {
            this.user = this.ctx.query(new Select<User>(User.MODEL, User.COL_ID.with(obj.getUserId())));
        });
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("Task") + " " + this.BUNDLE.getString("generic.title.new"));
            this.txtId.setText(this.BUNDLE.getString("generic.text.generated"));
            this.txtCreatedAt.setText(this.BUNDLE.getString("generic.text.generated"));
            this.btnAttachments.setEnabled(false);
        } else {
            this.setTitle(this.BUNDLE.getString("Task") + " #" + obj.getId());
            this.txtId.setText(obj.getId().toString());
            this.txtCreatedAt.setText(I18N.formatDateTime(obj.getCreatedAt()));
            this.btnAttachments.setEnabled(true);
        }
        this.txtUserId.setText(this.user.getName());
        this.txtTitle.setText(obj.getTitle());
        this.txtDueAt.setDateTimePermissive(obj.getDueAt());
        this.textArea.setText(obj.getText());
        this.txtCompletedAt.setText(I18N.formatDateTime(obj.getCompletedAt(), "-"));
        this.setEditable(this.ctx.getPermissions().contains(Task.MODEL.getName() + ".update"));
    }

    @Override
    public Task parseObject(Task old) throws Exception {
        Task obj = new Task(old);
        obj.setUserId(this.user.getId());
        obj.setTitle(this.txtTitle.getText());
        obj.setDueAt(this.txtDueAt.getDateTimeStrict());
        obj.setText(this.textArea.getText());
        return obj;
    }

    private void initialize() {
        FlowLayout flowLayout = (FlowLayout)this.bottomPanel.getLayout();
        flowLayout.setAlignment(0);
        this.rootPanel.setLayout(new MigLayout("", "[][grow]", "[][][][][][grow][]"));
        this.lblId = new JLabel(this.BUNDLE.getString("Task.ID") + ":");
        this.rootPanel.add((Component)this.lblId, "cell 0 0,alignx trailing");
        this.txtId = new ETextField();
        this.txtId.setEditable(false);
        this.rootPanel.add((Component)this.txtId, "cell 1 0,growx");
        this.txtId.setColumns(10);
        this.lblUserId = new JLabel(this.BUNDLE.getString("Task.USER_ID") + ":");
        this.rootPanel.add((Component)this.lblUserId, "cell 0 1,alignx trailing");
        this.txtUserId = new ETextField();
        this.txtUserId.setEditable(false);
        this.rootPanel.add((Component)this.txtUserId, "cell 1 1,growx");
        this.txtUserId.setColumns(10);
        this.lblCreatedAt = new JLabel(this.BUNDLE.getString("Task.CREATED_AT") + ":");
        this.rootPanel.add((Component)this.lblCreatedAt, "cell 0 2,alignx trailing");
        this.txtCreatedAt = new ETextField();
        this.txtCreatedAt.setEditable(false);
        this.rootPanel.add((Component)this.txtCreatedAt, "cell 1 2,growx");
        this.txtCreatedAt.setColumns(10);
        this.lblTitle = new JLabel(this.BUNDLE.getString("Task.TITLE") + ":");
        this.rootPanel.add((Component)this.lblTitle, "cell 0 3,alignx trailing");
        this.txtTitle = new ETextField();
        this.rootPanel.add((Component)this.txtTitle, "cell 1 3,growx");
        this.txtTitle.setColumns(10);
        this.lblDueAt = new JLabel(this.BUNDLE.getString("Task.DUE_AT") + ":");
        this.rootPanel.add((Component)this.lblDueAt, "cell 0 4,alignx trailing");
        this.txtDueAt = new DateTimePicker();
        this.rootPanel.add((Component)this.txtDueAt, "cell 1 4,growx");
        this.lblText = new JLabel(this.BUNDLE.getString("Task.TEXT") + ":");
        this.rootPanel.add((Component)this.lblText, "cell 0 5,alignx trailing,aligny top");
        this.scrollPane = new JScrollPane();
        this.rootPanel.add((Component)this.scrollPane, "cell 1 5,grow");
        this.textArea = new ETextArea();
        this.scrollPane.setViewportView(this.textArea);
        this.lblCompletedAt = new JLabel(this.BUNDLE.getString("Task.COMPLETED_AT") + ":");
        this.rootPanel.add((Component)this.lblCompletedAt, "cell 0 6,alignx trailing");
        this.txtCompletedAt = new ETextField();
        this.rootPanel.add((Component)this.txtCompletedAt, "cell 1 6,growx");
        this.txtCompletedAt.setColumns(10);
        this.txtCompletedAt.setEditable(false);
        this.btnAttachments = new JButton(this.BUNDLE.getString("Attachments"));
        this.bottomPanel.add(this.btnAttachments);
    }
}

