/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.TaxRate;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextField;
import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class EditTaxRateDialog
extends DefaultDataEditDialog<TaxRate> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JLabel lblName;
    private ETextField txtName;
    private JLabel lblComment;
    private ETextField txtComment;
    private JLabel lblTax;
    private ETextField txtTax;

    private EditTaxRateDialog() {
        this.initialize();
    }

    public EditTaxRateDialog(ClientContext ctx, TaxRate obj) {
        this(ctx, obj, null);
    }

    public EditTaxRateDialog(ClientContext ctx, TaxRate obj, TaxRate placeholder) {
        super(TaxRate.MODEL, ctx, obj, placeholder);
        this.ctx = ctx;
        this.setWindowSize(480, 160);
        this.initialize();
        this.addEditable(this.txtName);
        this.addEditable(this.txtComment);
        if (obj != null) {
            this.txtTax.setEditable(false);
        } else {
            this.addEditable(this.txtTax);
        }
    }

    @Override
    protected void displayObject(TaxRate obj) throws Exception {
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("TaxRate") + " " + this.BUNDLE.getString("generic.title.new"));
        } else {
            this.setTitle(this.BUNDLE.getString("TaxRate") + " - " + obj.getName());
        }
        this.txtName.setText(obj.getName());
        this.txtComment.setText(obj.getComment());
        this.txtTax.setText(I18N.formatDecimal(obj.getRate()));
        this.setEditable(this.ctx.getPermissions().contains(TaxRate.MODEL.getName() + ".update"));
    }

    @Override
    protected TaxRate parseObject(TaxRate old) throws Exception {
        TaxRate obj = new TaxRate(old);
        obj.setName(this.txtName.getText());
        obj.setComment(this.txtComment.getText());
        try {
            String tax_str = this.txtTax.getText().trim();
            BigDecimal tax = I18N.parseDecimal(tax_str);
            obj.setRate(tax.setScale(2, RoundingMode.UNNECESSARY));
        }
        catch (ArithmeticException | ParseException e) {
            throw new RuntimeException(this.BUNDLE.getString("generic.messages.invalid_taxrate"), e);
        }
        obj.validate();
        return obj;
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[][grow]", "[][][]"));
        this.lblName = new JLabel(this.BUNDLE.getString("TaxRate.NAME") + ":");
        this.rootPanel.add((Component)this.lblName, "cell 0 0,alignx trailing");
        this.txtName = new ETextField();
        this.rootPanel.add((Component)this.txtName, "cell 1 0,growx");
        this.txtName.setColumns(10);
        this.lblComment = new JLabel(this.BUNDLE.getString("TaxRate.COMMENT") + ":");
        this.rootPanel.add((Component)this.lblComment, "cell 0 1,alignx trailing");
        this.txtComment = new ETextField();
        this.rootPanel.add((Component)this.txtComment, "cell 1 1,growx");
        this.txtComment.setColumns(10);
        this.lblTax = new JLabel(this.BUNDLE.getString("TaxRate.RATE") + ":");
        this.rootPanel.add((Component)this.lblTax, "cell 0 2,alignx trailing");
        this.txtTax = new ETextField();
        this.rootPanel.add((Component)this.txtTax, "cell 1 2,growx");
        this.txtTax.setColumns(10);
    }
}

