/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.Text;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextArea;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class EditTextDialog
extends DefaultDataEditDialog<Text> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JScrollPane scrollPane;
    private ETextArea txtText;

    private EditTextDialog() {
        this.initialize();
    }

    public EditTextDialog(ClientContext ctx, Text text) {
        super(Text.MODEL, ctx, text);
        this.ctx = ctx;
        this.initialize();
        this.addEditable(this.txtText);
    }

    @Override
    protected void displayObject(Text obj) {
        this.setTitle(this.BUNDLE.getString("Text") + " - " + this.BUNDLE.getString("Texts." + obj.getName()));
        this.txtText.setText(obj.getText());
        this.setEditable(this.ctx.getPermissions().contains(Text.MODEL.getName() + ".update"));
    }

    @Override
    protected Text parseObject(Text old) throws Exception {
        Text obj = new Text(old);
        obj.setText(this.txtText.getText());
        obj.validate();
        return obj;
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.rootPanel.add((Component)this.scrollPane, "cell 0 0,grow");
        this.txtText = new ETextArea();
        this.txtText.setLineWrap(true);
        this.txtText.setWrapStyleWord(true);
        this.scrollPane.setViewportView(this.txtText);
    }
}

