/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.SetPasswordDialog;
import de.inahware.dav.client.gui.ShowUserRolesDialog;
import de.inahware.dav.models.CloudserverInstanceView;
import de.inahware.dav.models.User;
import de.inahware.dav.models.UserAuthCloudserver;
import de.inahware.dav.requests.UserHasPassword;
import de.inahware.dav.requests.UserSetPassword;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.Insert;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.SelectAll;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class EditUserDialog
extends DefaultDataEditDialog<User> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JLabel lblId;
    private ETextField txtId;
    private JLabel lblUsername;
    private ETextField txtUsername;
    private JLabel lblName;
    private ETextField txtName;
    private JLabel lblLocked;
    private JCheckBox chkLocked;
    private JSeparator separator;
    private JLabel lblPassword;
    private JTextField txtPassword;
    private JPanel panel;
    private JButton btnChangePassword;
    private JButton btnResetPassword;
    private JButton btnRandomPassword;
    private JSeparator separator_1;
    private JLabel lblCloudserver;
    private JTextField txtCloudserver;
    private JPanel panel_1;
    private JButton btnSelectCloudserver;
    private JButton btnResetCloudserver;
    private JButton btnEditRoles;

    private EditUserDialog() {
        this.initialize();
    }

    public EditUserDialog(ClientContext ctx, User user) throws Exception {
        this(ctx, user, null);
    }

    public EditUserDialog(ClientContext ctx, User user, User placeholder) throws Exception {
        super(User.MODEL, ctx, user, placeholder);
        this.ctx = ctx;
        this.setWindowSize(640, 360);
        this.initialize();
        this.setEditable(ctx.getPermissions().contains(User.MODEL.getName() + ".update"));
        this.addEditable(this.txtUsername);
        this.addEditable(this.txtName);
        this.addEditable(this.chkLocked);
        this.addReadOnly(this.btnChangePassword);
        this.addReadOnly(this.btnRandomPassword);
        this.addReadOnly(this.btnResetPassword);
        this.addReadOnly(this.btnSelectCloudserver);
        this.addReadOnly(this.btnResetCloudserver);
        this.addReadOnly(this.btnEditRoles);
        this.btnChangePassword.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            char[] pw = (char[])new SetPasswordDialog().inputDialog(this);
            if (pw == null) {
                return;
            }
            EUtils.blocking((Component)this, blocking -> ctx.query(new UserSetPassword(((User)this.getObject()).getId(), pw)));
            this.displayObject((User)this.getObject());
        }));
        this.btnRandomPassword.addActionListener(e -> {});
        this.btnResetPassword.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("EditUserDialog.messages.confirm_reset_password"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            EUtils.blocking((Component)this, blocking -> ctx.query(new UserSetPassword(((User)this.getObject()).getId(), null)));
            this.displayObject((User)this.getObject());
        }));
        this.btnSelectCloudserver.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            CloudserverInstanceView instance;
            List instances = EUtils.blocking((Component)this, blocking -> (List)((Object)ctx.query(new SelectAll<CloudserverInstanceView>(CloudserverInstanceView.MODEL))));
            if (instances.isEmpty()) {
                throw new RuntimeException("no cloudserver instances");
            }
            if (instances.size() == 1) {
                instance = (CloudserverInstanceView)instances.get(0);
            } else {
                JComboBox<Object> cmb = new JComboBox<Object>();
                for (CloudserverInstanceView i : instances) {
                    cmb.addItem(i);
                }
                cmb.setSelectedIndex(0);
                cmb.setRenderer(new FormattedListCellRenderer(type -> ((CloudserverInstanceView)type).getInstanceId()));
                int answer = JOptionPane.showConfirmDialog(this, cmb, "select cloudserver instance", 2, 3);
                if (answer != 0) {
                    return;
                }
                instance = (CloudserverInstanceView)cmb.getSelectedItem();
            }
            String input = JOptionPane.showInputDialog(this, "input user id", this.getTitle(), 3);
            if (input == null) {
                return;
            }
            long userId = Long.parseLong(input);
            EUtils.blocking((Component)this, blocking -> {
                ctx.query(new Delete<UserAuthCloudserver>(UserAuthCloudserver.MODEL, UserAuthCloudserver.COL_USER_ID.with(((User)this.getObject()).getId())));
                ctx.query(new Insert<UserAuthCloudserver>(UserAuthCloudserver.MODEL, new UserAuthCloudserver(((User)this.getObject()).getId(), instance.getId(), userId)));
            });
            this.displayObject((User)this.getObject());
        }));
        this.btnResetCloudserver.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            int answer = JOptionPane.showConfirmDialog(this, "confirm?", this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<UserAuthCloudserver>(UserAuthCloudserver.MODEL, UserAuthCloudserver.COL_USER_ID.with(((User)this.getObject()).getId()))));
            this.displayObject((User)this.getObject());
        }));
        this.btnEditRoles.addActionListener(e -> EUtils.catchWithDialog(this, () -> new ShowUserRolesDialog(this, ctx, (User)this.getObject()).openInnerModal(this)));
    }

    @Override
    protected void displayObject(User obj) throws Exception {
        if (obj.getId() == null) {
            this.setTitle(this.BUNDLE.getString("User") + " " + this.BUNDLE.getString("generic.title.new"));
            this.txtId.setText(this.BUNDLE.getString("generic.text.generated"));
        } else {
            this.setTitle(this.BUNDLE.getString("User") + " #" + obj.getId() + " (" + obj.getUsername() + "; " + obj.getName() + ")");
            this.txtId.setText(obj.getId().toString());
            if (obj.getId().equals(1L)) {
                this.setEnabled(this.chkLocked, false);
                this.setEnabled(this.btnResetPassword, false);
                this.setEnabled(this.btnEditRoles, false);
            }
        }
        this.txtUsername.setText(obj.getUsername());
        this.txtName.setText(obj.getName());
        this.chkLocked.setSelected(obj.isLocked());
        this.setEditable(this.ctx.getPermissions().contains(User.MODEL.getName() + ".update"));
        EUtils.blocking((Component)this, blocking -> {
            if (obj.getId() != null) {
                boolean has_password = this.ctx.query(new UserHasPassword(obj.getId()));
                if (has_password) {
                    this.txtPassword.setText(this.BUNDLE.getString("EditUserDialog.text.password"));
                } else {
                    this.txtPassword.setText(this.BUNDLE.getString("EditUserDialog.text.no_password"));
                }
                UserAuthCloudserver cloudserverAuth = this.ctx.query(new Select<UserAuthCloudserver>(UserAuthCloudserver.MODEL, UserAuthCloudserver.COL_USER_ID.with(obj.getId())));
                if (cloudserverAuth != null) {
                    CloudserverInstanceView instance = this.ctx.query(new Select<CloudserverInstanceView>(CloudserverInstanceView.MODEL, CloudserverInstanceView.COL_ID.with(cloudserverAuth.getInstanceId())));
                    this.txtCloudserver.setText(instance.getInstanceId() + ": " + cloudserverAuth.getInstanceUserId());
                } else {
                    this.txtCloudserver.setText("-");
                }
            }
        });
    }

    @Override
    protected User parseObject(User old) throws Exception {
        User obj = new User(old);
        obj.setUsername(this.txtUsername.getText().trim());
        obj.setName(this.txtName.getText().trim());
        obj.setLocked(this.chkLocked.isSelected());
        obj.validate();
        return obj;
    }

    private void initialize() {
        FlowLayout flowLayout = (FlowLayout)this.bottomPanel.getLayout();
        flowLayout.setAlignment(0);
        this.rootPanel.setLayout(new MigLayout("", "[][381.00,grow]", "[][][][][][][][][][]"));
        this.lblId = new JLabel(this.BUNDLE.getString("User.ID") + ":");
        this.rootPanel.add((Component)this.lblId, "cell 0 0,alignx trailing");
        this.txtId = new ETextField();
        this.rootPanel.add((Component)this.txtId, "cell 1 0,growx");
        this.txtId.setColumns(10);
        this.txtId.setEditable(false);
        this.lblUsername = new JLabel(this.BUNDLE.getString("User.USERNAME") + ":");
        this.rootPanel.add((Component)this.lblUsername, "cell 0 1,alignx trailing");
        this.txtUsername = new ETextField();
        this.rootPanel.add((Component)this.txtUsername, "cell 1 1,growx");
        this.txtUsername.setColumns(10);
        this.lblName = new JLabel(this.BUNDLE.getString("User.NAME") + ":");
        this.rootPanel.add((Component)this.lblName, "cell 0 2,alignx trailing");
        this.txtName = new ETextField();
        this.rootPanel.add((Component)this.txtName, "cell 1 2,growx");
        this.txtName.setColumns(10);
        this.lblLocked = new JLabel(this.BUNDLE.getString("User.LOCKED") + ":");
        this.rootPanel.add((Component)this.lblLocked, "cell 0 3,alignx trailing");
        this.chkLocked = new JCheckBox(this.BUNDLE.getString("User.LOCKED"));
        this.rootPanel.add((Component)this.chkLocked, "cell 1 3");
        this.separator = new JSeparator();
        this.rootPanel.add((Component)this.separator, "cell 0 4 2 1,grow");
        this.lblPassword = new JLabel(this.BUNDLE.getString("User.PASSWORD") + ":");
        this.rootPanel.add((Component)this.lblPassword, "cell 0 5,alignx trailing");
        this.txtPassword = new JTextField();
        this.txtPassword.setEditable(false);
        this.rootPanel.add((Component)this.txtPassword, "cell 1 5,growx");
        this.txtPassword.setColumns(10);
        this.panel = new JPanel();
        this.rootPanel.add((Component)this.panel, "cell 1 6,growx");
        this.panel.setLayout(new FlowLayout(3, 5, 5));
        this.btnChangePassword = new JButton(this.BUNDLE.getString("EditUserDialog.button.changePassword"));
        this.panel.add(this.btnChangePassword);
        this.btnRandomPassword = new JButton(this.BUNDLE.getString("EditUserDialog.button.randomPassword"));
        this.panel.add(this.btnRandomPassword);
        this.btnResetPassword = new JButton(this.BUNDLE.getString("EditUserDialog.button.resetPassword"));
        this.panel.add(this.btnResetPassword);
        this.btnEditRoles = new JButton(this.BUNDLE.getString("Roles"));
        this.bottomPanel.add(this.btnEditRoles);
        this.separator_1 = new JSeparator();
        this.rootPanel.add((Component)this.separator_1, "cell 0 7 2 1,grow");
        this.lblCloudserver = new JLabel("Cloudserver:");
        this.rootPanel.add((Component)this.lblCloudserver, "cell 0 8,alignx trailing");
        this.txtCloudserver = new JTextField();
        this.txtCloudserver.setEditable(false);
        this.txtCloudserver.setColumns(10);
        this.rootPanel.add((Component)this.txtCloudserver, "cell 1 8,growx");
        this.panel_1 = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)this.panel_1.getLayout();
        flowLayout_1.setAlignment(3);
        this.rootPanel.add((Component)this.panel_1, "cell 1 9,grow");
        this.btnSelectCloudserver = new JButton(this.BUNDLE.getString("generic.button.select"));
        this.panel_1.add(this.btnSelectCloudserver);
        this.btnResetCloudserver = new JButton(this.BUNDLE.getString("generic.button.reset"));
        this.panel_1.add(this.btnResetCloudserver);
    }
}

