/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ExportDialog;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.ArticleGroup;
import de.inahware.dav.models.TaxRate;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.SelectAll;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class ExportArticlesDialog
extends ExportDialog<Article> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private Map<Long, ArticleGroup> groups;
    private Map<Long, TaxRate> taxRate_by_id;

    public ExportArticlesDialog(Component parent, ClientContext ctx) throws Exception {
        super(ctx, Article.MODEL);
        this.setSize(1280, 720);
        EUtils.blocking(parent, blocking -> {
            this.groups = ArticleGroup.getArticleGroupMap(ctx);
            List rates = (List)((Object)ctx.query(new SelectAll<TaxRate>(TaxRate.MODEL)));
            this.taxRate_by_id = new HashMap<Long, TaxRate>();
            for (TaxRate next : rates) {
                this.taxRate_by_id.put(next.getId(), next);
            }
        });
        this.addColumnType(Article.COL_ID, false);
        this.addColumnType(Article.COL_NUMBER, true);
        this.addColumnType(Article.COL_ARTICLE_GROUP_ID.getLocalizedString(Article.MODEL, this.BUNDLE), true, obj -> ArticleGroup.getArticleGroupPath(this.BUNDLE, this.groups, obj.getArticleGroupId()));
        this.addColumnType(Article.COL_TITLE, true);
        this.addColumnType(Article.COL_PRICES.getLocalizedString(Article.MODEL, this.BUNDLE), true, obj -> obj.getPriceList().stream().map(p -> I18N.formatDecimal(p.price) + (String)(p.comment.isEmpty() ? "" : " " + p.comment)).collect(Collectors.joining("; ")));
        this.addColumnType(Article.COL_UNIT, true);
        this.addColumnType(Article.COL_TAX_RATE_ID.getLocalizedString(Article.MODEL, this.BUNDLE), true, obj -> this.taxRate_by_id.get(obj.getTaxRateId()).getName());
        this.addColumnType(Article.COL_DESCRIPTION, true);
        this.getTablePanel().addSearchColumnLong(Article.COL_ID);
        this.getTablePanel().addSearchColumnString(Article.COL_NUMBER);
        this.getTablePanel().addSearchColumnString(Article.COL_TITLE);
        this.getTablePanel().addSearchColumnString(Article.COL_UNIT);
        this.getTablePanel().addSearchColumnString(Article.COL_DESCRIPTION);
    }
}

