/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ExportDialog;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.types.Contact;
import de.inahware.dav.models.types.ContactType;
import de.inahware.dav.models.types.Salutation;
import java.util.ResourceBundle;

public class ExportCustomersDialog
extends ExportDialog<Customer> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ExportCustomersDialog(ClientContext ctx) throws Exception {
        super(ctx, Customer.MODEL);
        this.setSize(1280, 720);
        this.addColumnType(Customer.COL_ID, true);
        this.addColumnType(Customer.COL_PREFIX, true);
        this.addColumnType(Customer.COL_LAST_NAME, true);
        this.addColumnType(Customer.COL_FIRST_NAME, true);
        this.addColumnType(Customer.COL_COMPANY, true);
        for (ContactType contactType : ContactType.values()) {
            this.addColumnType(contactType.getLocalizedString(this.BUNDLE), false, obj -> {
                Contact c = obj.getContactList().stream().filter(c2 -> c2.type == type).findAny().orElse(null);
                return c == null ? "" : c.value;
            });
        }
        this.getTablePanel().addSearchColumnLong(Customer.COL_ID);
        this.getTablePanel().addSearchColumnString(Customer.COL_PREFIX);
        this.getTablePanel().addSearchColumnString(Customer.COL_LAST_NAME);
        this.getTablePanel().addSearchColumnString(Customer.COL_FIRST_NAME);
        this.getTablePanel().addSearchColumnString(Customer.COL_COMPANY);
        for (Enum enum_ : Salutation.values()) {
            this.getTablePanel().addSearchKeyword(((Salutation)enum_).getLocalizedString(this.BUNDLE), Customer.COL_SALUTATION.with((Salutation)enum_));
        }
    }
}

