/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.gui.DataTablePanel;
import de.inahware.edvj.gui.EFileChooser;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.ETable;
import de.inahware.edvj.gui.ETableModel;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.gui.FormattedTableCellRenderer;
import de.inahware.edvj.query.SelectAll;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.function.Function;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public abstract class ExportDialog<T extends DataObject>
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private DataModel<T> model;
    private JSplitPane splitPane;
    private JPanel panel_left;
    private JLabel lblColumns;
    private JScrollPane scrollPane;
    private ETable<ColumnEntry> tblColumns;
    private JComboBox<ColumnType> cmbColumnTypes;
    private JPanel panel;
    private JButton btnRemoveColumn;
    private JButton btnAddColumn;
    private JPanel panel_right;
    private DataTablePanel<T> tablePanel;
    private JPanel panel_bottom;
    private JButton btnCancel;
    private JButton btnExport;

    public ExportDialog(ClientContext ctx, DataModel<T> model) {
        this.ctx = ctx;
        this.model = model;
        this.setTitle(this.BUNDLE.getString(model.getName()) + " - " + this.BUNDLE.getString("ExportDialog.title"));
        this.initialize();
        this.tblColumns.addColumn(this.BUNDLE.getString("ExportDialog.columns.type"), ColumnType.class, entry -> entry.type, (entry, value) -> {
            entry.type = (ColumnType)value;
        });
        this.tblColumns.addColumn(this.BUNDLE.getString("ExportDialog.columns.title"), entry -> entry.title, (entry, value) -> {
            entry.title = value.toString();
        });
        this.tblColumns.setDefaultRenderer(ColumnType.class, new FormattedTableCellRenderer(type -> ((ColumnType)type).name));
        this.cmbColumnTypes = new JComboBox();
        this.cmbColumnTypes.setRenderer(new FormattedListCellRenderer(type -> ((ColumnType)type).name));
        this.tblColumns.setDefaultEditor(ColumnType.class, new DefaultCellEditor(this.cmbColumnTypes));
        ((AbstractTableModel)this.tblColumns.getModel()).addTableModelListener(ev -> this.refreshColumns());
        this.btnAddColumn.addActionListener(ev -> {
            int answer;
            JComboBox<Object> cmbPosition = new JComboBox<Object>();
            cmbPosition.setRenderer(new FormattedListCellRenderer(i -> {
                int idx = (Integer)i;
                if (idx == 0) {
                    return this.BUNDLE.getString("ExportDialog.label.pos_beginning");
                }
                return this.BUNDLE.getString("ExportDialog.label.pos_after") + " " + this.tblColumns.getData().get(idx - 1).getTitle();
            }));
            for (int i2 = 0; i2 <= this.tblColumns.getData().size(); ++i2) {
                cmbPosition.addItem(i2);
            }
            if (this.tblColumns.getSelectedRow() >= 0) {
                cmbPosition.setSelectedIndex(this.tblColumns.getSelectedRow() + 1);
            }
            if ((answer = JOptionPane.showConfirmDialog(this, cmbPosition, this.BUNDLE.getString("ExportDialog.messages.select_position"), 2, 3)) != 0) {
                return;
            }
            answer = JOptionPane.showConfirmDialog(this, this.cmbColumnTypes, this.BUNDLE.getString("ExportDialog.messages.select_type"), 2, 3);
            if (answer != 0) {
                return;
            }
            this.addColumn((int)((Integer)cmbPosition.getSelectedItem()), (ColumnType)this.cmbColumnTypes.getSelectedItem());
        });
        this.tblColumns.connect(this.btnRemoveColumn, e -> e != null, e -> ((ETableModel)this.tblColumns.getModel()).deleteRow(this.tblColumns.getSelectedRow()));
        this.btnExport.addActionListener(ev -> {
            EFileChooser dialog = new EFileChooser();
            dialog.setDialogTitle(this.getTitle());
            dialog.resetChoosableFileFilters();
            dialog.addChoosableFileFilter(new FileNameExtensionFilter("CSV file", "csv"));
            dialog.setSelectedFile(Path.of(this.BUNDLE.getString(model.getName()) + ".csv", new String[0]).toFile());
            int answer = dialog.showSaveDialog(this);
            if (answer != 0) {
                return;
            }
            EUtils.blockingCatchWithDialog(this, blocking -> {
                try (BufferedWriter output = Files.newBufferedWriter(dialog.getSelectedFile().toPath(), new OpenOption[0]);
                     CSVPrinter csv = new CSVPrinter(output, CSVFormat.DEFAULT);){
                    csv.printRecord(() -> this.tblColumns.getData().stream().map(ColumnEntry::getTitle).iterator());
                    for (DataObject obj : (ArrayList)ctx.query(new SelectAll(model, this.tablePanel.getSearchFilter()))) {
                        csv.printRecord(() -> this.tblColumns.getData().stream().map(col -> col.apply(obj)).iterator());
                    }
                }
            });
        });
        this.btnCancel.addActionListener(ev -> this.close());
    }

    public DataTablePanel<T> getTablePanel() {
        return this.tablePanel;
    }

    protected void addColumnType(DataColumn<?> col) {
        this.addColumnType(col.getName(), false, obj -> obj.get(col));
    }

    protected void addColumnType(DataColumn<?> col, boolean add) {
        this.addColumnType(col.getName(), add, obj -> obj.get(col));
    }

    protected void addColumnType(String name, Function<T, Object> fn) {
        this.addColumnType(name, false, fn);
    }

    protected void addColumnType(String name, boolean add, Function<T, Object> fn) {
        ColumnType type = new ColumnType(name, fn);
        this.cmbColumnTypes.addItem(type);
        if (add) {
            this.addColumn(this.tblColumns.getRowCount(), type);
        }
    }

    private void addColumn(int idx, ColumnType type) {
        this.addColumn(idx, new ColumnEntry(type, ""));
    }

    private void addColumn(int idx, ColumnEntry col) {
        ((ETableModel)this.tblColumns.getModel()).addRow(idx, col);
        this.refreshColumns();
    }

    private void refreshColumns() {
        this.tablePanel.resetColumns();
        for (ColumnEntry col : this.tblColumns.getData()) {
            this.tablePanel.addColumn(col.getTitle(), col.type.fn);
        }
    }

    private void initialize() {
        this.setSize(800, 450);
        this.splitPane = new JSplitPane();
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setDividerLocation(300);
        this.panel_left = new JPanel();
        this.splitPane.setLeftComponent(this.panel_left);
        this.panel_left.setLayout(new MigLayout("", "[grow]", "[][grow][]"));
        this.lblColumns = new JLabel(this.BUNDLE.getString("ExportDialog.label.columns"));
        this.panel_left.add((Component)this.lblColumns, "cell 0 0");
        this.scrollPane = new JScrollPane();
        this.panel_left.add((Component)this.scrollPane, "cell 0 1,grow");
        this.tblColumns = new ETable();
        this.scrollPane.setViewportView(this.tblColumns);
        this.tblColumns.setFillsViewportHeight(true);
        this.panel = new JPanel();
        FlowLayout fl_panel = (FlowLayout)this.panel.getLayout();
        fl_panel.setAlignment(2);
        this.panel_left.add((Component)this.panel, "cell 0 2,grow");
        this.btnAddColumn = new JButton(this.BUNDLE.getString("ExportDialog.button.add"));
        this.panel.add(this.btnAddColumn);
        this.btnRemoveColumn = new JButton(this.BUNDLE.getString("ExportDialog.button.remove"));
        this.panel.add(this.btnRemoveColumn);
        this.panel_right = new JPanel();
        this.splitPane.setRightComponent(this.panel_right);
        this.panel_right.setLayout(new MigLayout("", "[grow]", "[grow]"));
        this.tablePanel = new DataTablePanel<T>(this.model, this.ctx.getClient());
        this.panel_right.add(this.tablePanel, "cell 0 0,grow");
        this.panel_bottom = new JPanel();
        FlowLayout fl_panel_bottom = (FlowLayout)this.panel_bottom.getLayout();
        fl_panel_bottom.setAlignment(2);
        this.add((Component)this.panel_bottom, "South");
        this.btnExport = new JButton(this.BUNDLE.getString("ExportDialog.button.export"));
        this.panel_bottom.add(this.btnExport);
        this.btnCancel = new JButton(this.BUNDLE.getString("edvj.generic.button.close"));
        this.panel_bottom.add(this.btnCancel);
        this.tablePanel.refresh();
    }

    private class ColumnType {
        public String name;
        public Function<T, Object> fn;

        public ColumnType(String name, Function<T, Object> fn) {
            this.name = name;
            this.fn = fn;
        }
    }

    private class ColumnEntry {
        public ColumnType type;
        public String title;

        public ColumnEntry(ColumnType type, String title) {
            this.type = type;
            this.title = title;
        }

        public String getTitle() {
            return this.title.isEmpty() ? this.type.name : this.title;
        }

        public Object apply(T obj) {
            return this.type.fn.apply(obj);
        }
    }
}

