/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import com.github.lgooddatepicker.components.DatePicker;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditAttachmentDialogs;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.models.Document;
import de.inahware.edvj.gui.EFileChooser;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.SelectAll;
import de.inahware.edvj.query.filter.And;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.query.filter.Span;
import java.awt.Component;
import java.awt.FlowLayout;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;

public class ExportDocumentsDialog
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private String title;
    private Filter filter;
    private JPanel panel;
    private JLabel lblFrom;
    private JLabel lblUntil;
    private DatePicker dateFrom;
    private DatePicker dateUntil;
    private JLabel lblOptions;
    private JCheckBox chkExportTable;
    private JLabel lblExportType;
    private JRadioButton rdExportSinglePDF;
    private JRadioButton rdExportArchive;
    private JRadioButton rdExportFolder;
    private JPanel panel_bottom;
    private JButton btnCancel;
    private JButton btnExport;

    public ExportDocumentsDialog(ClientContext ctx, String title, Filter filter) {
        this.ctx = ctx;
        this.title = title;
        this.filter = filter;
        this.setTitle(this.BUNDLE.getString("generic.title.export") + " - " + title);
        this.setPacking(true);
        this.initialize();
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdExportSinglePDF);
        group.add(this.rdExportArchive);
        group.add(this.rdExportFolder);
        this.btnExport.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            if (this.rdExportSinglePDF.isSelected()) {
                this.exportPDF();
            } else if (this.rdExportArchive.isSelected()) {
                this.exportArchive();
            } else if (this.rdExportFolder.isSelected()) {
                this.exportFolder();
            }
        }));
        this.btnCancel.addActionListener(ev -> this.close());
    }

    private void exportPDF() throws Exception {
        EFileChooser dialog = new EFileChooser();
        dialog.setDialogTitle(this.BUNDLE.getString("generic.button.export"));
        dialog.resetChoosableFileFilters();
        dialog.addFilter("PDF file", "pdf");
        dialog.setSelectedFile(Path.of(this.title + ".pdf", new String[0]).toFile());
        Path path = dialog.save(this);
        if (path == null) {
            return;
        }
        EUtils.blocking((Component)this, blocking -> {
            ArrayList documents = (ArrayList)((Object)this.ctx.query(new SelectAll<Document>(Document.MODEL, new And(this.filter, new Span<LocalDate>(Document.COL_DATE, this.dateFrom.getDate(), true, this.dateUntil.getDate(), true)))));
            Path tmp = Files.createTempDirectory("inahware-dav-export-", new FileAttribute[0]);
            try {
                PDFMergerUtility merger = new PDFMergerUtility();
                merger.setDestinationFileName(path.toString());
                for (int i = 0; i < documents.size(); ++i) {
                    Document document = (Document)documents.get(i);
                    int num = i;
                    SwingUtilities.invokeLater(() -> blocking.setStatus("Exporting... (" + (num + 1) + " / " + documents.size() + ")"));
                    if (document.getAttachmentId() == null) continue;
                    Attachment attachment = this.ctx.query(new Select<Attachment>(Attachment.MODEL, Attachment.COL_ID.with(document.getAttachmentId())));
                    Path dl = EditAttachmentDialogs.downloadInner(blocking, this.ctx, attachment);
                    Path file = tmp.resolve(attachment.getFilename());
                    Files.move(dl, file, new CopyOption[0]);
                    merger.addSource(file.toFile());
                }
                merger.mergeDocuments(MemoryUsageSetting.setupTempFileOnly());
            }
            finally {
                FileUtils.deleteDirectory(tmp.toFile());
            }
            return null;
        });
        JOptionPane.showMessageDialog(this, "export complete", this.getTitle(), 1);
        this.close();
    }

    private void exportArchive() throws Exception {
        EFileChooser dialog = new EFileChooser();
        dialog.setDialogTitle(this.BUNDLE.getString("generic.button.export"));
        dialog.resetChoosableFileFilters();
        dialog.addFilter("Zip file", "zip");
        dialog.setSelectedFile(Path.of(this.title + ".zip", new String[0]).toFile());
        Path path = dialog.save(this);
        if (path == null) {
            return;
        }
        EUtils.blocking((Component)this, blocking -> {
            ArrayList orders = (ArrayList)((Object)this.ctx.query(new SelectAll<Document>(Document.MODEL, new And(this.filter, new Span<LocalDate>(Document.COL_DATE, this.dateFrom.getDate(), true, this.dateUntil.getDate(), true)))));
            try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(path, new OpenOption[0]);){
                for (int i = 0; i < orders.size(); ++i) {
                    Document document = (Document)orders.get(i);
                    int num = i;
                    SwingUtilities.invokeLater(() -> blocking.setStatus("Exporting... (" + (num + 1) + " / " + orders.size() + ")"));
                    if (document.getAttachmentId() == null) continue;
                    Attachment attachment = this.ctx.query(new Select<Attachment>(Attachment.MODEL, Attachment.COL_ID.with(document.getAttachmentId())));
                    Path tmp = EditAttachmentDialogs.downloadInner(blocking, this.ctx, attachment);
                    try {
                        ArchiveEntry entry = zipOut.createArchiveEntry(tmp, attachment.getFilename(), new LinkOption[0]);
                        zipOut.putArchiveEntry(entry);
                        Files.copy(tmp, zipOut);
                        zipOut.closeArchiveEntry();
                        continue;
                    }
                    finally {
                        tmp.toFile().delete();
                    }
                }
                zipOut.finish();
            }
            catch (Exception ex) {
                Files.deleteIfExists(path);
                throw ex;
            }
            return null;
        });
        JOptionPane.showMessageDialog(this, "export complete", this.getTitle(), 1);
        this.close();
    }

    private void exportFolder() throws Exception {
        EFileChooser dialog = new EFileChooser();
        dialog.setDialogTitle(this.BUNDLE.getString("generic.button.export"));
        dialog.setFileSelectionMode(1);
        dialog.setSelectedFile(Path.of(".", new String[0]).toFile());
        Path path = dialog.open(this);
        if (path == null) {
            return;
        }
        EUtils.blocking((Component)this, blocking -> {
            ArrayList orders = (ArrayList)((Object)this.ctx.query(new SelectAll<Document>(Document.MODEL, new And(this.filter, new Span<LocalDate>(Document.COL_DATE, this.dateFrom.getDate(), true, this.dateUntil.getDate(), true)))));
            for (int i = 0; i < orders.size(); ++i) {
                Document document = (Document)orders.get(i);
                int num = i;
                SwingUtilities.invokeLater(() -> blocking.setStatus("Exporting... (" + (num + 1) + " / " + orders.size() + ")"));
                if (document.getAttachmentId() == null) continue;
                Attachment attachment = this.ctx.query(new Select<Attachment>(Attachment.MODEL, Attachment.COL_ID.with(document.getAttachmentId())));
                Path tmp = EditAttachmentDialogs.downloadInner(blocking, this.ctx, attachment);
                Files.move(tmp, path.resolve(attachment.getFilename()), new CopyOption[0]);
            }
            return null;
        });
        JOptionPane.showMessageDialog(this, "export complete", this.getTitle(), 1);
        this.close();
    }

    private void initialize() {
        this.panel = new JPanel();
        this.add((Component)this.panel, "Center");
        this.panel.setLayout(new MigLayout("", "[][grow]", "[][][][][][]"));
        this.lblFrom = new JLabel(this.BUNDLE.getString("generic.label.from") + ":");
        this.panel.add((Component)this.lblFrom, "cell 0 0,alignx trailing");
        this.dateFrom = new DatePicker();
        this.panel.add((Component)this.dateFrom, "cell 1 0,growx");
        this.lblUntil = new JLabel(this.BUNDLE.getString("generic.label.until") + ":");
        this.panel.add((Component)this.lblUntil, "cell 0 1,alignx trailing");
        this.dateUntil = new DatePicker();
        this.panel.add((Component)this.dateUntil, "cell 1 1,growx");
        this.lblOptions = new JLabel(this.BUNDLE.getString("generic.label.options") + ":");
        this.panel.add((Component)this.lblOptions, "cell 0 2,alignx trailing");
        this.chkExportTable = new JCheckBox(this.BUNDLE.getString("ExportDocumentsDialog.label.export_table"));
        this.chkExportTable.setSelected(true);
        this.panel.add((Component)this.chkExportTable, "cell 1 2");
        this.lblExportType = new JLabel(this.BUNDLE.getString("ExportDocumentsDialog.label.export_type") + ":");
        this.panel.add((Component)this.lblExportType, "cell 0 3,alignx trailing");
        this.rdExportSinglePDF = new JRadioButton(this.BUNDLE.getString("ExportDocumentsDialog.label.export_pdf"));
        this.rdExportSinglePDF.setSelected(true);
        this.panel.add((Component)this.rdExportSinglePDF, "cell 1 3");
        this.rdExportArchive = new JRadioButton(this.BUNDLE.getString("ExportDocumentsDialog.label.export_archive"));
        this.panel.add((Component)this.rdExportArchive, "cell 1 4");
        this.rdExportFolder = new JRadioButton(this.BUNDLE.getString("ExportDocumentsDialog.label.export_folder"));
        this.panel.add((Component)this.rdExportFolder, "cell 1 5");
        this.panel_bottom = new JPanel();
        FlowLayout fl_panel_bottom = (FlowLayout)this.panel_bottom.getLayout();
        fl_panel_bottom.setAlignment(2);
        this.add((Component)this.panel_bottom, "South");
        this.btnExport = new JButton(this.BUNDLE.getString("generic.button.export"));
        this.panel_bottom.add(this.btnExport);
        this.btnCancel = new JButton(this.BUNDLE.getString("generic.button.cancel"));
        this.panel_bottom.add(this.btnCancel);
    }
}

