/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import com.github.lgooddatepicker.components.DatePicker;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ShowReportDialog;
import de.inahware.dav.models.RecordCategory;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.types.Report;
import de.inahware.dav.models.types.ReportMethod;
import de.inahware.dav.requests.GenerateReport;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.SelectAll;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;

public class ExportReportDialog
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private List<RecordCategory> categories;
    private List<TaxRate> taxRates;
    private JPanel panel;
    private JLabel lblFrom;
    private JLabel lblUntil;
    private DatePicker dateFrom;
    private DatePicker dateUntil;
    private JPanel panel_bottom;
    private JButton btnCancel;
    private JButton btnExport;
    private JLabel lblMethod;
    private JRadioButton rdMethodRecord;
    private JRadioButton rdMethodBankStatement;
    private JRadioButton rdMethodBankStatementValue;

    public ExportReportDialog(Component parent, ClientContext ctx) throws Exception {
        EUtils.blocking(parent, blocking -> {
            this.categories = (List)((Object)ctx.query(new SelectAll<RecordCategory>(RecordCategory.MODEL)));
            this.taxRates = (List)((Object)ctx.query(new SelectAll<TaxRate>(TaxRate.MODEL)));
        });
        this.setTitle(this.BUNDLE.getString("generic.title.export") + " - " + this.BUNDLE.getString("Report"));
        this.setPacking(true);
        this.initialize();
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdMethodRecord);
        group.add(this.rdMethodBankStatement);
        group.add(this.rdMethodBankStatementValue);
        this.btnExport.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            ReportMethod method;
            if (this.rdMethodRecord.isSelected()) {
                method = ReportMethod.RECORD;
            } else if (this.rdMethodBankStatement.isSelected()) {
                method = ReportMethod.BANK_STATEMENT;
            } else if (this.rdMethodBankStatementValue.isSelected()) {
                method = ReportMethod.BANK_STATEMENT_VALUE;
            } else {
                return;
            }
            Report report = EUtils.blocking((Component)this, blocking -> ctx.query(new GenerateReport(this.dateFrom.getDate(), this.dateUntil.getDate(), method)));
            new ShowReportDialog(this.categories, this.taxRates, report).openPage(this);
        }));
        this.btnCancel.addActionListener(ev -> this.close());
    }

    private void initialize() {
        this.panel = new JPanel();
        this.add((Component)this.panel, "Center");
        this.panel.setLayout(new MigLayout("", "[][grow]", "[][][][][]"));
        this.lblFrom = new JLabel(this.BUNDLE.getString("generic.label.from") + ":");
        this.panel.add((Component)this.lblFrom, "cell 0 0,alignx trailing");
        this.dateFrom = new DatePicker();
        this.panel.add((Component)this.dateFrom, "cell 1 0,growx");
        this.lblUntil = new JLabel(this.BUNDLE.getString("generic.label.until") + ":");
        this.panel.add((Component)this.lblUntil, "cell 0 1,alignx trailing");
        this.dateUntil = new DatePicker();
        this.panel.add((Component)this.dateUntil, "cell 1 1,growx");
        this.lblMethod = new JLabel(this.BUNDLE.getString("ExportReportDialog.label.export_method") + ":");
        this.panel.add((Component)this.lblMethod, "cell 0 2");
        this.rdMethodRecord = new JRadioButton(this.BUNDLE.getString("ExportReportDialog.label.export_method.RECORD"));
        this.rdMethodRecord.setSelected(true);
        this.panel.add((Component)this.rdMethodRecord, "cell 1 2");
        this.rdMethodBankStatement = new JRadioButton(this.BUNDLE.getString("ExportReportDialog.label.export_method.BANK_STATEMENT"));
        this.panel.add((Component)this.rdMethodBankStatement, "cell 1 3");
        this.rdMethodBankStatementValue = new JRadioButton(this.BUNDLE.getString("ExportReportDialog.label.export_method.BANK_STATEMENT_VALUE"));
        this.panel.add((Component)this.rdMethodBankStatementValue, "cell 1 4");
        this.panel_bottom = new JPanel();
        FlowLayout fl_panel_bottom = (FlowLayout)this.panel_bottom.getLayout();
        fl_panel_bottom.setAlignment(2);
        this.add((Component)this.panel_bottom, "South");
        this.btnExport = new JButton(this.BUNDLE.getString("generic.button.export"));
        this.panel_bottom.add(this.btnExport);
        this.btnCancel = new JButton(this.BUNDLE.getString("generic.button.cancel"));
        this.panel_bottom.add(this.btnCancel);
    }
}

