/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ExportDialog;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.models.types.Contact;
import de.inahware.dav.models.types.ContactType;
import de.inahware.dav.models.types.Salutation;
import java.util.ResourceBundle;

public class ExportVendorsDialog
extends ExportDialog<Vendor> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ExportVendorsDialog(ClientContext ctx) throws Exception {
        super(ctx, Vendor.MODEL);
        this.setSize(1280, 720);
        this.addColumnType(Vendor.COL_ID, true);
        this.addColumnType(Vendor.COL_SALUTATION, true);
        this.addColumnType(Vendor.COL_PREFIX, true);
        this.addColumnType(Vendor.COL_LAST_NAME, true);
        this.addColumnType(Vendor.COL_FIRST_NAME, true);
        this.addColumnType(Vendor.COL_COMPANY, true);
        for (ContactType contactType : ContactType.values()) {
            this.addColumnType(contactType.getLocalizedString(this.BUNDLE), false, obj -> {
                Contact c = obj.getContactList().stream().filter(c2 -> c2.type == type).findAny().orElse(null);
                return c == null ? "" : c.value;
            });
        }
        this.getTablePanel().addSearchColumnLong(Vendor.COL_ID);
        this.getTablePanel().addSearchColumnString(Vendor.COL_PREFIX);
        this.getTablePanel().addSearchColumnString(Vendor.COL_LAST_NAME);
        this.getTablePanel().addSearchColumnString(Vendor.COL_FIRST_NAME);
        this.getTablePanel().addSearchColumnString(Vendor.COL_COMPANY);
        for (Enum enum_ : Salutation.values()) {
            this.getTablePanel().addSearchKeyword(((Salutation)enum_).getLocalizedString(this.BUNDLE), Vendor.COL_SALUTATION.with((Salutation)enum_));
        }
    }
}

