/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage img;
    private Image img_scaled;
    private int scaled_w;
    private int scaled_h;

    public ImagePanel(BufferedImage img) {
        this.setImage(img);
    }

    public void setImage(BufferedImage img) {
        this.img = img;
        this.img_scaled = null;
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.img;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        double scale = Math.min(1.0, Math.min((double)this.getWidth() / (double)this.img.getWidth(), (double)this.getHeight() / (double)this.img.getHeight()));
        int w = (int)(scale * (double)this.img.getWidth());
        int h = (int)(scale * (double)this.img.getHeight());
        if (this.img_scaled == null || this.scaled_w != w || this.scaled_h != h) {
            this.img_scaled = this.img.getScaledInstance(w, h, 4);
            this.scaled_w = w;
            this.scaled_h = h;
            System.out.println("scaled: " + w + ";" + h);
        }
        int x = this.getWidth() / 2 - w / 2;
        int y = this.getHeight() / 2 - h / 2;
        g.drawImage(this.img_scaled, x, y, null);
    }
}

