/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ImportDialog;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.ArticleGroup;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.types.ArticlePrice;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.SelectAll;
import java.awt.Component;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ImportArticlesDialog
extends ImportDialog<Article> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private Map<String, TaxRate> taxRate_by_name;
    private ArticleGroup group_root;
    private Map<Pair<Long, String>, ArticleGroup> group_map;

    public ImportArticlesDialog(Component parent, ClientContext ctx, Path csv, CSVFormat csv_format) throws Exception {
        super(ctx, Article.MODEL, csv, csv_format);
        EUtils.blocking(parent, blocking -> {
            List groups = (List)((Object)ctx.query(new SelectAll<ArticleGroup>(ArticleGroup.MODEL)));
            this.group_map = new HashMap<Pair<Long, String>, ArticleGroup>();
            for (ArticleGroup group : groups) {
                if (group.getParentId() == null) {
                    this.group_root = group;
                }
                this.group_map.put(new ImmutablePair<Long, String>(group.getParentId(), group.getTitle()), group);
            }
            List rates = (List)((Object)ctx.query(new SelectAll<TaxRate>(TaxRate.MODEL)));
            this.taxRate_by_name = new HashMap<String, TaxRate>();
            for (TaxRate next : rates) {
                if (!next.isEnabled().booleanValue()) continue;
                this.taxRate_by_name.put(next.getName(), next);
            }
        });
        this.addPrimaryColumnType(this.BUNDLE.getString("Article.ID"), field -> {
            long id = Long.parseLong(field);
            Article obj = ctx.query(new Select<Article>(Article.MODEL, Article.COL_ID.with(id)));
            if (obj != null) {
                this.doUpdate(new Article(obj), obj);
                return obj;
            }
            obj = new Article();
            obj.setId(id);
            this.doInsert(obj);
            return obj;
        });
        this.addPrimaryColumnType(this.BUNDLE.getString("Article.NUMBER"), field -> {
            Article obj = ctx.query(new Select<Article>(Article.MODEL, Article.COL_NUMBER.with((String)field)));
            if (obj != null) {
                this.doUpdate(new Article(obj), obj);
                return obj;
            }
            obj = new Article();
            obj.setNumber((String)field);
            this.doInsert(obj);
            return obj;
        });
        this.addColumnType(this.BUNDLE.getString("Article.GROUP"), (obj, value) -> {
            Long id = this.group_root.getId();
            for (String next : value.split("/")) {
                ImmutablePair<Long, String> key = new ImmutablePair<Long, String>(id, next = next.trim());
                if (!this.group_map.containsKey(key)) {
                    throw new RuntimeException("invalid group");
                }
                id = this.group_map.get(key).getId();
            }
            obj.setArticleGroupId(id);
        });
        this.addColumnType(this.BUNDLE.getString("Article.TITLE"), (obj, value) -> obj.setTitle((String)value));
        this.addColumnType(this.BUNDLE.getString("Article.PRICES"), (obj, value) -> {
            ArrayList<ArticlePrice> prices = new ArrayList<ArticlePrice>();
            for (String next : value.split(";")) {
                String[] split = next.trim().split(" ", 2);
                ArticlePrice price = new ArticlePrice(I18N.parseDecimal(split[0]), "");
                if (split.length > 1) {
                    price.comment = split[1];
                }
                prices.add(price);
            }
            obj.setPriceList(prices);
        });
        this.addColumnType(this.BUNDLE.getString("Article.UNIT"), (obj, value) -> obj.setUnit((String)value));
        this.addColumnType(this.BUNDLE.getString("Article.TAXRATE"), (obj, value) -> {
            if (!this.taxRate_by_name.containsKey(value)) {
                throw new RuntimeException("invalid taxrate");
            }
            obj.setTaxRate(this.taxRate_by_name.get(value).getId());
        });
        this.addColumnType(this.BUNDLE.getString("Article.DESCRIPTION"), (obj, value) -> obj.setDescription((String)value));
    }

    @Override
    protected Article initDefault() throws Exception {
        Article obj = new Article();
        this.doInsert(obj);
        return obj;
    }
}

